/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.log.Logger;
import com.facebook.drift.TException;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.client.ConnectionFailedException;
import com.facebook.drift.transport.client.InvokeRequest;
import com.facebook.drift.transport.netty.client.ConnectionManager;
import com.facebook.drift.transport.netty.client.ThriftClientHandler;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class InvocationResponseFuture
extends AbstractFuture<Object> {
    private static final Logger log = Logger.get(InvocationResponseFuture.class);
    private final InvokeRequest request;
    private final ConnectionManager.ConnectionParameters connectionParameters;
    private final ConnectionManager connectionManager;
    @GuardedBy(value="this")
    private Future<Channel> connectionFuture;
    @GuardedBy(value="this")
    private ThriftClientHandler.ThriftRequest thriftRequest;

    static InvocationResponseFuture createInvocationResponseFuture(InvokeRequest request, ConnectionManager.ConnectionParameters connectionParameters, ConnectionManager connectionManager) throws TException {
        Optional encryptionRequired = request.getAddress().isEncryptionRequired();
        if (encryptionRequired.isPresent() && ((Boolean)encryptionRequired.get()).booleanValue() && !connectionParameters.getSslContextParameters().isPresent()) {
            throw new TException(String.format("Encrypted connection is requested to connect to %s but encryption is not configured for this Drift client instance", request.getAddress().getHostAndPort()));
        }
        if (encryptionRequired.isPresent() && !((Boolean)encryptionRequired.get()).booleanValue()) {
            log.debug("Disabling SSL method %s address %s request %s", new Object[]{request.getMethod(), request.getAddress(), request.toString()});
            connectionParameters = new ConnectionManager.ConnectionParameters(connectionParameters.getTransport(), connectionParameters.getProtocol(), connectionParameters.getMaxFrameSize(), connectionParameters.getConnectTimeout(), connectionParameters.getRequestTimeout(), connectionParameters.getSocksProxy(), Optional.empty(), connectionParameters.isTcpNoDelayEnabled(), connectionParameters.isReuseAddressEnabled());
        }
        InvocationResponseFuture future = new InvocationResponseFuture(request, connectionParameters, connectionManager);
        future.tryConnect();
        return future;
    }

    private InvocationResponseFuture(InvokeRequest request, ConnectionManager.ConnectionParameters connectionParameters, ConnectionManager connectionManager) {
        this.request = Objects.requireNonNull(request, "request is null");
        this.connectionParameters = Objects.requireNonNull(connectionParameters, "connectionConfig is null");
        this.connectionManager = Objects.requireNonNull(connectionManager, "connectionManager is null");
        super.addListener(() -> {
            if (super.isCancelled()) {
                this.onCancel(this.wasInterrupted());
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized void tryConnect() {
        try {
            this.connectionFuture = this.connectionManager.getConnection(this.connectionParameters, this.request.getAddress().getHostAndPort());
            this.connectionFuture.addListener(channelFuture -> {
                try {
                    if (channelFuture.isSuccess()) {
                        this.tryInvocation((Channel)channelFuture.getNow());
                    } else {
                        this.fatalError((Throwable)new ConnectionFailedException(this.request.getAddress(), channelFuture.cause()));
                    }
                }
                catch (Throwable t) {
                    this.fatalError(t);
                }
            });
        }
        catch (Throwable t) {
            this.fatalError(t);
        }
    }

    private synchronized void tryInvocation(final Channel channel) {
        if (this.isCancelled()) {
            this.connectionManager.returnConnection(channel);
            return;
        }
        try {
            this.thriftRequest = new ThriftClientHandler.ThriftRequest(this.request.getMethod(), this.request.getParameters(), this.request.getHeaders());
            Futures.addCallback((ListenableFuture)this.thriftRequest, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    try {
                        InvocationResponseFuture.this.connectionManager.returnConnection(channel);
                        InvocationResponseFuture.this.set(result);
                    }
                    catch (Throwable t) {
                        InvocationResponseFuture.this.fatalError(t);
                    }
                }

                public void onFailure(Throwable t) {
                    try {
                        InvocationResponseFuture.this.connectionManager.returnConnection(channel);
                    }
                    finally {
                        InvocationResponseFuture.this.fatalError(t);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
            ChannelFuture sendFuture = channel.writeAndFlush((Object)this.thriftRequest);
            sendFuture.addListener(channelFuture -> {
                try {
                    if (!channelFuture.isSuccess()) {
                        this.fatalError(channelFuture.cause());
                    }
                }
                catch (Throwable t) {
                    this.fatalError(t);
                }
            });
        }
        catch (Throwable t) {
            try {
                this.connectionManager.returnConnection(channel);
            }
            finally {
                this.fatalError(t);
            }
        }
    }

    private synchronized void onCancel(boolean wasInterrupted) {
        if (this.connectionFuture != null) {
            this.connectionFuture.cancel(wasInterrupted);
        }
        if (this.thriftRequest != null) {
            this.thriftRequest.cancel(wasInterrupted);
        }
    }

    private void fatalError(Throwable throwable) {
        if (throwable instanceof IOException) {
            throwable = new TTransportException(throwable);
        }
        if (!(throwable instanceof Error) && !(throwable instanceof TException)) {
            throwable = new TException(throwable);
        }
        this.setException(throwable);
    }
}

