/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;

enum BuiltinColumns {
    ID("_id", (Type)VarcharType.VARCHAR, true),
    SOURCE("_source", (Type)VarcharType.VARCHAR, false),
    SCORE("_score", (Type)RealType.REAL, false);

    public static final Set<String> NAMES;
    private final String name;
    private final Type type;
    private final boolean supportsPredicates;

    private BuiltinColumns(String name, Type type, boolean supportsPredicates) {
        this.name = name;
        this.type = type;
        this.supportsPredicates = supportsPredicates;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public ColumnMetadata getMetadata() {
        return new ColumnMetadata(this.name, this.type, "", null, true);
    }

    public ColumnHandle getColumnHandle() {
        return new ElasticsearchColumnHandle(this.name, this.type, this.supportsPredicates);
    }

    static {
        NAMES = (Set)Arrays.stream(BuiltinColumns.values()).map(BuiltinColumns::getName).collect(ImmutableSet.toImmutableSet());
    }
}

