/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.common.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public final class ElasticsearchColumn {
    private final String name;
    private final Type type;
    private final String jsonPath;
    private final String jsonType;
    private final int ordinalPosition;

    @JsonCreator
    public ElasticsearchColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="jsonPath") String jsonPath, @JsonProperty(value="jsonType") String jsonType, @JsonProperty(value="ordinalPosition") int ordinalPosition) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.type = Objects.requireNonNull(type, "type is null");
        this.jsonPath = Objects.requireNonNull(jsonPath, "jsonPath is null");
        this.jsonType = Objects.requireNonNull(jsonType, "jsonType is null");
        this.ordinalPosition = ordinalPosition;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public String getJsonPath() {
        return this.jsonPath;
    }

    @JsonProperty
    public String getJsonType() {
        return this.jsonType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.jsonPath, this.jsonType, this.ordinalPosition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElasticsearchColumn other = (ElasticsearchColumn)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.jsonPath, other.jsonPath) && Objects.equals(this.jsonType, other.jsonType) && Objects.equals(this.ordinalPosition, other.ordinalPosition);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("jsonPath", (Object)this.jsonPath).add("jsonType", (Object)this.jsonType).add("ordinalPosition", this.ordinalPosition).toString();
    }
}

