/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.elasticsearch.BuiltinColumns;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.elasticsearch.ElasticsearchConfig;
import com.facebook.presto.elasticsearch.ElasticsearchTableHandle;
import com.facebook.presto.elasticsearch.ElasticsearchTableLayoutHandle;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.facebook.presto.elasticsearch.client.IndexMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ElasticsearchMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(ElasticsearchMetadata.class);
    private static final ObjectMapper JSON_PARSER = new JsonObjectMapperProvider().get();
    private static final String PASSTHROUGH_QUERY_SUFFIX = "$query";
    private final Map<String, ColumnHandle> queryTableColumns;
    private final ColumnMetadata queryResultColumnMetadata;
    private final ElasticsearchClient client;
    private final String schemaName;
    private final Type ipAddressType;

    @Inject
    public ElasticsearchMetadata(TypeManager typeManager, ElasticsearchClient client, ElasticsearchConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.ipAddressType = typeManager.getType(new TypeSignature("ipaddress", new TypeSignatureParameter[0]));
        this.client = Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(config, "config is null");
        this.schemaName = config.getDefaultSchema();
        Type jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        this.queryResultColumnMetadata = ColumnMetadata.builder().setName("result").setType(jsonType).setNullable(true).setHidden(false).build();
        this.queryTableColumns = ImmutableMap.of((Object)"result", (Object)new ElasticsearchColumnHandle("result", jsonType, false));
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)this.schemaName);
    }

    public ElasticsearchTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.getSchemaName().equals(this.schemaName)) {
            String[] parts = tableName.getTableName().split(":", 2);
            String table = parts[0];
            Optional<String> query = Optional.empty();
            ElasticsearchTableHandle.Type type = ElasticsearchTableHandle.Type.SCAN;
            if (parts.length == 2) {
                if (table.endsWith(PASSTHROUGH_QUERY_SUFFIX)) {
                    byte[] decoded;
                    table = table.substring(0, table.length() - PASSTHROUGH_QUERY_SUFFIX.length());
                    try {
                        decoded = BaseEncoding.base32().decode((CharSequence)parts[1].toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Elasticsearch query for '%s' is not base32-encoded correctly", table), (Throwable)e);
                    }
                    String queryJson = new String(decoded, StandardCharsets.UTF_8);
                    try {
                        JSON_PARSER.readTree(queryJson);
                    }
                    catch (JsonProcessingException e) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Elasticsearch query for '%s' is not valid JSON", table), (Throwable)e);
                    }
                    query = Optional.of(queryJson);
                    type = ElasticsearchTableHandle.Type.QUERY;
                } else {
                    query = Optional.of(parts[1]);
                }
            }
            if (this.listTables(session, Optional.of(this.schemaName)).contains(new SchemaTableName(this.schemaName, table))) {
                return new ElasticsearchTableHandle(type, this.schemaName, table, query);
            }
        }
        return null;
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new ElasticsearchTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        if (ElasticsearchMetadata.isPassthroughQuery(handle)) {
            return new ConnectorTableMetadata(new SchemaTableName(handle.getSchema(), handle.getIndex()), (List)ImmutableList.of((Object)this.queryResultColumnMetadata));
        }
        return this.getTableMetadata(handle.getSchema(), handle.getIndex());
    }

    private ConnectorTableMetadata getTableMetadata(String schemaName, String tableName) {
        InternalTableMetadata internalTableMetadata = this.makeInternalTableMetadata(schemaName, tableName);
        return new ConnectorTableMetadata(new SchemaTableName(schemaName, tableName), internalTableMetadata.getColumnMetadata());
    }

    private InternalTableMetadata makeInternalTableMetadata(ConnectorTableHandle table) {
        ElasticsearchTableHandle handle = (ElasticsearchTableHandle)table;
        return this.makeInternalTableMetadata(handle.getSchema(), handle.getIndex());
    }

    private InternalTableMetadata makeInternalTableMetadata(String schema, String tableName) {
        IndexMetadata metadata = this.client.getIndexMetadata(tableName);
        List<IndexMetadata.Field> fields = this.getColumnFields(metadata);
        return new InternalTableMetadata(new SchemaTableName(schema, tableName), this.makeColumnMetadata(fields), this.makeColumnHandles(fields));
    }

    private List<IndexMetadata.Field> getColumnFields(IndexMetadata metadata) {
        ImmutableList.Builder result = ImmutableList.builder();
        Map<String, Long> counts = metadata.getSchema().getFields().stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(Locale.ENGLISH), Collectors.counting()));
        for (IndexMetadata.Field field : metadata.getSchema().getFields()) {
            Type type = this.toPrestoType(field);
            if (type == null || counts.get(field.getName().toLowerCase(Locale.ENGLISH)) > 1L) continue;
            result.add((Object)field);
        }
        return result.build();
    }

    private List<ColumnMetadata> makeColumnMetadata(List<IndexMetadata.Field> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (BuiltinColumns builtinColumn : BuiltinColumns.values()) {
            result.add((Object)builtinColumn.getMetadata());
        }
        for (IndexMetadata.Field field : fields) {
            result.add((Object)new ColumnMetadata(field.getName(), this.toPrestoType(field)));
        }
        return result.build();
    }

    private Map<String, ColumnHandle> makeColumnHandles(List<IndexMetadata.Field> fields) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (BuiltinColumns builtinColumn : BuiltinColumns.values()) {
            result.put((Object)builtinColumn.getName(), (Object)builtinColumn.getColumnHandle());
        }
        for (IndexMetadata.Field field : fields) {
            result.put((Object)field.getName(), (Object)new ElasticsearchColumnHandle(field.getName(), this.toPrestoType(field), ElasticsearchMetadata.supportsPredicates(field.getType())));
        }
        return result.build();
    }

    private static boolean supportsPredicates(IndexMetadata.Type type) {
        if (type instanceof IndexMetadata.DateTimeType) {
            return true;
        }
        if (type instanceof IndexMetadata.PrimitiveType) {
            switch (((IndexMetadata.PrimitiveType)type).getName().toLowerCase(Locale.ENGLISH)) {
                case "boolean": 
                case "byte": 
                case "short": 
                case "integer": 
                case "long": 
                case "double": 
                case "float": 
                case "keyword": {
                    return true;
                }
            }
        }
        return false;
    }

    private Type toPrestoType(IndexMetadata.Field metaDataField) {
        return this.toPrestoType(metaDataField, metaDataField.isArray());
    }

    private Type toPrestoType(IndexMetadata.Field metaDataField, boolean isArray) {
        IndexMetadata.Type type = metaDataField.getType();
        if (isArray) {
            Type elementType = this.toPrestoType(metaDataField, false);
            return new ArrayType(elementType);
        }
        if (type instanceof IndexMetadata.PrimitiveType) {
            switch (((IndexMetadata.PrimitiveType)type).getName()) {
                case "float": {
                    return RealType.REAL;
                }
                case "double": {
                    return DoubleType.DOUBLE;
                }
                case "byte": {
                    return TinyintType.TINYINT;
                }
                case "short": {
                    return SmallintType.SMALLINT;
                }
                case "integer": {
                    return IntegerType.INTEGER;
                }
                case "long": {
                    return BigintType.BIGINT;
                }
                case "string": 
                case "text": 
                case "keyword": {
                    return VarcharType.VARCHAR;
                }
                case "boolean": {
                    return BooleanType.BOOLEAN;
                }
                case "binary": {
                    return VarbinaryType.VARBINARY;
                }
                case "ip": {
                    return this.ipAddressType;
                }
            }
        } else if (type instanceof IndexMetadata.DateTimeType) {
            if (((IndexMetadata.DateTimeType)type).getFormats().isEmpty()) {
                return TimestampType.TIMESTAMP;
            }
        } else if (type instanceof IndexMetadata.ObjectType) {
            IndexMetadata.ObjectType objectType = (IndexMetadata.ObjectType)type;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexMetadata.Field field : objectType.getFields()) {
                Type prestoType = this.toPrestoType(field);
                if (prestoType != null) {
                    builder.add((Object)RowType.field((String)field.getName(), (Type)prestoType));
                    continue;
                }
                log.warn("Type is not implemented: %s", new Object[]{field.getType()});
            }
            ImmutableList fields = builder.build();
            if (!fields.isEmpty()) {
                return RowType.from((List)fields);
            }
        }
        return null;
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && !schemaName.get().equals(this.schemaName)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableSet indexes = ImmutableSet.copyOf(this.client.getIndexes());
        indexes.stream().map(index -> new SchemaTableName(this.schemaName, index)).forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        this.client.getAliases().entrySet().stream().filter(arg_0 -> ElasticsearchMetadata.lambda$listTables$2((Set)indexes, arg_0)).flatMap(entry -> ((List)entry.getValue()).stream().map(alias -> new SchemaTableName(this.schemaName, alias))).distinct().forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        return result.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ElasticsearchTableHandle table = (ElasticsearchTableHandle)tableHandle;
        if (ElasticsearchMetadata.isPassthroughQuery(table)) {
            return this.queryTableColumns;
        }
        InternalTableMetadata tableMetadata = this.makeInternalTableMetadata(tableHandle);
        return tableMetadata.getColumnHandles();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        ElasticsearchTableHandle table = (ElasticsearchTableHandle)tableHandle;
        ElasticsearchColumnHandle column = (ElasticsearchColumnHandle)columnHandle;
        if (ElasticsearchMetadata.isPassthroughQuery(table)) {
            if (column.getName().equals(this.queryResultColumnMetadata.getName())) {
                return this.queryResultColumnMetadata;
            }
            throw new IllegalArgumentException(String.format("Unexpected column for table '%s$query': %s", table.getIndex(), column.getName()));
        }
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).build();
    }

    private static boolean isPassthroughQuery(ElasticsearchTableHandle table) {
        return table.getType().equals((Object)ElasticsearchTableHandle.Type.QUERY);
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() != null && !prefix.getSchemaName().equals(this.schemaName)) {
            return ImmutableMap.of();
        }
        if (prefix.getSchemaName() != null && prefix.getTableName() != null) {
            ConnectorTableMetadata metadata = this.getTableMetadata(prefix.getSchemaName(), prefix.getTableName());
            return ImmutableMap.of((Object)metadata.getTable(), (Object)metadata.getColumns());
        }
        return (Map)this.listTables(session, prefix.getSchemaName()).stream().map(name -> this.getTableMetadata(name.getSchemaName(), name.getTableName())).collect(ImmutableMap.toImmutableMap(ConnectorTableMetadata::getTable, ConnectorTableMetadata::getColumns));
    }

    private static /* synthetic */ boolean lambda$listTables$2(Set indexes, Map.Entry entry) {
        return indexes.contains(entry.getKey());
    }

    private static class InternalTableMetadata {
        private final SchemaTableName tableName;
        private final List<ColumnMetadata> columnMetadata;
        private final Map<String, ColumnHandle> columnHandles;

        public InternalTableMetadata(SchemaTableName tableName, List<ColumnMetadata> columnMetadata, Map<String, ColumnHandle> columnHandles) {
            this.tableName = tableName;
            this.columnMetadata = columnMetadata;
            this.columnHandles = columnHandles;
        }

        public SchemaTableName getTableName() {
            return this.tableName;
        }

        public List<ColumnMetadata> getColumnMetadata() {
            return this.columnMetadata;
        }

        public Map<String, ColumnHandle> getColumnHandles() {
            return this.columnHandles;
        }
    }
}

