/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.elasticsearch.ElasticsearchColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;

public final class ElasticsearchQueryBuilder {
    private ElasticsearchQueryBuilder() {
    }

    public static QueryBuilder buildSearchQuery(ConnectorSession session, TupleDomain<ElasticsearchColumnHandle> constraint, Optional<String> query) {
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
        if (constraint.getDomains().isPresent()) {
            for (Map.Entry entry : ((Map)constraint.getDomains().get()).entrySet()) {
                ElasticsearchColumnHandle column = (ElasticsearchColumnHandle)entry.getKey();
                Domain domain = (Domain)entry.getValue();
                Preconditions.checkArgument((!domain.isNone() ? 1 : 0) != 0, (String)"Unexpected NONE domain for %s", (Object)column.getName());
                if (domain.isAll()) continue;
                queryBuilder.filter((QueryBuilder)new BoolQueryBuilder().must(ElasticsearchQueryBuilder.buildPredicate(session, column.getName(), domain, column.getType())));
            }
        }
        query.map(QueryStringQueryBuilder::new).ifPresent(arg_0 -> ((BoolQueryBuilder)queryBuilder).must(arg_0));
        if (queryBuilder.hasClauses()) {
            return queryBuilder;
        }
        return new MatchAllQueryBuilder();
    }

    private static QueryBuilder buildPredicate(ConnectorSession session, String columnName, Domain domain, Type type) {
        Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        if (domain.getValues().isNone()) {
            boolQueryBuilder.mustNot((QueryBuilder)new ExistsQueryBuilder(columnName));
            return boolQueryBuilder;
        }
        if (domain.getValues().isAll()) {
            boolQueryBuilder.must((QueryBuilder)new ExistsQueryBuilder(columnName));
            return boolQueryBuilder;
        }
        return ElasticsearchQueryBuilder.buildTermQuery(boolQueryBuilder, session, columnName, domain, type);
    }

    private static QueryBuilder buildTermQuery(BoolQueryBuilder queryBuilder, ConnectorSession session, String columnName, Domain domain, Type type) {
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            BoolQueryBuilder rangeQueryBuilder = new BoolQueryBuilder();
            HashSet<Object> valuesToInclude = new HashSet<Object>();
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0, (Object)("Invalid range for column: " + columnName));
            if (range.isSingleValue()) {
                valuesToInclude.add(range.getSingleValue());
            } else {
                if (!range.isLowUnbounded()) {
                    Object lowBound = ElasticsearchQueryBuilder.getValue(session, type, range.getLowBoundedValue());
                    if (range.isLowInclusive()) {
                        rangeQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(columnName).gte(lowBound));
                    } else {
                        rangeQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(columnName).gt(lowBound));
                    }
                }
                if (!range.isHighUnbounded()) {
                    Object highBound = ElasticsearchQueryBuilder.getValue(session, type, range.getHighBoundedValue());
                    if (range.isHighInclusive()) {
                        rangeQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(columnName).lte(highBound));
                    } else {
                        rangeQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(columnName).lt(highBound));
                    }
                }
            }
            if (valuesToInclude.size() == 1) {
                rangeQueryBuilder.filter((QueryBuilder)new TermQueryBuilder(columnName, ElasticsearchQueryBuilder.getValue(session, type, Iterables.getOnlyElement(valuesToInclude))));
            }
            queryBuilder.should((QueryBuilder)rangeQueryBuilder);
        }
        if (domain.isNullAllowed()) {
            queryBuilder.should((QueryBuilder)new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(columnName)));
        }
        return queryBuilder;
    }

    private static Object getValue(ConnectorSession session, Type type, Object value) {
        if (type.equals(BooleanType.BOOLEAN) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(DoubleType.DOUBLE)) {
            return value;
        }
        if (type.equals(RealType.REAL)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return ((Slice)value).toStringUtf8();
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            Preconditions.checkState((boolean)session.getSqlFunctionProperties().isLegacyTimestamp(), (Object)"New timestamp semantics not yet supported");
            return Instant.ofEpochMilli((Long)value).atZone(ZoneId.of(session.getSqlFunctionProperties().getTimeZoneKey().getId())).toLocalDateTime().format(DateTimeFormatter.ISO_DATE_TIME);
        }
        throw new IllegalArgumentException("Unhandled type: " + type);
    }
}

