/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.elasticsearch.ElasticsearchTableHandle;
import com.facebook.presto.elasticsearch.client.ElasticsearchClient;
import com.facebook.presto.spi.ConnectorPageSource;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class PassthroughQueryPageSource
implements ConnectorPageSource {
    private final long readTimeNanos;
    private final String result;
    private final Type jsonType;
    private boolean done;

    public PassthroughQueryPageSource(ElasticsearchClient client, ElasticsearchTableHandle table, Type jsonType) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(table, "table is null");
        this.jsonType = Objects.requireNonNull(jsonType, "jsonType is null");
        long start = System.nanoTime();
        this.result = client.executeQuery(table.getIndex(), table.getQuery().get());
        this.readTimeNanos = System.nanoTime() - start;
    }

    public long getCompletedBytes() {
        return this.result.length();
    }

    public long getCompletedPositions() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.done;
    }

    public Page getNextPage() {
        if (this.done) {
            return null;
        }
        this.done = true;
        PageBuilder page = new PageBuilder(1, (List)ImmutableList.of((Object)this.jsonType));
        page.declarePosition();
        BlockBuilder column = page.getBlockBuilder(0);
        this.jsonType.writeSlice(column, Slices.utf8Slice((String)this.result));
        return page.build();
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

