/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch.decoders;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.elasticsearch.ElasticsearchErrorCode;
import com.facebook.presto.elasticsearch.decoders.Decoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class ArrayDecoder
implements Decoder {
    private final String path;
    private final Decoder elementDecoder;

    public ArrayDecoder(String path, Decoder elementDecoder) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.elementDecoder = elementDecoder;
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object data = getter.get();
        if (data == null) {
            output.appendNull();
        } else if (data instanceof List) {
            BlockBuilder array = output.beginBlockEntry();
            ((List)data).forEach(element -> this.elementDecoder.decode(hit, () -> element, array));
            output.closeEntry();
        } else {
            throw new PrestoException((ErrorCodeSupplier)ElasticsearchErrorCode.ELASTICSEARCH_TYPE_MISMATCH, String.format("Expected list of elements for field '%s' of type ARRAY: %s [%s]", this.path, data, data.getClass().getSimpleName()));
        }
    }
}

