/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.elasticsearch.decoders;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.elasticsearch.ElasticsearchErrorCode;
import com.facebook.presto.elasticsearch.decoders.Decoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.search.SearchHit;

public class IpAddressDecoder
implements Decoder {
    private final String path;
    private final Type ipAddressType;

    public IpAddressDecoder(String path, Type type) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.ipAddressType = Objects.requireNonNull(type, "type is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else if (value instanceof String) {
            String address = (String)value;
            Slice slice = this.castToIpAddress(Slices.utf8Slice((String)address));
            this.ipAddressType.writeSlice(output, slice);
        } else {
            throw new PrestoException((ErrorCodeSupplier)ElasticsearchErrorCode.ELASTICSEARCH_TYPE_MISMATCH, String.format("Expected a string value for field '%s' of type IP: %s [%s]", this.path, value, value.getClass().getSimpleName()));
        }
    }

    private Slice castToIpAddress(Slice slice) {
        byte[] bytes;
        byte[] address;
        try {
            address = InetAddresses.forString((String)slice.toStringUtf8()).getAddress();
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast value to IPADDRESS: " + slice.toStringUtf8());
        }
        if (address.length == 4) {
            bytes = new byte[16];
            bytes[10] = -1;
            bytes[11] = -1;
            System.arraycopy(address, 0, bytes, 12, 4);
        } else if (address.length == 16) {
            bytes = address;
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid InetAddress length: " + address.length);
        }
        return Slices.wrappedBuffer((byte[])bytes);
    }
}

