/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.plugin.jdbc.BooleanReadFunction;
import com.facebook.presto.plugin.jdbc.DoubleReadFunction;
import com.facebook.presto.plugin.jdbc.LongReadFunction;
import com.facebook.presto.plugin.jdbc.ReadFunction;
import com.facebook.presto.plugin.jdbc.SliceReadFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ReadMapping {
    private final Type type;
    private final ReadFunction readFunction;

    public static ReadMapping booleanReadMapping(Type prestoType, BooleanReadFunction readFunction) {
        return new ReadMapping(prestoType, readFunction);
    }

    public static ReadMapping longReadMapping(Type prestoType, LongReadFunction readFunction) {
        return new ReadMapping(prestoType, readFunction);
    }

    public static ReadMapping doubleReadMapping(Type prestoType, DoubleReadFunction readFunction) {
        return new ReadMapping(prestoType, readFunction);
    }

    public static ReadMapping sliceReadMapping(Type prestoType, SliceReadFunction readFunction) {
        return new ReadMapping(prestoType, readFunction);
    }

    private ReadMapping(Type type, ReadFunction readFunction) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.readFunction = Objects.requireNonNull(readFunction, "readFunction is null");
        Preconditions.checkArgument((type.getJavaType() == readFunction.getJavaType() ? 1 : 0) != 0, (String)"Presto type %s is not compatible with read function %s returning %s", (Object)type, (Object)readFunction, readFunction.getJavaType());
    }

    public Type getType() {
        return this.type;
    }

    public ReadFunction getReadFunction() {
        return this.readFunction;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }
}

