/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapCompactOrderedSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;

final class ForwardCompatibility {
    ForwardCompatibility() {
    }

    static final CompactSketch heapify1to3(Memory srcMem, long seed) {
        long thetaLong;
        int memCap = (int)srcMem.getCapacity();
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        if (preLongs != 3) {
            throw new SketchesArgumentException("PreLongs must be 3 for SerVer 1: " + preLongs);
        }
        int curCount = PreambleUtil.extractCurCount(srcMem);
        boolean empty = Sketch.emptyFromCountAndTheta(curCount, thetaLong = PreambleUtil.extractThetaLong(srcMem));
        if (empty || memCap <= 24) {
            return EmptyCompactSketch.getInstance();
        }
        int reqCap = curCount + preLongs << 3;
        ForwardCompatibility.validateInputSize(reqCap, memCap);
        if (thetaLong == Long.MAX_VALUE && curCount == 1) {
            long hash = srcMem.getLong((long)(preLongs << 3));
            return new SingleItemSketch(hash, seed);
        }
        short seedHash = Util.computeSeedHash(seed);
        long[] compactOrderedCache = new long[curCount];
        srcMem.getLongArray((long)(preLongs << 3), compactOrderedCache, 0, curCount);
        return HeapCompactOrderedSketch.compact(compactOrderedCache, false, seedHash, curCount, thetaLong);
    }

    static final CompactSketch heapify2to3(Memory srcMem, long seed) {
        short seedHash = Util.computeSeedHash(seed);
        short memSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
        Util.checkSeedHashes(seedHash, memSeedHash);
        int memCap = (int)srcMem.getCapacity();
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int reqBytesIn = 8;
        int curCount = 0;
        long thetaLong = Long.MAX_VALUE;
        if (preLongs == 1) {
            reqBytesIn = 8;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            return EmptyCompactSketch.getInstance();
        }
        if (preLongs == 2) {
            reqBytesIn = preLongs << 3;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            curCount = PreambleUtil.extractCurCount(srcMem);
            if (curCount == 0) {
                return EmptyCompactSketch.getInstance();
            }
            if (curCount == 1) {
                reqBytesIn = preLongs + 1 << 3;
                ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
                long hash = srcMem.getLong((long)(preLongs << 3));
                return new SingleItemSketch(hash, seed);
            }
            reqBytesIn = curCount + preLongs << 3;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            long[] compactOrderedCache = new long[curCount];
            srcMem.getLongArray((long)(preLongs << 3), compactOrderedCache, 0, curCount);
            return HeapCompactOrderedSketch.compact(compactOrderedCache, false, seedHash, curCount, thetaLong);
        }
        if (preLongs == 3) {
            reqBytesIn = preLongs << 3;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            curCount = PreambleUtil.extractCurCount(srcMem);
            thetaLong = PreambleUtil.extractThetaLong(srcMem);
            if (curCount == 0 && thetaLong == Long.MAX_VALUE) {
                return EmptyCompactSketch.getInstance();
            }
            if (curCount == 1 && thetaLong == Long.MAX_VALUE) {
                reqBytesIn = preLongs + 1 << 3;
                ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
                long hash = srcMem.getLong((long)(preLongs << 3));
                return new SingleItemSketch(hash, seed);
            }
            reqBytesIn = curCount + preLongs << 3;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            long[] compactOrderedCache = new long[curCount];
            srcMem.getLongArray((long)(preLongs << 3), compactOrderedCache, 0, curCount);
            return HeapCompactOrderedSketch.compact(compactOrderedCache, false, seedHash, curCount, thetaLong);
        }
        throw new SketchesArgumentException("PreLongs must be 1,2, or 3: " + preLongs);
    }

    private static final void validateInputSize(int reqBytesIn, int memCap) {
        if (reqBytesIn > memCap) {
            throw new SketchesArgumentException("Input Memory or byte[] size is too small: Required Bytes: " + reqBytesIn + ", bytesIn: " + memCap);
        }
    }
}

