/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.clusterttlproviders.percentile;

import com.facebook.presto.clusterttlproviders.percentile.PercentileBasedClusterTtlProviderConfig;
import com.facebook.presto.spi.ttl.ClusterTtlProvider;
import com.facebook.presto.spi.ttl.ConfidenceBasedTtlInfo;
import com.facebook.presto.spi.ttl.NodeTtl;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PercentileBasedClusterTtlProvider
implements ClusterTtlProvider {
    private final Comparator<ConfidenceBasedTtlInfo> ttlComparator = Comparator.comparing(ConfidenceBasedTtlInfo::getExpiryInstant);
    private final int percentile;

    @Inject
    public PercentileBasedClusterTtlProvider(PercentileBasedClusterTtlProviderConfig config) {
        Objects.requireNonNull(config, "config is null");
        Preconditions.checkArgument((config.getPercentile() > 0 ? 1 : 0) != 0, (Object)"percentile should be greater than 0");
        this.percentile = config.getPercentile();
    }

    public ConfidenceBasedTtlInfo getClusterTtl(List<NodeTtl> nodeTtls) {
        List ttls = nodeTtls.stream().map(this::getMinTtl).filter(Optional::isPresent).map(Optional::get).sorted(this.ttlComparator).collect(Collectors.toList());
        if (ttls.size() == 0) {
            return new ConfidenceBasedTtlInfo(0L, 100.0);
        }
        return (ConfidenceBasedTtlInfo)ttls.get((int)Math.ceil((double)(ttls.size() * this.percentile) / 100.0) - 1);
    }

    private Optional<ConfidenceBasedTtlInfo> getMinTtl(NodeTtl nodeTtl) {
        return nodeTtl.getTtlInfo().stream().min(this.ttlComparator);
    }
}

