/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.facebook.presto.hive.$internal.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.debug.Utils;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.WriteBuffers;

public final class BytesBytesMultiHashMap
implements MemoryEstimate {
    public static final Logger LOG = LoggerFactory.getLogger(BytesBytesMultiHashMap.class);
    private WriteBuffers writeBuffers;
    private final float loadFactor;
    private int resizeThreshold;
    private int keysAssigned;
    private int numValues;
    private int largestNumberOfSteps = 0;
    private long[] refs;
    private int startingHashBitCount;
    private int hashBitCount;
    private int metricPutConflict = 0;
    private int metricGetConflict = 0;
    private int metricExpands = 0;
    private int metricExpandsMs = 0;
    static final long MAX_WB_SIZE = 0x4000000000L;
    private static final int DEFAULT_MAX_CAPACITY = 0x40000000;
    private static final int DEFAULT_MIN_MAX_CAPACITY = 0x1000000;
    private static final byte[] FOUR_ZEROES = new byte[]{0, 0, 0, 0};
    private static final byte[] FIVE_ZEROES = new byte[]{0, 0, 0, 0, 0};

    public BytesBytesMultiHashMap(int initialCapacity, float loadFactor, int wbSize, long maxProbeSize) {
        int maxCapacity;
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            throw new AssertionError((Object)"Load factor must be between (0, 1].");
        }
        assert (initialCapacity > 0);
        initialCapacity = Long.bitCount(initialCapacity) == 1 ? initialCapacity : BytesBytesMultiHashMap.nextHighestPowerOfTwo(initialCapacity);
        int n = maxCapacity = maxProbeSize <= 0L ? 0x40000000 : (int)Math.min(0x40000000L, maxProbeSize / 8L);
        if (maxCapacity < 0x1000000) {
            maxCapacity = 0x1000000;
        }
        if (maxCapacity < initialCapacity || initialCapacity <= 0) {
            initialCapacity = Long.bitCount(maxCapacity) == 1 ? maxCapacity : BytesBytesMultiHashMap.nextLowestPowerOfTwo(maxCapacity);
        }
        BytesBytesMultiHashMap.validateCapacity(initialCapacity);
        this.startingHashBitCount = 63 - Long.numberOfLeadingZeros(initialCapacity);
        this.loadFactor = loadFactor;
        this.refs = new long[initialCapacity];
        this.writeBuffers = new WriteBuffers(wbSize, 0x4000000000L);
        this.resizeThreshold = (int)((float)initialCapacity * this.loadFactor);
    }

    @VisibleForTesting
    BytesBytesMultiHashMap(int initialCapacity, float loadFactor, int wbSize) {
        this(initialCapacity, loadFactor, wbSize, -1L);
    }

    public void put(KvSource kv, int keyHashCode) throws SerDeException {
        if (this.resizeThreshold <= this.keysAssigned) {
            this.expandAndRehash();
        }
        this.writeBuffers.write(FOUR_ZEROES);
        long keyOffset = this.writeBuffers.getWritePoint();
        kv.writeKey(this.writeBuffers);
        int keyLength = (int)(this.writeBuffers.getWritePoint() - keyOffset);
        int hashCode = keyHashCode == -1 ? this.writeBuffers.unsafeHashCode(keyOffset, keyLength) : keyHashCode;
        int slot = this.findKeySlotToWrite(keyOffset, keyLength, hashCode);
        long ref = this.refs[slot];
        if (ref == 0L) {
            long tailOffset = this.writeFirstValueRecord(kv, keyOffset, keyLength, hashCode);
            byte stateByte = kv.updateStateByte(null);
            this.refs[slot] = Ref.makeFirstRef(tailOffset, stateByte, hashCode, this.startingHashBitCount);
            ++this.keysAssigned;
        } else {
            this.writeBuffers.setWritePoint(keyOffset - 4L);
            long lrPtrOffset = this.createOrGetListRecord(ref);
            long tailOffset = this.writeValueAndLength(kv);
            this.addRecordToList(lrPtrOffset, tailOffset);
            byte oldStateByte = Ref.getStateByte(ref);
            byte stateByte = kv.updateStateByte(oldStateByte);
            if (oldStateByte != stateByte) {
                ref = Ref.setStateByte(ref, stateByte);
            }
            this.refs[slot] = Ref.setListFlag(ref);
        }
        ++this.numValues;
    }

    public byte getValueResult(byte[] key, int offset, int length, Result hashMapResult) {
        hashMapResult.forget();
        WriteBuffers.Position readPos = hashMapResult.getReadPos();
        long ref = this.findKeyRefToRead(key, offset, length, readPos);
        if (ref == 0L) {
            return 0;
        }
        boolean hasList = Ref.hasList(ref);
        long offsetAfterListRecordKeyLen = hasList ? this.writeBuffers.getReadPoint(readPos) : 0L;
        hashMapResult.set(this, Ref.getOffset(ref), hasList, offsetAfterListRecordKeyLen);
        return Ref.getStateByte(ref);
    }

    public void populateValue(WriteBuffers.ByteSegmentRef valueRef) {
        this.writeBuffers.populateValue(valueRef);
    }

    public int size() {
        return this.keysAssigned;
    }

    public int getNumValues() {
        return this.numValues;
    }

    public long memorySize() {
        return this.getEstimatedMemorySize();
    }

    @Override
    public long getEstimatedMemorySize() {
        JavaDataModel jdm = JavaDataModel.get();
        long size = 0L;
        size += this.writeBuffers.getEstimatedMemorySize();
        size += jdm.lengthForLongArrayOfSize(this.refs.length);
        return size += JavaDataModel.alignUp(15 * jdm.primitive1(), jdm.memoryAlign());
    }

    public void seal() {
        this.writeBuffers.seal();
    }

    public void clear() {
        this.writeBuffers.clear();
        this.refs = new long[1];
        this.keysAssigned = 0;
        this.numValues = 0;
    }

    public void expandAndRehashToTarget(int estimateNewRowCount) {
        int oldRefsCount = this.refs.length;
        int newRefsCount = oldRefsCount + estimateNewRowCount;
        if (this.resizeThreshold <= newRefsCount) {
            newRefsCount = Long.bitCount(newRefsCount) == 1 ? estimateNewRowCount : BytesBytesMultiHashMap.nextHighestPowerOfTwo(newRefsCount);
            this.expandAndRehashImpl(newRefsCount);
            LOG.info("Expand and rehash to " + newRefsCount + " from " + oldRefsCount);
        }
    }

    private static void validateCapacity(long capacity) {
        if (Long.bitCount(capacity) != 1) {
            throw new AssertionError((Object)"Capacity must be a power of two");
        }
        if (capacity <= 0L) {
            throw new AssertionError((Object)("Invalid capacity " + capacity));
        }
        if (capacity > Integer.MAX_VALUE) {
            throw new RuntimeException("Attempting to expand the hash table to " + capacity + " that overflows maximum array size. For this query, you may want to disable " + HiveConf.ConfVars.HIVEDYNAMICPARTITIONHASHJOIN.varname + " or reduce " + HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD.varname);
        }
    }

    private int findKeySlotToWrite(long keyOffset, int keyLength, int hashCode) {
        long ref;
        int bucketMask = this.refs.length - 1;
        int slot = hashCode & bucketMask;
        long probeSlot = slot;
        int i = 0;
        while ((ref = this.refs[slot]) != 0L && !this.isSameKey(keyOffset, keyLength, ref, hashCode)) {
            ++this.metricPutConflict;
            slot = (int)((probeSlot += (long)(++i)) & (long)bucketMask);
        }
        if (this.largestNumberOfSteps < i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probed " + i + " slots (the longest so far) to find space");
            }
            this.largestNumberOfSteps = i;
        }
        return slot;
    }

    private long findKeyRefToRead(byte[] key, int offset, int length, WriteBuffers.Position readPos) {
        int bucketMask = this.refs.length - 1;
        int hashCode = this.writeBuffers.hashCode(key, offset, length);
        int slot = hashCode & bucketMask;
        long probeSlot = slot;
        int i = 0;
        long ref;
        while ((ref = this.refs[slot]) != 0L) {
            if (this.isSameKey(key, offset, length, ref, hashCode, readPos)) {
                return ref;
            }
            ++this.metricGetConflict;
            probeSlot += (long)(++i);
            if (i > this.largestNumberOfSteps) {
                return 0L;
            }
            slot = (int)(probeSlot & (long)bucketMask);
        }
        return 0L;
    }

    private int relocateKeyRef(long[] newRefs, long newRef, int hashCode) {
        int bucketMask = newRefs.length - 1;
        int newSlot = hashCode & bucketMask;
        long probeSlot = newSlot;
        int i = 0;
        while (true) {
            long current;
            if ((current = newRefs[newSlot]) == 0L) break;
            newSlot = (int)((probeSlot += (long)(++i)) & (long)bucketMask);
        }
        newRefs[newSlot] = newRef;
        return i;
    }

    private boolean isSameKey(long cmpOffset, int cmpLength, long ref, int hashCode) {
        if (!this.compareHashBits(ref, hashCode)) {
            return false;
        }
        this.writeBuffers.setUnsafeReadPoint(this.getFirstRecordLengthsOffset(ref, null));
        int valueLength = (int)this.writeBuffers.unsafeReadVLong();
        int keyLength = (int)this.writeBuffers.unsafeReadVLong();
        if (keyLength != cmpLength) {
            return false;
        }
        long keyOffset = Ref.getOffset(ref) - (long)(valueLength + keyLength);
        return this.writeBuffers.isEqual(cmpOffset, cmpLength, keyOffset, keyLength);
    }

    private boolean isSameKey(byte[] key, int offset, int length, long ref, int hashCode, WriteBuffers.Position readPos) {
        if (!this.compareHashBits(ref, hashCode)) {
            return false;
        }
        this.writeBuffers.setReadPoint(this.getFirstRecordLengthsOffset(ref, readPos), readPos);
        int valueLength = (int)this.writeBuffers.readVLong(readPos);
        int keyLength = (int)this.writeBuffers.readVLong(readPos);
        long keyOffset = Ref.getOffset(ref) - (long)(valueLength + keyLength);
        if (offset == 0) {
            return this.writeBuffers.isEqual(key, length, keyOffset, keyLength);
        }
        return this.writeBuffers.isEqual(key, offset, length, keyOffset, keyLength);
    }

    private boolean compareHashBits(long ref, int hashCode) {
        long fakeRef = Ref.makeFirstRef(0L, (byte)0, hashCode, this.startingHashBitCount);
        return Ref.getHashBits(fakeRef) == Ref.getHashBits(ref);
    }

    private long getFirstRecordLengthsOffset(long ref, WriteBuffers.Position readPos) {
        long tailOffset = Ref.getOffset(ref);
        if (Ref.hasList(ref)) {
            long relativeOffset = readPos == null ? this.writeBuffers.unsafeReadNByteLong(tailOffset, 5) : this.writeBuffers.readNByteLong(tailOffset, 5, readPos);
            tailOffset += relativeOffset;
        }
        return tailOffset;
    }

    private void expandAndRehash() {
        this.expandAndRehashImpl((long)this.refs.length << 1);
    }

    private void expandAndRehashImpl(long capacity) {
        long expandTime = System.currentTimeMillis();
        long[] oldRefs = this.refs;
        BytesBytesMultiHashMap.validateCapacity(capacity);
        long[] newRefs = new long[(int)capacity];
        int newHashBitCount = this.hashBitCount + 1;
        int maxSteps = 0;
        for (int oldSlot = 0; oldSlot < oldRefs.length; ++oldSlot) {
            long oldRef = oldRefs[oldSlot];
            if (oldRef == 0L) continue;
            this.writeBuffers.setUnsafeReadPoint(this.getFirstRecordLengthsOffset(oldRef, null));
            int hashCode = (int)this.writeBuffers.unsafeReadNByteLong(Ref.getOffset(oldRef) - this.writeBuffers.unsafeReadVLong() - this.writeBuffers.unsafeReadVLong() - 4L, 4);
            int probeSteps = this.relocateKeyRef(newRefs, oldRef, hashCode);
            maxSteps = Math.max(probeSteps, maxSteps);
        }
        this.refs = newRefs;
        this.largestNumberOfSteps = maxSteps;
        this.hashBitCount = newHashBitCount;
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
        this.metricExpandsMs = (int)((long)this.metricExpandsMs + (System.currentTimeMillis() - expandTime));
        ++this.metricExpands;
    }

    private long createOrGetListRecord(long ref) {
        if (Ref.hasList(ref)) {
            return this.writeBuffers.getUnsafeReadPoint();
        }
        long firstTailOffset = Ref.getOffset(ref);
        this.writeBuffers.setUnsafeReadPoint(firstTailOffset);
        this.writeBuffers.unsafeSkipVLong();
        this.writeBuffers.unsafeSkipVLong();
        int lengthsLength = (int)(this.writeBuffers.getUnsafeReadPoint() - firstTailOffset);
        this.writeBuffers.writeBytes(firstTailOffset, lengthsLength);
        long lrPtrOffset = this.writeBuffers.getWritePoint();
        this.writeBuffers.write(FIVE_ZEROES);
        this.writeBuffers.writeFiveByteULong(firstTailOffset, lrPtrOffset - (long)lengthsLength - firstTailOffset);
        return lrPtrOffset;
    }

    private void addRecordToList(long lrPtrOffset, long tailOffset) {
        long prevHeadOffset = this.writeBuffers.unsafeReadNByteLong(lrPtrOffset, 5);
        assert (prevHeadOffset < tailOffset);
        this.writeBuffers.writeFiveByteULong(lrPtrOffset, tailOffset);
        this.writeBuffers.writeVLong(prevHeadOffset == 0L ? 0L : tailOffset - prevHeadOffset);
    }

    private long writeFirstValueRecord(KvSource kv, long keyOffset, int keyLength, int hashCode) throws SerDeException {
        long valueOffset = this.writeBuffers.getWritePoint();
        kv.writeValue(this.writeBuffers);
        long tailOffset = this.writeBuffers.getWritePoint();
        int valueLength = (int)(tailOffset - valueOffset);
        if (tailOffset == 0L) {
            this.writeBuffers.reserve(1);
            ++tailOffset;
        }
        this.writeBuffers.writeVLong(valueLength);
        this.writeBuffers.writeVLong(keyLength);
        long lengthsLength = this.writeBuffers.getWritePoint() - tailOffset;
        if (lengthsLength < 5L) {
            this.writeBuffers.reserve(5 - (int)lengthsLength);
        }
        this.writeBuffers.writeInt(keyOffset - 4L, hashCode);
        return tailOffset;
    }

    private long writeValueAndLength(KvSource kv) throws SerDeException {
        long valueOffset = this.writeBuffers.getWritePoint();
        kv.writeValue(this.writeBuffers);
        long tailOffset = this.writeBuffers.getWritePoint();
        this.writeBuffers.writeVLong(tailOffset - valueOffset);
        return tailOffset;
    }

    public void debugDumpTable() {
        StringBuilder dump = new StringBuilder(this.keysAssigned + " keys\n");
        TreeMap<Long, Integer> byteIntervals = new TreeMap<Long, Integer>();
        int examined = 0;
        for (int slot = 0; slot < this.refs.length; ++slot) {
            long ref = this.refs[slot];
            if (ref == 0L) continue;
            ++examined;
            long recOffset = this.getFirstRecordLengthsOffset(ref, null);
            long tailOffset = Ref.getOffset(ref);
            this.writeBuffers.setUnsafeReadPoint(recOffset);
            int valueLength = (int)this.writeBuffers.unsafeReadVLong();
            int keyLength = (int)this.writeBuffers.unsafeReadVLong();
            long ptrOffset = this.writeBuffers.getUnsafeReadPoint();
            if (Ref.hasList(ref)) {
                byteIntervals.put(recOffset, (int)(ptrOffset + 5L - recOffset));
            }
            long keyOffset = tailOffset - (long)valueLength - (long)keyLength;
            byte[] key = new byte[keyLength];
            WriteBuffers.ByteSegmentRef fakeRef = new WriteBuffers.ByteSegmentRef(keyOffset, keyLength);
            byteIntervals.put(keyOffset - 4L, keyLength + 4);
            this.writeBuffers.populateValue(fakeRef);
            System.arraycopy(fakeRef.getBytes(), (int)fakeRef.getOffset(), key, 0, keyLength);
            dump.append(Utils.toStringBinary(key, 0, key.length)).append(" ref [").append(BytesBytesMultiHashMap.dumpRef(ref)).append("]: ");
            Result hashMapResult = new Result();
            this.getValueResult(key, 0, key.length, hashMapResult);
            ArrayList<WriteBuffers.ByteSegmentRef> results = new ArrayList<WriteBuffers.ByteSegmentRef>();
            WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
            while (byteSegmentRef != null) {
                results.add(hashMapResult.byteSegmentRef);
                byteSegmentRef = hashMapResult.next();
            }
            dump.append(results.size()).append(" rows\n");
            for (int i = 0; i < results.size(); ++i) {
                WriteBuffers.ByteSegmentRef segment = (WriteBuffers.ByteSegmentRef)results.get(i);
                byteIntervals.put(segment.getOffset(), segment.getLength() + (i == 0 ? 1 : 0));
            }
        }
        if (examined != this.keysAssigned) {
            dump.append("Found " + examined + " keys!\n");
        }
        long currentOffset = 0L;
        for (Map.Entry e : byteIntervals.entrySet()) {
            long start = (Long)e.getKey();
            long len = ((Integer)e.getValue()).intValue();
            if (start - currentOffset > 4L) {
                dump.append("Gap! [" + currentOffset + ", " + start + ")\n");
            }
            currentOffset = start + len;
        }
        LOG.info("Hashtable dump:\n " + dump.toString());
    }

    private static int nextHighestPowerOfTwo(int v) {
        return Integer.highestOneBit(v) << 1;
    }

    private static int nextLowestPowerOfTwo(int v) {
        return Integer.highestOneBit(v);
    }

    @VisibleForTesting
    int getCapacity() {
        return this.refs.length;
    }

    private static String dumpRef(long ref) {
        return StringUtils.leftPad(Long.toBinaryString(ref), 64, "0") + " o=" + Ref.getOffset(ref) + " s=" + Ref.getStateByte(ref) + " l=" + Ref.hasList(ref) + " h=" + Long.toBinaryString(Ref.getHashBits(ref));
    }

    public void debugDumpMetrics() {
        LOG.info("Map metrics: keys allocated " + this.refs.length + ", keys assigned " + this.keysAssigned + ", write conflict " + this.metricPutConflict + ", write max dist " + this.largestNumberOfSteps + ", read conflict " + this.metricGetConflict + ", expanded " + this.metricExpands + " times in " + this.metricExpandsMs + "ms");
    }

    private void debugDumpKeyProbe(long keyOffset, int keyLength, int hashCode, int finalSlot) {
        int bucketMask = this.refs.length - 1;
        WriteBuffers.ByteSegmentRef fakeRef = new WriteBuffers.ByteSegmentRef(keyOffset, keyLength);
        this.writeBuffers.populateValue(fakeRef);
        int slot = hashCode & bucketMask;
        long probeSlot = slot;
        StringBuilder sb = new StringBuilder("Probe path debug for [");
        sb.append(Utils.toStringBinary(fakeRef.getBytes(), (int)fakeRef.getOffset(), fakeRef.getLength()));
        sb.append("] hashCode ").append(Integer.toBinaryString(hashCode)).append(" is: ");
        int i = 0;
        while (slot != finalSlot) {
            slot = (int)((probeSlot += (long)(++i)) & (long)bucketMask);
            sb.append(slot).append(" - ").append(probeSlot).append(" - ").append(Long.toBinaryString(this.refs[slot])).append("\n");
        }
        LOG.info(sb.toString());
    }

    private static final class Ref {
        private static final int OFFSET_SHIFT = 24;
        private static final int STATE_BYTE_SHIFT = 16;
        private static final long STATE_BYTE_MASK = 255L;
        public static final long HASH_BITS_COUNT = 15L;
        private static final long HAS_LIST_MASK = 32768L;
        private static final long HASH_BITS_MASK = 32767L;
        private static final long REMOVE_STATE_BYTE = -16711681L;

        private Ref() {
        }

        public static long getOffset(long ref) {
            return ref >>> 24;
        }

        public static byte getStateByte(long ref) {
            return (byte)(ref >>> 16 & 0xFFL);
        }

        public static boolean hasList(long ref) {
            return (ref & 0x8000L) == 32768L;
        }

        public static long getHashBits(long ref) {
            return ref & 0x7FFFL;
        }

        public static long makeFirstRef(long offset, byte stateByte, int hashCode, int skipHashBits) {
            long hashPart = (long)(hashCode >>> skipHashBits) & 0x7FFFL;
            return offset << 24 | hashPart | ((long)stateByte & 0xFFL) << 16;
        }

        public static int getNthHashBit(long ref, int skippedBits, int position) {
            long hashPart = Ref.getHashBits(ref) << skippedBits;
            return (int)(hashPart & (long)(1 << position - 1));
        }

        public static long setStateByte(long ref, byte stateByte) {
            return ref & 0xFFFFFFFFFF00FFFFL | ((long)stateByte & 0xFFL) << 16;
        }

        public static long setListFlag(long ref) {
            return ref | 0x8000L;
        }
    }

    public static interface KvSource {
        public void writeKey(ByteStream.RandomAccessOutput var1) throws SerDeException;

        public void writeValue(ByteStream.RandomAccessOutput var1) throws SerDeException;

        public byte updateStateByte(Byte var1);
    }

    public static class Result {
        private boolean hasRows = false;
        private BytesBytesMultiHashMap hashMap;
        private WriteBuffers.Position readPos;
        private long firstOffset;
        private boolean hasList;
        private long offsetAfterListRecordKeyLen;
        private long nextTailOffset;
        private long readIndex;
        private WriteBuffers.ByteSegmentRef byteSegmentRef = new WriteBuffers.ByteSegmentRef();

        public Result() {
            this.readPos = new WriteBuffers.Position();
        }

        public WriteBuffers.Position getReadPos() {
            return this.readPos;
        }

        public boolean hasRows() {
            return this.hasRows;
        }

        public boolean isSingleRow() {
            return !this.hasList;
        }

        public void set(BytesBytesMultiHashMap hashMap, long firstOffset, boolean hasList, long offsetAfterListRecordKeyLen) {
            this.hashMap = hashMap;
            this.firstOffset = firstOffset;
            this.hasList = hasList;
            this.offsetAfterListRecordKeyLen = offsetAfterListRecordKeyLen;
            this.readIndex = 0L;
            this.nextTailOffset = -1L;
            this.hasRows = true;
        }

        public WriteBuffers.ByteSegmentRef first() {
            if (!this.hasRows) {
                return null;
            }
            this.readIndex = 0L;
            this.nextTailOffset = -1L;
            return this.internalRead();
        }

        public WriteBuffers.ByteSegmentRef next() {
            if (!this.hasRows) {
                return null;
            }
            return this.internalRead();
        }

        private WriteBuffers.ByteSegmentRef internalRead() {
            if (!this.hasList) {
                if (this.readIndex > 0L) {
                    return null;
                }
                this.hashMap.writeBuffers.setReadPoint(this.firstOffset, this.readPos);
                int valueLength = (int)this.hashMap.writeBuffers.readVLong(this.readPos);
                this.byteSegmentRef.reset(this.firstOffset - (long)valueLength, valueLength);
                this.hashMap.writeBuffers.populateValue(this.byteSegmentRef);
                ++this.readIndex;
                return this.byteSegmentRef;
            }
            if (this.readIndex == 0L) {
                long relativeOffset = this.hashMap.writeBuffers.readNByteLong(this.firstOffset, 5, this.readPos);
                this.hashMap.writeBuffers.setReadPoint(this.firstOffset + relativeOffset, this.readPos);
                int valueLength = (int)this.hashMap.writeBuffers.readVLong(this.readPos);
                this.byteSegmentRef.reset(this.firstOffset - (long)valueLength, valueLength);
                this.hashMap.writeBuffers.populateValue(this.byteSegmentRef);
                ++this.readIndex;
                return this.byteSegmentRef;
            }
            if (this.readIndex == 1L) {
                this.nextTailOffset = this.hashMap.writeBuffers.readNByteLong(this.offsetAfterListRecordKeyLen, 5, this.readPos);
                if (this.nextTailOffset <= 0L) {
                    throw new Error("Expecting a second value");
                }
            } else if (this.nextTailOffset <= 0L) {
                return null;
            }
            this.hashMap.writeBuffers.setReadPoint(this.nextTailOffset, this.readPos);
            int valueLength = (int)this.hashMap.writeBuffers.readVLong(this.readPos);
            long delta = this.hashMap.writeBuffers.readVLong(this.readPos);
            long newTailOffset = delta == 0L ? 0L : this.nextTailOffset - delta;
            this.byteSegmentRef.reset(this.nextTailOffset - (long)valueLength, valueLength);
            this.hashMap.writeBuffers.populateValue(this.byteSegmentRef);
            this.nextTailOffset = newTailOffset;
            ++this.readIndex;
            return this.byteSegmentRef;
        }

        public void forget() {
            this.hashMap = null;
            this.byteSegmentRef.reset(0L, 0);
            this.hasRows = false;
            this.readIndex = 0L;
            this.nextTailOffset = -1L;
        }
    }
}

