/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;

public class TaskTracker {
    private static Logger LOG = LoggerFactory.getLogger(TaskTracker.class);
    private final List<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
    private ReplicationState replicationState = null;
    private int numberOfTasks = 0;
    private final int maxTasksAllowed;

    public TaskTracker(int defaultMaxTasks) {
        this.maxTasksAllowed = defaultMaxTasks;
    }

    public TaskTracker(TaskTracker existing) {
        this.maxTasksAllowed = existing.maxTasksAllowed - existing.numberOfTasks;
    }

    public void addTask(Task<? extends Serializable> task) {
        this.tasks.add(task);
        ArrayList<Task<? extends Serializable>> visited = new ArrayList<Task<? extends Serializable>>();
        this.updateTaskCount(task, visited);
    }

    public void updateTaskCount(Task<? extends Serializable> task, List<Task<? extends Serializable>> visited) {
        ++this.numberOfTasks;
        visited.add(task);
        if (task.getChildTasks() != null) {
            for (Task<Serializable> childTask : task.getChildTasks()) {
                if (visited.contains(childTask)) continue;
                this.updateTaskCount(childTask, visited);
            }
        }
    }

    public boolean canAddMoreTasks() {
        return this.numberOfTasks < this.maxTasksAllowed;
    }

    public boolean hasTasks() {
        return this.numberOfTasks != 0;
    }

    public void update(TaskTracker withAnother) {
        this.numberOfTasks += withAnother.numberOfTasks;
        if (withAnother.hasReplicationState()) {
            this.replicationState = withAnother.replicationState;
        }
    }

    public void setReplicationState(ReplicationState state) {
        this.replicationState = state;
    }

    public boolean hasReplicationState() {
        return this.replicationState != null;
    }

    public ReplicationState replicationState() {
        return this.replicationState;
    }

    public List<Task<? extends Serializable>> tasks() {
        return this.tasks;
    }

    public void debugLog(String forEventType) {
        LOG.debug("{} event with total / root number of tasks:{}/{}", forEventType, this.numberOfTasks, this.tasks.size());
    }

    public int numberOfTasks() {
        return this.numberOfTasks;
    }
}

