/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.facebook.presto.hive.$internal.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MemoryMonitorInfo;
import org.apache.hadoop.hive.ql.exec.MuxOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.TezDummyStoreOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.BigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.TezBucketJoinProcCtx;
import org.apache.hadoop.hive.ql.optimizer.physical.LlapClusterStateForCompile;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.CommonMergeJoinDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class ConvertJoinMapJoin
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertJoinMapJoin.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        OptimizeTezProcContext context = (OptimizeTezProcContext)procCtx;
        JoinOperator joinOp = (JoinOperator)nd;
        long maxSize = context.conf.getLongVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        LlapClusterStateForCompile llapInfo = null;
        if ("llap".equalsIgnoreCase(context.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_MODE))) {
            llapInfo = LlapClusterStateForCompile.getClusterInfo(context.conf);
            llapInfo.initClusterInfo();
        }
        MemoryMonitorInfo memoryMonitorInfo = this.getMemoryMonitorInfo(maxSize, context.conf, llapInfo);
        ((JoinDesc)joinOp.getConf()).setMemoryMonitorInfo(memoryMonitorInfo);
        boolean cartesianProductEdgeEnabled = HiveConf.getBoolVar(context.conf, HiveConf.ConfVars.TEZ_CARTESIAN_PRODUCT_EDGE_ENABLED);
        if (cartesianProductEdgeEnabled && !this.hasOuterJoin(joinOp) && this.isCrossProduct(joinOp)) {
            this.fallbackToMergeJoin(joinOp, context);
            return null;
        }
        TezBucketJoinProcCtx tezBucketJoinProcCtx = new TezBucketJoinProcCtx(context.conf);
        boolean hiveConvertJoin = context.conf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN) & !context.parseContext.getDisableMapJoin();
        if (!hiveConvertJoin) {
            Object retval = this.checkAndConvertSMBJoin(context, joinOp, tezBucketJoinProcCtx, maxSize);
            if (retval == null) {
                return retval;
            }
            this.fallbackToReduceSideJoin(joinOp, context, maxSize);
            return null;
        }
        int numBuckets = -1;
        numBuckets = context.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ) ? ConvertJoinMapJoin.estimateNumBuckets(joinOp, true) : 1;
        LOG.info("Estimated number of buckets " + numBuckets);
        int mapJoinConversionPos = this.getMapJoinConversionPos(joinOp, context, numBuckets, false, maxSize, true);
        if (mapJoinConversionPos < 0) {
            Object retval = this.checkAndConvertSMBJoin(context, joinOp, tezBucketJoinProcCtx, maxSize);
            if (retval == null) {
                return retval;
            }
            this.fallbackToReduceSideJoin(joinOp, context, maxSize);
            return null;
        }
        if (numBuckets > 1 && context.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ) && (llapInfo != null ? this.selectJoinForLlap(context, joinOp, tezBucketJoinProcCtx, llapInfo, mapJoinConversionPos, numBuckets) : this.convertJoinBucketMapJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx))) {
            return null;
        }
        LOG.info("Convert to non-bucketed map join");
        if (numBuckets != 1) {
            mapJoinConversionPos = this.getMapJoinConversionPos(joinOp, context, 1, false, maxSize, true);
        }
        if (mapJoinConversionPos < 0) {
            this.fallbackToReduceSideJoin(joinOp, context, maxSize);
            return null;
        }
        MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, mapJoinConversionPos, true);
        mapJoinOp.setOpTraits(new OpTraits(null, -1, null, joinOp.getOpTraits().getNumReduceSinks(), joinOp.getOpTraits().getBucketingVersion()));
        this.preserveOperatorInfos(mapJoinOp, joinOp, context);
        for (Operator<OperatorDesc> childOp : mapJoinOp.getChildOperators()) {
            this.setAllChildrenTraits(childOp, mapJoinOp.getOpTraits());
        }
        return null;
    }

    private boolean selectJoinForLlap(OptimizeTezProcContext context, JoinOperator joinOp, TezBucketJoinProcCtx tezBucketJoinProcCtx, LlapClusterStateForCompile llapInfo, int mapJoinConversionPos, int numBuckets) throws SemanticException {
        if (!context.conf.getBoolVar(HiveConf.ConfVars.HIVEDYNAMICPARTITIONHASHJOIN) && numBuckets > 1) {
            return this.convertJoinBucketMapJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx);
        }
        int numExecutorsPerNode = -1;
        if (llapInfo.hasClusterInfo()) {
            numExecutorsPerNode = llapInfo.getNumExecutorsPerNode();
        }
        if (numExecutorsPerNode == -1) {
            numExecutorsPerNode = context.conf.getIntVar(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
        }
        int numNodes = llapInfo.getKnownExecutorCount() / numExecutorsPerNode;
        LOG.debug("Number of nodes = " + numNodes + ". Number of Executors per node = " + numExecutorsPerNode);
        long totalSize = 0L;
        for (int pos = 0; pos < joinOp.getParentOperators().size(); ++pos) {
            if (pos == mapJoinConversionPos) continue;
            Operator<OperatorDesc> parentOp = joinOp.getParentOperators().get(pos);
            totalSize += parentOp.getStatistics().getDataSize();
        }
        long bigTableSize = joinOp.getParentOperators().get(mapJoinConversionPos).getStatistics().getDataSize();
        long networkCostDPHJ = totalSize + bigTableSize;
        LOG.info("Cost of dynamically partitioned hash join : total small table size = " + totalSize + " bigTableSize = " + bigTableSize + "networkCostDPHJ = " + networkCostDPHJ);
        long networkCostMJ = (long)numNodes * totalSize;
        LOG.info("Cost of Bucket Map Join : numNodes = " + numNodes + " total small table size = " + totalSize + " networkCostMJ = " + networkCostMJ);
        if (networkCostDPHJ < networkCostMJ) {
            LOG.info("Dynamically partitioned Hash Join chosen");
            long maxSize = context.conf.getLongVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
            return this.convertJoinDynamicPartitionedHashJoin(joinOp, context, maxSize);
        }
        if (numBuckets > 1) {
            LOG.info("Bucket Map Join chosen");
            return this.convertJoinBucketMapJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx);
        }
        LOG.info("Falling back to mapjoin no bucket scaling");
        return false;
    }

    @VisibleForTesting
    public MemoryMonitorInfo getMemoryMonitorInfo(long maxSize, HiveConf conf, LlapClusterStateForCompile llapInfo) {
        MemoryMonitorInfo memoryMonitorInfo;
        double overSubscriptionFactor = conf.getFloatVar(HiveConf.ConfVars.LLAP_MAPJOIN_MEMORY_OVERSUBSCRIBE_FACTOR);
        int maxSlotsPerQuery = conf.getIntVar(HiveConf.ConfVars.LLAP_MEMORY_OVERSUBSCRIPTION_MAX_EXECUTORS_PER_QUERY);
        long memoryCheckInterval = conf.getLongVar(HiveConf.ConfVars.LLAP_MAPJOIN_MEMORY_MONITOR_CHECK_INTERVAL);
        float inflationFactor = conf.getFloatVar(HiveConf.ConfVars.HIVE_HASH_TABLE_INFLATION_FACTOR);
        if (llapInfo != null) {
            int executorsPerNode;
            if (!llapInfo.hasClusterInfo()) {
                LOG.warn("LLAP cluster information not available. Falling back to getting #executors from hiveconf..");
                executorsPerNode = conf.getIntVar(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
            } else {
                int numExecutorsPerNodeFromCluster = llapInfo.getNumExecutorsPerNode();
                if (numExecutorsPerNodeFromCluster == -1) {
                    LOG.warn("Cannot determine executor count from LLAP cluster information. Falling back to getting #executors from hiveconf..");
                    executorsPerNode = conf.getIntVar(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
                } else {
                    executorsPerNode = numExecutorsPerNodeFromCluster;
                }
            }
            int slotsPerQuery = Math.min(maxSlotsPerQuery, executorsPerNode);
            long llapMaxSize = (long)((double)maxSize + (double)maxSize * overSubscriptionFactor * (double)slotsPerQuery);
            long adjustedMaxSize = Math.max(maxSize, llapMaxSize);
            memoryMonitorInfo = new MemoryMonitorInfo(true, executorsPerNode, maxSlotsPerQuery, overSubscriptionFactor, maxSize, adjustedMaxSize, memoryCheckInterval, inflationFactor);
        } else {
            memoryMonitorInfo = new MemoryMonitorInfo(false, 1, maxSlotsPerQuery, overSubscriptionFactor, maxSize, maxSize, memoryCheckInterval, inflationFactor);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Memory monitor info set to : {}", (Object)memoryMonitorInfo);
        }
        return memoryMonitorInfo;
    }

    private Object checkAndConvertSMBJoin(OptimizeTezProcContext context, JoinOperator joinOp, TezBucketJoinProcCtx tezBucketJoinProcCtx, long maxSize) throws SemanticException {
        if (!HiveConf.getBoolVar(context.conf, HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN) || !HiveConf.getBoolVar(context.conf, HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN_REDUCE) && joinOp.getOpTraits().getNumReduceSinks() >= 2) {
            this.fallbackToReduceSideJoin(joinOp, context, maxSize);
            return null;
        }
        Class bigTableMatcherClass = null;
        try {
            String selector = HiveConf.getVar(context.parseContext.getConf(), HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN_BIGTABLE_SELECTOR);
            bigTableMatcherClass = JavaUtils.loadClass(selector);
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e.getMessage());
        }
        BigTableSelectorForAutoSMJ bigTableMatcher = (BigTableSelectorForAutoSMJ)ReflectionUtils.newInstance((Class)bigTableMatcherClass, null);
        JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
        JoinCondDesc[] joinCondns = joinDesc.getConds();
        Set<Integer> joinCandidates = MapJoinProcessor.getBigTableCandidates(joinCondns);
        if (joinCandidates.isEmpty()) {
            return false;
        }
        int mapJoinConversionPos = bigTableMatcher.getBigTablePosition(context.parseContext, joinOp, joinCandidates);
        if (mapJoinConversionPos < 0) {
            this.fallbackToReduceSideJoin(joinOp, context, maxSize);
            return null;
        }
        if (this.checkConvertJoinSMBJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx)) {
            this.convertJoinSMBJoin(joinOp, context, mapJoinConversionPos, tezBucketJoinProcCtx.getNumBuckets(), true);
        } else {
            this.fallbackToReduceSideJoin(joinOp, context, maxSize);
        }
        return null;
    }

    private void convertJoinSMBJoin(JoinOperator joinOp, OptimizeTezProcContext context, int mapJoinConversionPos, int numBuckets, boolean adjustParentsChildren) throws SemanticException {
        int pos;
        MapJoinDesc mapJoinDesc = null;
        if (adjustParentsChildren) {
            mapJoinDesc = MapJoinProcessor.getMapJoinDesc(context.conf, joinOp, ((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), ((JoinDesc)joinOp.getConf()).getMapAliases(), mapJoinConversionPos, true);
        } else {
            JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
            mapJoinDesc = new MapJoinDesc(MapJoinProcessor.getKeys(((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), joinOp).getSecond(), null, joinDesc.getExprs(), null, null, joinDesc.getOutputColumnNames(), mapJoinConversionPos, joinDesc.getConds(), joinDesc.getFilters(), joinDesc.getNoOuterJoin(), null, joinDesc.getMemoryMonitorInfo(), joinDesc.getInMemoryDataSize());
            mapJoinDesc.setNullSafes(joinDesc.getNullSafes());
            mapJoinDesc.setFilterMap(joinDesc.getFilterMap());
            mapJoinDesc.setResidualFilterExprs(joinDesc.getResidualFilterExprs());
            mapJoinDesc.setColumnExprMap(joinDesc.getColumnExprMap());
            mapJoinDesc.setReversedExprs(joinDesc.getReversedExprs());
            mapJoinDesc.resetOrder();
        }
        CommonMergeJoinOperator mergeJoinOp = (CommonMergeJoinOperator)OperatorFactory.get(joinOp.getCompilationOpContext(), new CommonMergeJoinDesc(numBuckets, mapJoinConversionPos, mapJoinDesc), joinOp.getSchema());
        context.parseContext.getContext().getPlanMapper().link(joinOp, mergeJoinOp);
        int numReduceSinks = joinOp.getOpTraits().getNumReduceSinks();
        OpTraits opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), numBuckets, joinOp.getOpTraits().getSortCols(), numReduceSinks, joinOp.getOpTraits().getBucketingVersion());
        mergeJoinOp.setOpTraits(opTraits);
        this.preserveOperatorInfos(mergeJoinOp, joinOp, context);
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            pos = parentOp.getChildOperators().indexOf(joinOp);
            parentOp.getChildOperators().remove(pos);
            parentOp.getChildOperators().add(pos, mergeJoinOp);
        }
        for (Operator<OperatorDesc> childOp : joinOp.getChildOperators()) {
            pos = childOp.getParentOperators().indexOf(joinOp);
            childOp.getParentOperators().remove(pos);
            childOp.getParentOperators().add(pos, mergeJoinOp);
        }
        List<Operator<OperatorDesc>> childOperators = mergeJoinOp.getChildOperators();
        List<Operator<OperatorDesc>> parentOperators = mergeJoinOp.getParentOperators();
        childOperators.clear();
        parentOperators.clear();
        childOperators.addAll(joinOp.getChildOperators());
        parentOperators.addAll(joinOp.getParentOperators());
        ((CommonMergeJoinDesc)mergeJoinOp.getConf()).setGenJoinKeys(false);
        if (adjustParentsChildren) {
            ((CommonMergeJoinDesc)mergeJoinOp.getConf()).setGenJoinKeys(true);
            ArrayList<Operator<OperatorDesc>> newParentOpList = new ArrayList<Operator<OperatorDesc>>();
            for (Operator<OperatorDesc> parentOp : mergeJoinOp.getParentOperators()) {
                for (Operator<OperatorDesc> grandParentOp : parentOp.getParentOperators()) {
                    grandParentOp.getChildOperators().remove(parentOp);
                    grandParentOp.getChildOperators().add(mergeJoinOp);
                    newParentOpList.add(grandParentOp);
                }
            }
            mergeJoinOp.getParentOperators().clear();
            mergeJoinOp.getParentOperators().addAll(newParentOpList);
            ArrayList<Operator<OperatorDesc>> parentOps = new ArrayList<Operator<OperatorDesc>>(mergeJoinOp.getParentOperators());
            for (Operator operator : parentOps) {
                int parentIndex = mergeJoinOp.getParentOperators().indexOf(operator);
                if (parentIndex == mapJoinConversionPos) continue;
                TezDummyStoreOperator dummyStoreOp = new TezDummyStoreOperator(mergeJoinOp.getCompilationOpContext());
                dummyStoreOp.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                dummyStoreOp.setChildOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                dummyStoreOp.getChildOperators().add(mergeJoinOp);
                int index = operator.getChildOperators().indexOf(mergeJoinOp);
                operator.getChildOperators().remove(index);
                operator.getChildOperators().add(index, dummyStoreOp);
                dummyStoreOp.getParentOperators().add(operator);
                mergeJoinOp.getParentOperators().remove(parentIndex);
                mergeJoinOp.getParentOperators().add(parentIndex, dummyStoreOp);
            }
        }
        mergeJoinOp.cloneOriginalParentsList(mergeJoinOp.getParentOperators());
    }

    private void setAllChildrenTraits(Operator<? extends OperatorDesc> currentOp, OpTraits opTraits) {
        if (currentOp instanceof ReduceSinkOperator) {
            return;
        }
        currentOp.setOpTraits(new OpTraits(opTraits.getBucketColNames(), opTraits.getNumBuckets(), opTraits.getSortCols(), opTraits.getNumReduceSinks(), opTraits.getBucketingVersion()));
        for (Operator<OperatorDesc> childOp : currentOp.getChildOperators()) {
            if (childOp instanceof ReduceSinkOperator || childOp instanceof GroupByOperator) break;
            this.setAllChildrenTraits(childOp, opTraits);
        }
    }

    private boolean convertJoinBucketMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        MemoryMonitorInfo memoryMonitorInfo;
        MapJoinOperator mapJoinOp;
        if (!this.checkConvertJoinBucketMapJoin(joinOp, bigTablePosition, tezBucketJoinProcCtx)) {
            LOG.info("Check conversion to bucket map join failed.");
            return false;
        }
        ReduceSinkOperator bigTableRS = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePosition);
        OpTraits opTraits = bigTableRS.getOpTraits();
        List<List<String>> listBucketCols = opTraits.getBucketColNames();
        ArrayList<ExprNodeDesc> bigTablePartitionCols = ((ReduceSinkDesc)bigTableRS.getConf()).getPartitionCols();
        boolean updatePartitionCols = false;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (listBucketCols.get(0).size() != bigTablePartitionCols.size()) {
            updatePartitionCols = true;
            int i = 0;
            Map<String, ExprNodeDesc> colExprMap = bigTableRS.getColumnExprMap();
            for (ExprNodeDesc exprNodeDesc : bigTablePartitionCols) {
                for (String colName : listBucketCols.get(0)) {
                    if (!colExprMap.get(colName).isSame(exprNodeDesc)) continue;
                    positions.add(i++);
                }
            }
        }
        if ((mapJoinOp = this.convertJoinMapJoin(joinOp, context, bigTablePosition, true)) == null) {
            LOG.debug("Conversion to bucket map join failed.");
            return false;
        }
        MapJoinDesc joinDesc = (MapJoinDesc)mapJoinOp.getConf();
        joinDesc.setBucketMapJoin(true);
        opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), tezBucketJoinProcCtx.getNumBuckets(), null, joinOp.getOpTraits().getNumReduceSinks(), joinOp.getOpTraits().getBucketingVersion());
        mapJoinOp.setOpTraits(opTraits);
        this.preserveOperatorInfos(mapJoinOp, joinOp, context);
        this.setNumberOfBucketsOnChildren(mapJoinOp);
        HashMap<String, Integer> bigTableBucketNumMapping = new HashMap<String, Integer>();
        bigTableBucketNumMapping.put(joinDesc.getBigTableAlias(), tezBucketJoinProcCtx.getNumBuckets());
        joinDesc.setBigTableBucketNumMapping(bigTableBucketNumMapping);
        if (updatePartitionCols) {
            for (Operator<OperatorDesc> operator : mapJoinOp.getParentOperators()) {
                if (!(operator instanceof ReduceSinkOperator)) continue;
                ReduceSinkOperator rsOp = (ReduceSinkOperator)operator;
                ArrayList<ExprNodeDesc> newPartitionCols = new ArrayList<ExprNodeDesc>();
                ArrayList<ExprNodeDesc> partitionCols = ((ReduceSinkDesc)rsOp.getConf()).getPartitionCols();
                for (Integer position : positions) {
                    newPartitionCols.add(partitionCols.get(position));
                }
                ((ReduceSinkDesc)rsOp.getConf()).setPartitionCols(newPartitionCols);
            }
        }
        if ((memoryMonitorInfo = joinDesc.getMemoryMonitorInfo()).isLlap()) {
            memoryMonitorInfo.setHashTableInflationFactor(1.0);
            memoryMonitorInfo.setMemoryOverSubscriptionFactor(0.0);
        }
        return true;
    }

    private void preserveOperatorInfos(Operator<?> newOp, Operator<?> oldOp, OptimizeTezProcContext context) {
        newOp.setStatistics(oldOp.getStatistics());
        context.parseContext.getContext().getPlanMapper().link(oldOp, newOp);
    }

    private boolean checkConvertJoinSMBJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        ReduceSinkOperator bigTableRS = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePosition);
        int numBuckets = bigTableRS.getParentOperators().get(0).getOpTraits().getNumBuckets();
        int size = -1;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            Set<ReduceSinkOperator> set = OperatorUtils.findOperatorsUpstream(parentOp.getParentOperators(), ReduceSinkOperator.class);
            if (size < 0) {
                size = set.size();
                continue;
            }
            if (size > 0 && set.size() > 0 || size == 0 && set.size() == 0) continue;
            return false;
        }
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (!(parentOp instanceof ReduceSinkOperator)) {
                LOG.info("Found correlation optimizer operators. Cannot convert to SMB at this time.");
                return false;
            }
            ReduceSinkOperator rsOp = (ReduceSinkOperator)parentOp;
            if (!this.checkColEquality(rsOp.getParentOperators().get(0).getOpTraits().getSortCols(), rsOp.getOpTraits().getSortCols(), rsOp.getColumnExprMap(), false)) {
                LOG.info("We cannot convert to SMB because the sort column names do not match.");
                return false;
            }
            if (this.checkColEquality(rsOp.getParentOperators().get(0).getOpTraits().getBucketColNames(), rsOp.getOpTraits().getBucketColNames(), rsOp.getColumnExprMap(), true)) continue;
            LOG.info("We cannot convert to SMB because bucket column names do not match.");
            return false;
        }
        if (numBuckets < 0) {
            numBuckets = ((ReduceSinkDesc)bigTableRS.getConf()).getNumReducers();
        }
        tezBucketJoinProcCtx.setNumBuckets(numBuckets);
        int bucketingVersion = -1;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            assert (parentOp.getParentOperators() != null && parentOp.getParentOperators().size() == 1);
            Operator<OperatorDesc> op = parentOp.getParentOperators().get(0);
            while (!(op == null || op instanceof TableScanOperator || op instanceof ReduceSinkOperator || op instanceof CommonJoinOperator)) {
                List<Operator<OperatorDesc>> parents = op.getParentOperators();
                Preconditions.checkState(parents.size() == 0 || parents.size() == 1);
                op = parents.size() == 1 ? parents.get(0) : null;
            }
            if (!(op instanceof TableScanOperator)) continue;
            int localVersion = ((TableScanDesc)((TableScanOperator)op).getConf()).getTableMetadata().getBucketingVersion();
            if (bucketingVersion == -1) {
                bucketingVersion = localVersion;
                continue;
            }
            if (bucketingVersion == localVersion) continue;
            LOG.debug("SMB Join can't be performed due to bucketing version mismatch");
            return false;
        }
        LOG.info("We can convert the join to an SMB join.");
        return true;
    }

    private void setNumberOfBucketsOnChildren(Operator<? extends OperatorDesc> currentOp) {
        int numBuckets = currentOp.getOpTraits().getNumBuckets();
        for (Operator<OperatorDesc> op : currentOp.getChildOperators()) {
            if (op instanceof ReduceSinkOperator || op instanceof GroupByOperator) continue;
            op.getOpTraits().setNumBuckets(numBuckets);
            this.setNumberOfBucketsOnChildren(op);
        }
    }

    private boolean checkConvertJoinBucketMapJoin(JoinOperator joinOp, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        if (!(joinOp.getParentOperators().get(0) instanceof ReduceSinkOperator)) {
            LOG.info("Operator is " + joinOp.getParentOperators().get(0).getName() + ". Cannot convert to bucket map join");
            return false;
        }
        ReduceSinkOperator rs = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePosition);
        List<List<String>> parentColNames = rs.getOpTraits().getBucketColNames();
        Operator<OperatorDesc> parentOfParent = rs.getParentOperators().get(0);
        List<List<String>> grandParentColNames = parentOfParent.getOpTraits().getBucketColNames();
        int numBuckets = parentOfParent.getOpTraits().getNumBuckets();
        if (!this.checkColEquality(grandParentColNames, parentColNames, rs.getColumnExprMap(), true)) {
            LOG.info("No info available to check for bucket map join. Cannot convert");
            return false;
        }
        if (numBuckets < 0) {
            numBuckets = ((ReduceSinkDesc)rs.getConf()).getNumReducers();
        }
        tezBucketJoinProcCtx.setNumBuckets(numBuckets);
        return true;
    }

    private boolean checkColEquality(List<List<String>> grandParentColNames, List<List<String>> parentColNames, Map<String, ExprNodeDesc> colExprMap, boolean strict) {
        if (grandParentColNames == null || parentColNames == null) {
            return false;
        }
        if (!parentColNames.isEmpty()) {
            block0: for (List<String> listBucketCols : grandParentColNames) {
                if (listBucketCols.isEmpty()) continue;
                int colCount = 0;
                for (String colName : parentColNames.get(0)) {
                    if (listBucketCols.size() <= colCount) {
                        return false;
                    }
                    ExprNodeDesc exprNodeDesc = colExprMap.get(colName);
                    if (exprNodeDesc instanceof ExprNodeColumnDesc) {
                        if (!((ExprNodeColumnDesc)exprNodeDesc).getColumn().equals(listBucketCols.get(colCount))) continue block0;
                        ++colCount;
                    }
                    if (colCount != parentColNames.get(0).size()) continue;
                    return !strict || colCount == listBucketCols.size();
                }
            }
            return false;
        }
        return false;
    }

    private boolean hasOuterJoin(JoinOperator joinOp) throws SemanticException {
        boolean hasOuter = false;
        block4: for (JoinCondDesc joinCondDesc : ((JoinDesc)joinOp.getConf()).getConds()) {
            switch (joinCondDesc.getType()) {
                case 0: 
                case 4: 
                case 5: {
                    hasOuter = false;
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: {
                    hasOuter = true;
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unknown join type " + joinCondDesc.getType());
                }
            }
        }
        return hasOuter;
    }

    private boolean isCrossProduct(JoinOperator joinOp) {
        ExprNodeDesc[][] joinExprs = ((JoinDesc)joinOp.getConf()).getJoinKeys();
        if (joinExprs != null) {
            for (ExprNodeDesc[] expr : joinExprs) {
                if (expr == null || expr.length == 0) continue;
                return false;
            }
        }
        return true;
    }

    public int getMapJoinConversionPos(JoinOperator joinOp, OptimizeTezProcContext context, int buckets, boolean skipJoinTypeChecks, long maxSize, boolean checkMapJoinThresholds) throws SemanticException {
        if (!skipJoinTypeChecks && ((JoinDesc)joinOp.getConf()).getConds().length > 1 && this.hasOuterJoin(joinOp)) {
            return -1;
        }
        Set<Integer> bigTableCandidateSet = MapJoinProcessor.getBigTableCandidates(((JoinDesc)joinOp.getConf()).getConds());
        int bigTablePosition = -1;
        long bigInputCumulativeCardinality = -1L;
        Statistics bigInputStat = null;
        boolean foundInputNotFittingInMemory = false;
        long totalSize = 0L;
        boolean convertDPHJ = false;
        for (int pos = 0; pos < joinOp.getParentOperators().size(); ++pos) {
            boolean selectedBigTable;
            long currentInputCumulativeCardinality;
            Operator<OperatorDesc> parentOp = joinOp.getParentOperators().get(pos);
            Statistics currInputStat = parentOp.getStatistics();
            if (currInputStat == null) {
                LOG.warn("Couldn't get statistics from: " + parentOp);
                return -1;
            }
            long inputSize = currInputStat.getDataSize();
            boolean currentInputNotFittingInMemory = false;
            if (bigInputStat == null || inputSize > bigInputStat.getDataSize()) {
                if (foundInputNotFittingInMemory) {
                    return -1;
                }
                if (inputSize / (long)buckets > maxSize) {
                    if (!bigTableCandidateSet.contains(pos)) {
                        return -1;
                    }
                    currentInputNotFittingInMemory = true;
                    foundInputNotFittingInMemory = true;
                }
            }
            if (foundInputNotFittingInMemory) {
                currentInputCumulativeCardinality = -1L;
            } else {
                Long cardinality = ConvertJoinMapJoin.computeCumulativeCardinality(parentOp);
                if (cardinality == null) {
                    return -1;
                }
                currentInputCumulativeCardinality = cardinality;
            }
            boolean bl = selectedBigTable = bigTableCandidateSet.contains(pos) && (bigInputStat == null || currentInputNotFittingInMemory || !foundInputNotFittingInMemory && (currentInputCumulativeCardinality > bigInputCumulativeCardinality || currentInputCumulativeCardinality == bigInputCumulativeCardinality && inputSize > bigInputStat.getDataSize()));
            if (bigInputStat != null && selectedBigTable) {
                totalSize += bigInputStat.getDataSize();
                if (checkMapJoinThresholds && !this.checkNumberOfEntriesForHashTable(joinOp, bigTablePosition, context)) {
                    convertDPHJ = true;
                }
            } else if (!selectedBigTable) {
                totalSize += inputSize;
                if (checkMapJoinThresholds && !this.checkNumberOfEntriesForHashTable(joinOp, pos, context)) {
                    convertDPHJ = true;
                }
            }
            if (totalSize / (long)buckets > maxSize) {
                return -1;
            }
            if (!selectedBigTable) continue;
            bigTablePosition = pos;
            bigInputCumulativeCardinality = currentInputCumulativeCardinality;
            bigInputStat = currInputStat;
        }
        if (checkMapJoinThresholds && convertDPHJ && this.checkShuffleSizeForLargeTable(joinOp, bigTablePosition, context)) {
            LOG.debug("Conditions to convert to MapJoin are not met");
            return -1;
        }
        ((JoinDesc)joinOp.getConf()).setInMemoryDataSize(totalSize / (long)buckets);
        return bigTablePosition;
    }

    private static Long computeCumulativeCardinality(Operator<? extends OperatorDesc> op) {
        Statistics currInputStat;
        long cumulativeCardinality = 0L;
        if (op instanceof CommonJoinOperator) {
            for (Operator<OperatorDesc> inputOp : op.getParentOperators()) {
                Long inputCardinality = ConvertJoinMapJoin.computeCumulativeCardinality(inputOp);
                if (inputCardinality == null) {
                    return null;
                }
                if (inputCardinality <= cumulativeCardinality) continue;
                cumulativeCardinality = inputCardinality;
            }
        } else {
            for (Operator<OperatorDesc> inputOp : op.getParentOperators()) {
                Long inputCardinality = ConvertJoinMapJoin.computeCumulativeCardinality(inputOp);
                if (inputCardinality == null) {
                    return null;
                }
                cumulativeCardinality += inputCardinality.longValue();
            }
        }
        if ((currInputStat = op.getStatistics()) == null) {
            LOG.warn("Couldn't get statistics from: " + op);
            return null;
        }
        return cumulativeCardinality += currInputStat.getNumRows();
    }

    public MapJoinOperator convertJoinMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, boolean removeReduceSink) throws SemanticException {
        Operator<OperatorDesc> parentBigTableOp;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (!(parentOp instanceof MuxOperator)) continue;
            return null;
        }
        MapJoinOperator mapJoinOp = MapJoinProcessor.convertJoinOpMapJoinOp(context.conf, joinOp, ((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), ((JoinDesc)joinOp.getConf()).getMapAliases(), bigTablePosition, true, removeReduceSink);
        ((MapJoinDesc)mapJoinOp.getConf()).setHybridHashJoin(HiveConf.getBoolVar(context.conf, HiveConf.ConfVars.HIVEUSEHYBRIDGRACEHASHJOIN));
        List<ExprNodeDesc> joinExprs = ((MapJoinDesc)mapJoinOp.getConf()).getKeys().values().iterator().next();
        if (joinExprs.size() == 0) {
            ((MapJoinDesc)mapJoinOp.getConf()).setHybridHashJoin(false);
        }
        if ((parentBigTableOp = mapJoinOp.getParentOperators().get(bigTablePosition)) instanceof ReduceSinkOperator) {
            Operator<OperatorDesc> parentSelectOpOfBigTableOp = parentBigTableOp.getParentOperators().get(0);
            if (removeReduceSink) {
                for (Operator<OperatorDesc> p : parentBigTableOp.getParentOperators()) {
                    HashSet<Operator<OperatorDesc>> dynamicPartitionOperators = new HashSet<Operator<OperatorDesc>>();
                    HashMap<Operator<OperatorDesc>, AppMasterEventOperator> opEventPairs = new HashMap<Operator<OperatorDesc>, AppMasterEventOperator>();
                    for (Operator<OperatorDesc> c : p.getChildOperators()) {
                        AppMasterEventOperator event = this.findDynamicPartitionBroadcast(c);
                        if (event == null) continue;
                        dynamicPartitionOperators.add(c);
                        opEventPairs.put(c, event);
                    }
                    for (Operator<OperatorDesc> c : dynamicPartitionOperators) {
                        if (!context.pruningOpsRemovedByPriorOpt.isEmpty() && context.pruningOpsRemovedByPriorOpt.contains(opEventPairs.get(c))) continue;
                        p.removeChild(c);
                        LOG.info("Disabling dynamic pruning for: " + ((DynamicPruningEventDesc)((AppMasterEventOperator)opEventPairs.get(c)).getConf()).getTableScan().getName() + ". Need to be removed together with reduce sink");
                    }
                    for (Operator<OperatorDesc> op : dynamicPartitionOperators) {
                        context.pruningOpsRemovedByPriorOpt.add((AppMasterEventOperator)opEventPairs.get(op));
                    }
                }
                mapJoinOp.getParentOperators().remove(bigTablePosition);
                if (!mapJoinOp.getParentOperators().contains(parentBigTableOp.getParentOperators().get(0))) {
                    mapJoinOp.getParentOperators().add(bigTablePosition, parentBigTableOp.getParentOperators().get(0));
                }
                parentBigTableOp.getParentOperators().get(0).removeChild(parentBigTableOp);
            }
            for (Operator<OperatorDesc> op : mapJoinOp.getParentOperators()) {
                if (!op.getChildOperators().contains(mapJoinOp)) {
                    op.getChildOperators().add(mapJoinOp);
                }
                op.getChildOperators().remove(joinOp);
            }
            if (context.parseContext.getRsToSemiJoinBranchInfo().size() > 0 && removeReduceSink) {
                this.removeCycleCreatingSemiJoinOps(mapJoinOp, parentSelectOpOfBigTableOp, context.parseContext);
            }
        }
        return mapJoinOp;
    }

    private void removeCycleCreatingSemiJoinOps(MapJoinOperator mapjoinOp, Operator<?> parentSelectOpOfBigTable, ParseContext parseContext) throws SemanticException {
        HashMap<ReduceSinkOperator, TableScanOperator> semiJoinMap = new HashMap<ReduceSinkOperator, TableScanOperator>();
        for (Operator<OperatorDesc> op : parentSelectOpOfBigTable.getChildOperators()) {
            if (!(op instanceof SelectOperator)) continue;
            while (op.getChildOperators().size() > 0) {
                op = op.getChildOperators().get(0);
            }
            if (!(op instanceof ReduceSinkOperator)) continue;
            ReduceSinkOperator rs = (ReduceSinkOperator)op;
            TableScanOperator ts = parseContext.getRsToSemiJoinBranchInfo().get(rs).getTsOp();
            if (ts == null) continue;
            Operator<OperatorDesc> parentGB = op.getParentOperators().get(0);
            block2: for (Operator<OperatorDesc> childRS : parentGB.getChildOperators()) {
                rs = (ReduceSinkOperator)childRS;
                ts = parseContext.getRsToSemiJoinBranchInfo().get(rs).getTsOp();
                assert (ts != null);
                for (Operator<OperatorDesc> parent : mapjoinOp.getParentOperators()) {
                    if (!(parent instanceof ReduceSinkOperator)) continue;
                    Set<TableScanOperator> tsOps = OperatorUtils.findOperatorsUpstream(parent, TableScanOperator.class);
                    boolean found = false;
                    for (TableScanOperator parentTS : tsOps) {
                        if (ts != parentTS) continue;
                        semiJoinMap.put(rs, ts);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block2;
                }
            }
        }
        if (semiJoinMap.size() > 0) {
            for (ReduceSinkOperator rs : semiJoinMap.keySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found semijoin optimization from the big table side of a map join, which will cause a task cycle. Removing semijoin " + OperatorUtils.getOpNamePretty(rs) + " - " + OperatorUtils.getOpNamePretty((Operator)semiJoinMap.get(rs)));
                }
                GenTezUtils.removeBranch(rs);
                GenTezUtils.removeSemiJoinOperator(parseContext, rs, (TableScanOperator)semiJoinMap.get(rs));
            }
        }
    }

    private AppMasterEventOperator findDynamicPartitionBroadcast(Operator<?> parent) {
        block0: for (Operator<OperatorDesc> op : parent.getChildOperators()) {
            while (op != null) {
                if (op instanceof AppMasterEventOperator && op.getConf() instanceof DynamicPruningEventDesc) {
                    return (AppMasterEventOperator)op;
                }
                if (op instanceof ReduceSinkOperator || op instanceof FileSinkOperator || op.getChildOperators().size() != 1) continue block0;
                op = op.getChildOperators().get(0);
            }
        }
        return null;
    }

    private static int estimateNumBuckets(JoinOperator joinOp, boolean useOpTraits) {
        int numBuckets = -1;
        int estimatedBuckets = -1;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (parentOp.getOpTraits().getNumBuckets() > 0) {
                int n = numBuckets = numBuckets < parentOp.getOpTraits().getNumBuckets() ? parentOp.getOpTraits().getNumBuckets() : numBuckets;
            }
            if (!(parentOp instanceof ReduceSinkOperator)) continue;
            ReduceSinkOperator rs = (ReduceSinkOperator)parentOp;
            estimatedBuckets = estimatedBuckets < ((ReduceSinkDesc)rs.getConf()).getNumReducers() ? ((ReduceSinkDesc)rs.getConf()).getNumReducers() : estimatedBuckets;
        }
        if (!useOpTraits) {
            numBuckets = -1;
        }
        if (numBuckets <= 0 && (numBuckets = estimatedBuckets) <= 0) {
            numBuckets = 1;
        }
        return numBuckets;
    }

    private boolean convertJoinDynamicPartitionedHashJoin(JoinOperator joinOp, OptimizeTezProcContext context, long maxSize) throws SemanticException {
        int numReducers = ConvertJoinMapJoin.estimateNumBuckets(joinOp, false);
        LOG.info("Try dynamic partitioned hash join with estimated " + numReducers + " reducers");
        int bigTablePos = this.getMapJoinConversionPos(joinOp, context, numReducers, false, maxSize, false);
        if (bigTablePos >= 0) {
            ReduceSinkOperator bigTableParentRS = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePos);
            numReducers = ((ReduceSinkDesc)bigTableParentRS.getConf()).getNumReducers();
            LOG.debug("Real big table reducers = " + numReducers);
            MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, bigTablePos, false);
            if (mapJoinOp != null) {
                LOG.info("Selected dynamic partitioned hash join");
                ((MapJoinDesc)mapJoinOp.getConf()).setDynamicPartitionHashJoin(true);
                OpTraits opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), numReducers, null, joinOp.getOpTraits().getNumReduceSinks(), joinOp.getOpTraits().getBucketingVersion());
                mapJoinOp.setOpTraits(opTraits);
                this.preserveOperatorInfos(mapJoinOp, joinOp, context);
                for (Operator<OperatorDesc> childOp : mapJoinOp.getChildOperators()) {
                    this.setAllChildrenTraits(childOp, mapJoinOp.getOpTraits());
                }
                return true;
            }
        }
        return false;
    }

    private void fallbackToReduceSideJoin(JoinOperator joinOp, OptimizeTezProcContext context, long maxSize) throws SemanticException {
        if (context.conf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN) && context.conf.getBoolVar(HiveConf.ConfVars.HIVEDYNAMICPARTITIONHASHJOIN) && this.convertJoinDynamicPartitionedHashJoin(joinOp, context, maxSize)) {
            return;
        }
        this.fallbackToMergeJoin(joinOp, context);
    }

    private void fallbackToMergeJoin(JoinOperator joinOp, OptimizeTezProcContext context) throws SemanticException {
        int pos = this.getMapJoinConversionPos(joinOp, context, ConvertJoinMapJoin.estimateNumBuckets(joinOp, false), true, Long.MAX_VALUE, false);
        if (pos < 0) {
            LOG.info("Could not get a valid join position. Defaulting to position 0");
            pos = 0;
        }
        LOG.info("Fallback to common merge join operator");
        this.convertJoinSMBJoin(joinOp, context, pos, 0, false);
    }

    private boolean checkNumberOfEntriesForHashTable(JoinOperator joinOp, int position, OptimizeTezProcContext context) {
        long max = HiveConf.getLongVar(context.parseContext.getConf(), HiveConf.ConfVars.HIVECONVERTJOINMAXENTRIESHASHTABLE);
        if (max < 1L) {
            return true;
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)joinOp.getParentOperators().get(position);
        List<String> keys = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames());
        Statistics inputStats = rsOp.getStatistics();
        ArrayList<ColStatistics> columnStats = new ArrayList<ColStatistics>();
        for (String key : keys) {
            ColStatistics cs = inputStats.getColumnStatisticsFromColName(key);
            if (cs == null) {
                LOG.debug("Couldn't get statistics for: {}", (Object)key);
                return true;
            }
            columnStats.add(cs);
        }
        long numRows = inputStats.getNumRows();
        long estimation = ConvertJoinMapJoin.estimateNDV(numRows, columnStats);
        LOG.debug("Estimated NDV for input {}: {}; Max NDV for MapJoin conversion: {}", position, estimation, max);
        if (estimation > max) {
            LOG.debug("Number of different entries for HashTable is greater than the max; we do not convert to MapJoin");
            return false;
        }
        return true;
    }

    private boolean checkShuffleSizeForLargeTable(JoinOperator joinOp, int position, OptimizeTezProcContext context) {
        long max = HiveConf.getLongVar(context.parseContext.getConf(), HiveConf.ConfVars.HIVECONVERTJOINMAXSHUFFLESIZE);
        if (max < 1L) {
            return false;
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)joinOp.getParentOperators().get(position);
        Statistics inputStats = rsOp.getStatistics();
        long inputSize = inputStats.getDataSize();
        LOG.debug("Estimated size for input {}: {}; Max size for DPHJ conversion: {}", position, inputSize, max);
        if (inputSize > max) {
            LOG.debug("Size of input is greater than the max; we do not convert to DPHJ");
            return false;
        }
        return true;
    }

    private static long estimateNDV(long numRows, List<ColStatistics> columnStats) {
        if (columnStats.size() == 1) {
            return columnStats.get(0).getCountDistint();
        }
        long n = 1L;
        for (ColStatistics cs : columnStats) {
            long ndv = cs.getCountDistint();
            if (ndv <= 1L) continue;
            n = StatsUtils.safeMult(n, ndv);
        }
        double nn = n;
        double a = (nn - 1.0) / nn;
        if (a == 1.0) {
            return numRows;
        }
        double v = nn * (1.0 - Math.pow(a, numRows));
        return Math.min(Math.round(v), numRows);
    }
}

