/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class RedundantDynamicPruningConditionsRemoval
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger(RedundantDynamicPruningConditionsRemoval.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        if (!pctx.getConf().getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_SEMIJOIN_REDUCTION)) {
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%" + FilterOperator.getOperatorName() + "%"), new FilterTransformer());
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(pctx.getTopOps().values());
            ogw.startWalking(topNodes, null);
        }
        return pctx;
    }

    private static void collect(ExprNodeDesc pred, CollectContext listContext) {
        RedundantDynamicPruningConditionsRemoval.collect(null, pred, listContext);
    }

    private static void collect(ExprNodeDesc parent, ExprNodeDesc child, CollectContext listContext) {
        if (child instanceof ExprNodeGenericFuncDesc && ((ExprNodeGenericFuncDesc)child).getGenericUDF() instanceof GenericUDFIn) {
            if (child.getChildren().get(1) instanceof ExprNodeDynamicListDesc) {
                listContext.dynamicListNodes.add(new Pair((Object)child, (Object)parent));
            }
            return;
        }
        if (child instanceof ExprNodeGenericFuncDesc && ((ExprNodeGenericFuncDesc)child).getGenericUDF() instanceof GenericUDFBaseCompare && child.getChildren().size() == 2) {
            ExprNodeDesc leftCol = child.getChildren().get(0);
            ExprNodeDesc rightCol = child.getChildren().get(1);
            ExprNodeColumnDesc leftColDesc = ExprNodeDescUtils.getColumnExpr(leftCol);
            if (leftColDesc != null) {
                boolean rightConstant = false;
                if (rightCol instanceof ExprNodeConstantDesc) {
                    rightConstant = true;
                } else if (rightCol instanceof ExprNodeGenericFuncDesc) {
                    ExprNodeDesc foldedExpr = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)rightCol);
                    boolean bl = rightConstant = foldedExpr != null;
                }
                if (rightConstant) {
                    listContext.comparatorNodes.add(leftColDesc);
                }
            } else {
                ExprNodeColumnDesc rightColDesc = ExprNodeDescUtils.getColumnExpr(rightCol);
                if (rightColDesc != null) {
                    boolean leftConstant = false;
                    if (leftCol instanceof ExprNodeConstantDesc) {
                        leftConstant = true;
                    } else if (leftCol instanceof ExprNodeGenericFuncDesc) {
                        ExprNodeDesc foldedExpr = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)leftCol);
                        boolean bl = leftConstant = foldedExpr != null;
                    }
                    if (leftConstant) {
                        listContext.comparatorNodes.add(rightColDesc);
                    }
                }
            }
            return;
        }
        if (FunctionRegistry.isOpAnd(child)) {
            for (ExprNodeDesc newChild : child.getChildren()) {
                RedundantDynamicPruningConditionsRemoval.collect(child, newChild, listContext);
            }
        }
    }

    private class CollectContext
    implements NodeProcessorCtx {
        private final List<Pair<ExprNodeDesc, ExprNodeDesc>> dynamicListNodes = Lists.newArrayList();
        private final List<ExprNodeDesc> comparatorNodes = Lists.newArrayList();
    }

    private class FilterTransformer
    implements NodeProcessor {
        private FilterTransformer() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator filter = (FilterOperator)nd;
            FilterDesc desc = (FilterDesc)filter.getConf();
            TableScanOperator ts = (TableScanOperator)stack.get(stack.size() - 2);
            CollectContext removalContext = new CollectContext();
            RedundantDynamicPruningConditionsRemoval.collect(desc.getPredicate(), removalContext);
            CollectContext tsRemovalContext = new CollectContext();
            RedundantDynamicPruningConditionsRemoval.collect(((TableScanDesc)ts.getConf()).getFilterExpr(), tsRemovalContext);
            for (Pair pair : removalContext.dynamicListNodes) {
                ExprNodeDesc child = (ExprNodeDesc)pair.left;
                ExprNodeDesc columnDesc = child.getChildren().get(0);
                assert (child.getChildren().get(1) instanceof ExprNodeDynamicListDesc);
                ExprNodeDesc parent = (ExprNodeDesc)pair.right;
                String column = ExprNodeDescUtils.extractColName(columnDesc);
                if (column == null) continue;
                Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
                boolean generate = false;
                if (table != null && table.isPartitionKey(column)) {
                    generate = true;
                    for (ExprNodeDesc filterColumnDesc : removalContext.comparatorNodes) {
                        if (!columnDesc.isSame(filterColumnDesc)) continue;
                        generate = false;
                        break;
                    }
                }
                if (generate) continue;
                ExprNodeConstantDesc constNode = new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, Boolean.TRUE);
                if (parent == null) {
                    desc.setPredicate(constNode);
                } else {
                    int i = parent.getChildren().indexOf(child);
                    parent.getChildren().remove(i);
                    parent.getChildren().add(i, constNode);
                }
                for (Pair tsPair : tsRemovalContext.dynamicListNodes) {
                    ExprNodeDesc tsChild = (ExprNodeDesc)tsPair.left;
                    ExprNodeDesc tsParent = (ExprNodeDesc)tsPair.right;
                    if (!tsChild.isSame(child)) continue;
                    if (tsParent == null) {
                        ((TableScanDesc)ts.getConf()).setFilterExpr(null);
                        break;
                    }
                    int i = tsParent.getChildren().indexOf(tsChild);
                    if (i == -1) break;
                    tsParent.getChildren().remove(i);
                    tsParent.getChildren().add(i, constNode);
                    break;
                }
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Dynamic pruning condition removed: " + child);
            }
            return false;
        }
    }
}

