/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MemoryMonitorInfo;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.ql.plan.VectorSMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorizationCondition;

@Explain(displayName="Map Join Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class MapJoinDesc
extends JoinDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Byte, List<ExprNodeDesc>> keys;
    private TableDesc keyTblDesc;
    private List<TableDesc> valueTblDescs;
    private List<TableDesc> valueFilteredTblDescs;
    private int posBigTable;
    private Map<Byte, int[]> valueIndices;
    private Map<Byte, List<Integer>> retainList;
    private transient String bigTableAlias;
    private Map<Integer, String> parentToInput = new HashMap<Integer, String>();
    private Map<Integer, Long> parentKeyCounts = new HashMap<Integer, Long>();
    private Map<Integer, Long> parentDataSizes = new HashMap<Integer, Long>();
    private Map<String, Map<String, List<String>>> aliasBucketFileNameMapping;
    private Map<String, Integer> bigTableBucketNumMapping;
    private Map<String, List<String>> bigTablePartSpecToFileMapping;
    private String dumpFilePrefix;
    private boolean isBucketMapJoin;
    private float hashtableMemoryUsage;
    protected boolean genJoinKeys = true;
    private boolean isHybridHashJoin;
    private boolean isDynamicPartitionHashJoin = false;
    private static final Set<String> vectorizableMapJoinNativeEngines = new LinkedHashSet<String>(Arrays.asList("tez", "spark"));

    public MapJoinDesc() {
        this.bigTableBucketNumMapping = new LinkedHashMap<String, Integer>();
    }

    public MapJoinDesc(MapJoinDesc clone) {
        super(clone);
        this.keys = clone.keys;
        this.keyTblDesc = clone.keyTblDesc;
        this.valueTblDescs = clone.valueTblDescs;
        this.posBigTable = clone.posBigTable;
        this.valueIndices = clone.valueIndices;
        this.retainList = clone.retainList;
        this.bigTableAlias = clone.bigTableAlias;
        this.aliasBucketFileNameMapping = clone.aliasBucketFileNameMapping;
        this.bigTableBucketNumMapping = clone.bigTableBucketNumMapping;
        this.bigTablePartSpecToFileMapping = clone.bigTablePartSpecToFileMapping;
        this.dumpFilePrefix = clone.dumpFilePrefix;
        this.parentToInput = clone.parentToInput;
        this.parentKeyCounts = clone.parentKeyCounts;
        this.parentDataSizes = clone.parentDataSizes;
        this.isBucketMapJoin = clone.isBucketMapJoin;
        this.isHybridHashJoin = clone.isHybridHashJoin;
    }

    public MapJoinDesc(Map<Byte, List<ExprNodeDesc>> keys, TableDesc keyTblDesc, Map<Byte, List<ExprNodeDesc>> values, List<TableDesc> valueTblDescs, List<TableDesc> valueFilteredTblDescs, List<String> outputColumnNames, int posBigTable, JoinCondDesc[] conds, Map<Byte, List<ExprNodeDesc>> filters, boolean noOuterJoin, String dumpFilePrefix, MemoryMonitorInfo memoryMonitorInfo, long inMemoryDataSize) {
        super(values, outputColumnNames, noOuterJoin, conds, filters, null, memoryMonitorInfo);
        this.keys = keys;
        this.keyTblDesc = keyTblDesc;
        this.valueTblDescs = valueTblDescs;
        this.valueFilteredTblDescs = valueFilteredTblDescs;
        this.posBigTable = posBigTable;
        this.bigTableBucketNumMapping = new LinkedHashMap<String, Integer>();
        this.dumpFilePrefix = dumpFilePrefix;
        this.inMemoryDataSize = inMemoryDataSize;
        this.initRetainExprList();
    }

    private void initRetainExprList() {
        this.retainList = new HashMap<Byte, List<Integer>>();
        Set<Map.Entry<Byte, List<ExprNodeDesc>>> set = super.getExprs().entrySet();
        for (Map.Entry<Byte, List<ExprNodeDesc>> current : set) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < current.getValue().size(); ++i) {
                list.add(i);
            }
            this.retainList.put(current.getKey(), list);
        }
    }

    @Explain(displayName="input vertices", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<Integer, String> getParentToInput() {
        return this.parentToInput;
    }

    public void setParentToInput(Map<Integer, String> parentToInput) {
        this.parentToInput = parentToInput;
    }

    public Map<Integer, Long> getParentKeyCounts() {
        return this.parentKeyCounts;
    }

    public Map<Integer, Long> getParentDataSizes() {
        return this.parentDataSizes;
    }

    @Explain(displayName="Estimated key counts", explainLevels={Explain.Level.EXTENDED})
    public String getKeyCountsExplainDesc() {
        StringBuilder result = null;
        for (Map.Entry<Integer, Long> entry : this.parentKeyCounts.entrySet()) {
            if (result == null) {
                result = new StringBuilder();
            } else {
                result.append(", ");
            }
            result.append(this.parentToInput.get(entry.getKey())).append(" => ").append(entry.getValue());
        }
        return result == null ? null : result.toString();
    }

    public void setParentKeyCount(Map<Integer, Long> parentKeyCounts) {
        this.parentKeyCounts = parentKeyCounts;
    }

    public Map<Byte, int[]> getValueIndices() {
        return this.valueIndices;
    }

    public void setValueIndices(Map<Byte, int[]> valueIndices) {
        this.valueIndices = valueIndices;
    }

    public int[] getValueIndex(byte alias) {
        return this.valueIndices == null ? null : this.valueIndices.get(alias);
    }

    public Map<Byte, List<Integer>> getRetainList() {
        return this.retainList;
    }

    public void setRetainList(Map<Byte, List<Integer>> retainList) {
        this.retainList = retainList;
    }

    public String getDumpFilePrefix() {
        return this.dumpFilePrefix;
    }

    public void setDumpFilePrefix(String dumpFilePrefix) {
        this.dumpFilePrefix = dumpFilePrefix;
    }

    @Override
    @Explain(displayName="keys")
    public Map<String, String> getKeysString() {
        LinkedHashMap<String, String> keyMap = new LinkedHashMap<String, String>();
        for (Map.Entry<Byte, List<ExprNodeDesc>> k : this.getKeys().entrySet()) {
            keyMap.put(String.valueOf(k.getKey()), PlanUtils.getExprListString((Collection<? extends ExprNodeDesc>)k.getValue()));
        }
        return keyMap;
    }

    @Override
    @Explain(displayName="keys", explainLevels={Explain.Level.USER})
    public Map<Byte, String> getUserLevelExplainKeysString() {
        LinkedHashMap<Byte, String> keyMap = new LinkedHashMap<Byte, String>();
        for (Map.Entry<Byte, List<ExprNodeDesc>> k : this.getKeys().entrySet()) {
            keyMap.put(k.getKey(), PlanUtils.getExprListString((Collection<? extends ExprNodeDesc>)k.getValue(), true));
        }
        return keyMap;
    }

    public Map<Byte, List<ExprNodeDesc>> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<Byte, List<ExprNodeDesc>> keys) {
        this.keys = keys;
    }

    @Explain(displayName="Position of Big Table", explainLevels={Explain.Level.EXTENDED})
    public int getPosBigTable() {
        return this.posBigTable;
    }

    public void setPosBigTable(int posBigTable) {
        this.posBigTable = posBigTable;
    }

    public TableDesc getKeyTblDesc() {
        return this.keyTblDesc;
    }

    public void setKeyTblDesc(TableDesc keyTblDesc) {
        this.keyTblDesc = keyTblDesc;
    }

    public List<TableDesc> getValueFilteredTblDescs() {
        return this.valueFilteredTblDescs;
    }

    public void setValueFilteredTblDescs(List<TableDesc> valueFilteredTblDescs) {
        this.valueFilteredTblDescs = valueFilteredTblDescs;
    }

    public List<TableDesc> getValueTblDescs() {
        return this.valueTblDescs;
    }

    public void setValueTblDescs(List<TableDesc> valueTblDescs) {
        this.valueTblDescs = valueTblDescs;
    }

    public String getBigTableAlias() {
        return this.bigTableAlias;
    }

    public void setBigTableAlias(String bigTableAlias) {
        this.bigTableAlias = bigTableAlias;
    }

    public Map<String, Map<String, List<String>>> getAliasBucketFileNameMapping() {
        return this.aliasBucketFileNameMapping;
    }

    public void setAliasBucketFileNameMapping(Map<String, Map<String, List<String>>> aliasBucketFileNameMapping) {
        this.aliasBucketFileNameMapping = aliasBucketFileNameMapping;
    }

    public Map<String, Integer> getBigTableBucketNumMapping() {
        return this.bigTableBucketNumMapping;
    }

    public void setBigTableBucketNumMapping(Map<String, Integer> bigTableBucketNumMapping) {
        this.bigTableBucketNumMapping = bigTableBucketNumMapping;
    }

    public Map<String, List<String>> getBigTablePartSpecToFileMapping() {
        return this.bigTablePartSpecToFileMapping;
    }

    public void setBigTablePartSpecToFileMapping(Map<String, List<String>> partToFileMapping) {
        this.bigTablePartSpecToFileMapping = partToFileMapping;
    }

    @Explain(displayName="BucketMapJoin", explainLevels={Explain.Level.USER, Explain.Level.EXTENDED}, displayOnlyOnTrue=true)
    public boolean isBucketMapJoin() {
        return this.isBucketMapJoin;
    }

    public void setBucketMapJoin(boolean isBucketMapJoin) {
        this.isBucketMapJoin = isBucketMapJoin;
    }

    @Explain(displayName="HybridGraceHashJoin", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, displayOnlyOnTrue=true)
    public boolean isHybridHashJoin() {
        return this.isHybridHashJoin;
    }

    public void setHybridHashJoin(boolean isHybridHashJoin) {
        this.isHybridHashJoin = isHybridHashJoin;
    }

    public void setHashTableMemoryUsage(float hashtableMemoryUsage) {
        this.hashtableMemoryUsage = hashtableMemoryUsage;
    }

    public float getHashTableMemoryUsage() {
        return this.hashtableMemoryUsage;
    }

    @Override
    public boolean isMapSideJoin() {
        return true;
    }

    public void setGenJoinKeys(boolean genJoinKeys) {
        this.genJoinKeys = genJoinKeys;
    }

    public boolean getGenJoinKeys() {
        return this.genJoinKeys;
    }

    public boolean isDynamicPartitionHashJoin() {
        return this.isDynamicPartitionHashJoin;
    }

    public void setDynamicPartitionHashJoin(boolean isDistributedHashJoin) {
        this.isDynamicPartitionHashJoin = isDistributedHashJoin;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Map Join Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public MapJoinOperatorExplainVectorization getMapJoinVectorization() {
        VectorMapJoinDesc vectorMapJoinDesc = (VectorMapJoinDesc)this.getVectorDesc();
        if (vectorMapJoinDesc == null || this instanceof SMBJoinDesc) {
            return null;
        }
        return new MapJoinOperatorExplainVectorization(this, vectorMapJoinDesc);
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="SMB Map Join Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public SMBJoinOperatorExplainVectorization getSMBJoinVectorization() {
        VectorSMBJoinDesc vectorSMBJoinDesc = (VectorSMBJoinDesc)this.getVectorDesc();
        if (vectorSMBJoinDesc == null || !(this instanceof SMBJoinDesc)) {
            return null;
        }
        return new SMBJoinOperatorExplainVectorization((SMBJoinDesc)this, vectorSMBJoinDesc);
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (super.isSame(other)) {
            MapJoinDesc otherDesc = (MapJoinDesc)other;
            return Objects.equals(this.getParentToInput(), otherDesc.getParentToInput()) && Objects.equals(this.getKeyCountsExplainDesc(), otherDesc.getKeyCountsExplainDesc()) && this.getPosBigTable() == otherDesc.getPosBigTable() && this.isBucketMapJoin() == otherDesc.isBucketMapJoin();
        }
        return false;
    }

    public class SMBJoinOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final SMBJoinDesc smbJoinDesc;
        private final VectorSMBJoinDesc vectorSMBJoinDesc;

        public SMBJoinOperatorExplainVectorization(SMBJoinDesc smbJoinDesc, VectorSMBJoinDesc vectorSMBJoinDesc) {
            super(vectorSMBJoinDesc, false);
            this.smbJoinDesc = smbJoinDesc;
            this.vectorSMBJoinDesc = vectorSMBJoinDesc;
        }
    }

    public class MapJoinOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final MapJoinDesc mapJoinDesc;
        private final VectorMapJoinDesc vectorMapJoinDesc;
        private final VectorMapJoinInfo vectorMapJoinInfo;
        private VectorizationCondition[] nativeConditions;

        public MapJoinOperatorExplainVectorization(MapJoinDesc mapJoinDesc, VectorMapJoinDesc vectorMapJoinDesc) {
            super(vectorMapJoinDesc, vectorMapJoinDesc.getHashTableImplementationType() != VectorMapJoinDesc.HashTableImplementationType.NONE);
            this.mapJoinDesc = mapJoinDesc;
            this.vectorMapJoinDesc = vectorMapJoinDesc;
            this.vectorMapJoinInfo = vectorMapJoinDesc != null ? vectorMapJoinDesc.getVectorMapJoinInfo() : null;
        }

        private VectorizationCondition[] createNativeConditions() {
            boolean enabled = this.vectorMapJoinDesc.getIsVectorizationMapJoinNativeEnabled();
            String engine = this.vectorMapJoinDesc.getEngine();
            String engineInSupportedCondName = HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname + " " + engine + " IN " + vectorizableMapJoinNativeEngines;
            boolean engineInSupported = vectorizableMapJoinNativeEngines.contains(engine);
            boolean isFastHashTableEnabled = this.vectorMapJoinDesc.getIsFastHashTableEnabled();
            ArrayList<VectorizationCondition> conditionList = new ArrayList<VectorizationCondition>();
            conditionList.add(new VectorizationCondition(this.vectorMapJoinDesc.getUseOptimizedTable(), HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE.varname));
            conditionList.add(new VectorizationCondition(enabled, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_ENABLED.varname));
            conditionList.add(new VectorizationCondition(engineInSupported, engineInSupportedCondName));
            conditionList.add(new VectorizationCondition(this.vectorMapJoinDesc.getOneMapJoinCondition(), "One MapJoin Condition"));
            conditionList.add(new VectorizationCondition(!this.vectorMapJoinDesc.getHasNullSafes(), "No nullsafe"));
            conditionList.add(new VectorizationCondition(this.vectorMapJoinDesc.getSmallTableExprVectorizes(), "Small table vectorizes"));
            if (!this.mapJoinDesc.isNoOuterJoin()) {
                conditionList.add(new VectorizationCondition(!this.vectorMapJoinDesc.getOuterJoinHasNoKeys(), "Outer Join has keys"));
            }
            if (isFastHashTableEnabled) {
                conditionList.add(new VectorizationCondition(!this.vectorMapJoinDesc.getIsHybridHashJoin(), "Fast Hash Table and No Hybrid Hash Join"));
            } else {
                conditionList.add(new VectorizationCondition(this.vectorMapJoinDesc.getSupportsKeyTypes(), "Optimized Table and Supports Key Types"));
            }
            VectorizationCondition[] conditions = conditionList.toArray(new VectorizationCondition[0]);
            return conditions;
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="nativeConditionsMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getNativeConditionsMet() {
            if (this.nativeConditions == null) {
                this.nativeConditions = this.createNativeConditions();
            }
            return VectorizationCondition.getConditionsMet(this.nativeConditions);
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="nativeConditionsNotMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getNativeConditionsNotMet() {
            if (this.nativeConditions == null) {
                this.nativeConditions = this.createNativeConditions();
            }
            return VectorizationCondition.getConditionsNotMet(this.nativeConditions);
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="bigTableKeyExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getBigTableKeyExpressions() {
            return this.vectorExpressionsToStringList(this.isNative ? this.vectorMapJoinInfo.getSlimmedBigTableKeyExpressions() : this.vectorMapJoinDesc.getAllBigTableKeyExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="bigTableKeyColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getBigTableKeyColumnNums() {
            if (!this.isNative) {
                return null;
            }
            int[] bigTableKeyColumnMap = this.vectorMapJoinInfo.getBigTableKeyColumnMap();
            if (bigTableKeyColumnMap.length == 0) {
                return null;
            }
            return Arrays.toString(bigTableKeyColumnMap);
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="bigTableValueExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getBigTableValueExpressions() {
            return this.vectorExpressionsToStringList(this.isNative ? this.vectorMapJoinInfo.getSlimmedBigTableValueExpressions() : this.vectorMapJoinDesc.getAllBigTableValueExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="bigTableValueColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getBigTableValueColumnNums() {
            if (!this.isNative) {
                return null;
            }
            int[] bigTableValueColumnMap = this.vectorMapJoinInfo.getBigTableValueColumnMap();
            if (bigTableValueColumnMap.length == 0) {
                return null;
            }
            return Arrays.toString(bigTableValueColumnMap);
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="smallTableMapping", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getSmallTableColumns() {
            if (!this.isNative) {
                return null;
            }
            return this.outputColumnsToStringList(this.vectorMapJoinInfo.getSmallTableMapping());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="projectedOutputColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getProjectedOutputColumnNums() {
            if (!this.isNative) {
                return null;
            }
            return this.outputColumnsToStringList(this.vectorMapJoinInfo.getProjectionMapping());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="bigTableOuterKeyMapping", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getBigTableOuterKey() {
            if (!this.isNative || this.vectorMapJoinDesc.getVectorMapJoinVariation() != VectorMapJoinDesc.VectorMapJoinVariation.OUTER) {
                return null;
            }
            return this.columnMappingToStringList(this.vectorMapJoinInfo.getBigTableOuterKeyMapping());
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="bigTableRetainedColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getBigTableRetainedColumnNums() {
            if (!this.isNative) {
                return null;
            }
            return this.outputColumnsToStringList(this.vectorMapJoinInfo.getBigTableRetainedMapping());
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="nativeNotSupportedKeyTypes", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getNativeNotSupportedKeyTypes() {
            return this.vectorMapJoinDesc.getNotSupportedKeyTypes();
        }
    }
}

