/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.metastore.Column;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class TableToPartitionMapping {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TableToPartitionMapping.class).instanceSize();
    private static final int INTEGER_INSTANCE_SIZE = ClassLayout.parseClass(Integer.class).instanceSize();
    private static final int OPTIONAL_INSTANCE_SIZE = ClassLayout.parseClass(Optional.class).instanceSize();
    private final Optional<Map<Integer, Integer>> tableToPartitionColumns;
    private final Map<Integer, Column> partitionSchemaDifference;

    public static TableToPartitionMapping empty() {
        return new TableToPartitionMapping(Optional.empty(), (Map<Integer, Column>)ImmutableMap.of());
    }

    public static TableToPartitionMapping mapColumnsByIndex(Map<Integer, Column> partitionSchemaDifference) {
        return new TableToPartitionMapping(Optional.empty(), partitionSchemaDifference);
    }

    @JsonCreator
    public TableToPartitionMapping(@JsonProperty(value="tableToPartitionColumns") Optional<Map<Integer, Integer>> tableToPartitionColumns, @JsonProperty(value="partitionSchemaDifference") Map<Integer, Column> partitionSchemaDifference) {
        this.tableToPartitionColumns = tableToPartitionColumns.map(TableToPartitionMapping::isIdentityMapping).orElse(true) != false ? Optional.empty() : Objects.requireNonNull(tableToPartitionColumns, "tableToPartitionColumns is null").map(ImmutableMap::copyOf);
        this.partitionSchemaDifference = ImmutableMap.copyOf(Objects.requireNonNull(partitionSchemaDifference, "partitionSchemaDifference is null"));
    }

    @VisibleForTesting
    static boolean isIdentityMapping(Map<Integer, Integer> map) {
        for (int i = 0; i < map.size(); ++i) {
            if (Objects.equals(map.get(i), i)) continue;
            return false;
        }
        return true;
    }

    @JsonProperty
    public Optional<Map<Integer, Integer>> getTableToPartitionColumns() {
        return this.tableToPartitionColumns;
    }

    @JsonProperty
    public Map<Integer, Column> getPartitionSchemaDifference() {
        return this.partitionSchemaDifference;
    }

    public Optional<Column> getPartitionColumn(int tableColumnIndex) {
        return this.getPartitionColumnIndex(tableColumnIndex).flatMap(partitionColumnIndex -> Optional.ofNullable(this.partitionSchemaDifference.get(partitionColumnIndex)));
    }

    private Optional<Integer> getPartitionColumnIndex(int tableColumnIndex) {
        if (!this.tableToPartitionColumns.isPresent()) {
            return Optional.of(tableColumnIndex);
        }
        return Optional.ofNullable(this.tableToPartitionColumns.get().get(tableColumnIndex));
    }

    public int getEstimatedSizeInBytes() {
        int result = INSTANCE_SIZE;
        result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.partitionSchemaDifference.size()));
        for (Column column : this.partitionSchemaDifference.values()) {
            result += INTEGER_INSTANCE_SIZE + column.getEstimatedSizeInBytes();
        }
        result += OPTIONAL_INSTANCE_SIZE;
        if (this.tableToPartitionColumns.isPresent()) {
            result = (int)((long)result + (SizeOf.sizeOfObjectArray((int)this.tableToPartitionColumns.get().size()) + (long)(2 * this.tableToPartitionColumns.get().size() * INTEGER_INSTANCE_SIZE)));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionSchemaDifference", this.partitionSchemaDifference).add("tableToPartitionColumns", this.tableToPartitionColumns).toString();
    }
}

