/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.CustomSplitConverter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.hadoop.realtime.RealtimeBootstrapBaseFileSplit;

public class HudiRealtimeBootstrapBaseFileSplitConverter
implements CustomSplitConverter {
    private static final String DELTA_FILE_PATHS_KEY = "delta_file_paths";
    private static final String BASE_PATH_KEY = "base_path";
    private static final String MAX_COMMIT_TIME_KEY = "max_commit_time";
    private static final String BOOTSTRAP_FILE_SPLIT_PATH = "bootstrap_split_path";
    private static final String BOOTSTRAP_FILE_SPLIT_START = "bootstrap_split_start";
    private static final String BOOTSTRAP_FILE_SPLIT_LEN = "bootstrap_split_len";

    @Override
    public Optional<Map<String, String>> extractCustomSplitInfo(FileSplit split) {
        if (split instanceof RealtimeBootstrapBaseFileSplit) {
            ImmutableMap.Builder customSplitInfo = ImmutableMap.builder();
            RealtimeBootstrapBaseFileSplit hudiSplit = (RealtimeBootstrapBaseFileSplit)split;
            customSplitInfo.put((Object)"custom_split_class", (Object)RealtimeBootstrapBaseFileSplit.class.getName());
            customSplitInfo.put((Object)BASE_PATH_KEY, (Object)hudiSplit.getBasePath());
            customSplitInfo.put((Object)MAX_COMMIT_TIME_KEY, (Object)hudiSplit.getMaxCommitTime());
            customSplitInfo.put((Object)DELTA_FILE_PATHS_KEY, (Object)String.join((CharSequence)",", hudiSplit.getDeltaLogPaths()));
            customSplitInfo.put((Object)BOOTSTRAP_FILE_SPLIT_PATH, (Object)hudiSplit.getBootstrapFileSplit().getPath().toString());
            customSplitInfo.put((Object)BOOTSTRAP_FILE_SPLIT_START, (Object)String.valueOf(hudiSplit.getBootstrapFileSplit().getStart()));
            customSplitInfo.put((Object)BOOTSTRAP_FILE_SPLIT_LEN, (Object)String.valueOf(hudiSplit.getBootstrapFileSplit().getLength()));
            return Optional.of(customSplitInfo.build());
        }
        return Optional.empty();
    }

    @Override
    public Optional<FileSplit> recreateFileSplitWithCustomInfo(FileSplit split, Map<String, String> customSplitInfo) throws IOException {
        Objects.requireNonNull(customSplitInfo);
        String customFileSplitClass = customSplitInfo.get("custom_split_class");
        if (!Strings.isNullOrEmpty((String)customFileSplitClass) && RealtimeBootstrapBaseFileSplit.class.getName().equals(customFileSplitClass)) {
            String deltaFilePaths = customSplitInfo.get(DELTA_FILE_PATHS_KEY);
            List deltaLogPaths = Strings.isNullOrEmpty((String)deltaFilePaths) ? Collections.emptyList() : Arrays.asList(deltaFilePaths.split(","));
            List deltaLogFiles = deltaLogPaths.stream().map(p -> new HoodieLogFile(new Path(p))).collect(Collectors.toList());
            FileSplit bootstrapFileSplit = new FileSplit(new Path(customSplitInfo.get(BOOTSTRAP_FILE_SPLIT_PATH)), Long.parseLong(customSplitInfo.get(BOOTSTRAP_FILE_SPLIT_START)), Long.parseLong(customSplitInfo.get(BOOTSTRAP_FILE_SPLIT_LEN)), (String[])null);
            split = new RealtimeBootstrapBaseFileSplit(split, customSplitInfo.get(BASE_PATH_KEY), deltaLogFiles, customSplitInfo.get(MAX_COMMIT_TIME_KEY), bootstrapFileSplit);
            return Optional.of(split);
        }
        return Optional.empty();
    }
}

