/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.ChannelAuthenticationScheme;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcConnection;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.SaslAuthenticationServiceGrpc;
import alluxio.grpc.SaslMessage;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedChannelClientDriver;
import alluxio.security.authentication.ChannelIdInjector;
import alluxio.security.authentication.SaslClientHandler;
import alluxio.security.authentication.plain.SaslClientHandlerPlain;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import java.net.SocketAddress;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelAuthenticator.class);
    private final GrpcChannelKey mChannelKey;
    private final GrpcConnection mConnection;
    private final Subject mParentSubject;
    private final AuthType mAuthType;
    private AlluxioConfiguration mConfiguration;
    private AuthenticatedChannelClientDriver mAuthDriver;
    private Channel mAuthenticatedChannel;

    public ChannelAuthenticator(GrpcConnection connection, Subject subject, AuthType authType, AlluxioConfiguration conf) {
        this.mConnection = connection;
        this.mChannelKey = this.mConnection.getChannelKey();
        this.mParentSubject = subject;
        this.mAuthType = authType;
        this.mConfiguration = conf;
    }

    public void authenticate() throws AlluxioStatusException {
        LOG.debug("Authenticating channel: {}. AuthType: {}", (Object)this.mChannelKey.toStringShort(), (Object)this.mAuthType);
        ChannelAuthenticationScheme authScheme = this.getChannelAuthScheme(this.mAuthType, this.mParentSubject, this.mChannelKey.getServerAddress().getSocketAddress());
        try {
            this.mAuthDriver = new AuthenticatedChannelClientDriver(this.createSaslClientHandler(this.mChannelKey.getServerAddress(), authScheme, this.mParentSubject), this.mChannelKey);
            SaslAuthenticationServiceGrpc.SaslAuthenticationServiceStub serverStub = SaslAuthenticationServiceGrpc.newStub(this.mConnection.getChannel());
            StreamObserver<SaslMessage> requestObserver = serverStub.authenticate(this.mAuthDriver);
            this.mAuthDriver.setServerObserver(requestObserver);
            long authTimeout = this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_AUTH_TIMEOUT);
            this.mAuthDriver.startAuthenticatedChannel(authTimeout);
            this.mConnection.interceptChannel(new ChannelIdInjector(this.mChannelKey.getChannelId()));
        }
        catch (Throwable t) {
            AlluxioStatusException e = AlluxioStatusException.fromThrowable(t);
            String message = String.format("Channel authentication failed with code:%s. Channel: %s, AuthType: %s, Error: %s", new Object[]{e.getStatusCode().name(), this.mChannelKey.toStringShort(), this.mAuthType, e.toString()});
            throw AlluxioStatusException.from(Status.fromCode(e.getStatusCode()).withDescription(message).withCause(t));
        }
    }

    public Channel getAuthenticatedChannel() {
        return this.mAuthenticatedChannel;
    }

    public AuthenticatedChannelClientDriver getAuthenticationDriver() {
        return this.mAuthDriver;
    }

    private ChannelAuthenticationScheme getChannelAuthScheme(AuthType authType, Subject subject, SocketAddress serverAddress) throws UnauthenticatedException {
        switch (authType) {
            case NOSASL: {
                return ChannelAuthenticationScheme.NOSASL;
            }
            case SIMPLE: {
                return ChannelAuthenticationScheme.SIMPLE;
            }
            case CUSTOM: {
                return ChannelAuthenticationScheme.CUSTOM;
            }
        }
        throw new UnauthenticatedException(String.format("Configured authentication type is not supported: %s", authType.getAuthName()));
    }

    private SaslClientHandler createSaslClientHandler(GrpcServerAddress serverAddress, ChannelAuthenticationScheme authScheme, Subject subject) throws UnauthenticatedException {
        switch (authScheme) {
            case SIMPLE: 
            case CUSTOM: {
                return new SaslClientHandlerPlain(this.mParentSubject, this.mConfiguration);
            }
        }
        throw new UnauthenticatedException(String.format("Channel authentication scheme not supported: %s", authScheme.name()));
    }
}

