/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs.testing;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

public class MockRequest
implements Request {
    private final String method;
    private final Variant selectVariant;
    private final EntityTag ifMatch;
    private final EntityTag ifNoneMatch;
    private final Date ifModifiedSince;
    private final Date ifUnmodifiedSince;

    public static ConditionalRequestBuilder head() {
        return new ConditionalRequestBuilder("HEAD");
    }

    public static ConditionalRequestBuilder head(Variant selectVariant) {
        return new ConditionalRequestBuilder("HEAD", selectVariant);
    }

    public static ConditionalRequestBuilder get() {
        return new ConditionalRequestBuilder("GET");
    }

    public static ConditionalRequestBuilder get(Variant selectVariant) {
        return new ConditionalRequestBuilder("GET", selectVariant);
    }

    public static ConditionalRequestBuilder post() {
        return new ConditionalRequestBuilder("POST");
    }

    public static ConditionalRequestBuilder post(Variant selectVariant) {
        return new ConditionalRequestBuilder("POST", selectVariant);
    }

    public static ConditionalRequestBuilder put() {
        return new ConditionalRequestBuilder("PUT");
    }

    public static ConditionalRequestBuilder put(Variant selectVariant) {
        return new ConditionalRequestBuilder("PUT", selectVariant);
    }

    public static ConditionalRequestBuilder delete() {
        return new ConditionalRequestBuilder("DELETE");
    }

    public static ConditionalRequestBuilder delete(Variant selectVariant) {
        return new ConditionalRequestBuilder("DELETE", selectVariant);
    }

    private MockRequest(String method, Variant selectVariant, EntityTag ifMatch, EntityTag ifNoneMatch, Date ifModifiedSince, Date ifUnmodifiedSince) {
        this.method = method;
        this.selectVariant = selectVariant;
        this.ifMatch = ifMatch;
        this.ifNoneMatch = ifNoneMatch;
        this.ifModifiedSince = ifModifiedSince;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
    }

    public String getMethod() {
        return this.method;
    }

    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        Objects.requireNonNull(variants, "variants is null");
        Preconditions.checkArgument((!variants.isEmpty() ? 1 : 0) != 0, (Object)"variants is empty");
        return this.selectVariant;
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        if (this.ifMatch != null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
        }
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        Objects.requireNonNull(eTag, "eTag is null");
        return MockRequest.firstNonNull(this.evaluateIfMatch(eTag), this.evaluateIfNoneMatch(eTag));
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        Objects.requireNonNull(lastModified, "lastModified is null");
        return MockRequest.firstNonNull(this.evaluateIfModifiedSince(lastModified), this.evaluateIfUnmodifiedSince(lastModified));
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        Objects.requireNonNull(eTag, "eTag is null");
        Objects.requireNonNull(lastModified, "lastModified is null");
        return MockRequest.firstNonNull(this.evaluatePreconditions(lastModified), this.evaluatePreconditions(eTag));
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag) {
        if (this.ifMatch == null) {
            return null;
        }
        if (eTag.isWeak()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(eTag);
        }
        if ("*".equals(this.ifMatch.getValue()) || eTag.getValue().equals(this.ifMatch.getValue())) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(eTag);
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag tag) {
        if (this.ifNoneMatch == null) {
            return null;
        }
        if (!"*".equals(this.ifNoneMatch.getValue()) && !tag.getValue().equals(this.ifNoneMatch.getValue())) {
            return null;
        }
        if ("GET".equalsIgnoreCase(this.getMethod()) || "HEAD".equalsIgnoreCase(this.getMethod())) {
            return Response.notModified((EntityTag)tag);
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(tag);
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(Date lastModified) {
        if (this.ifModifiedSince == null) {
            return null;
        }
        if (!"GET".equalsIgnoreCase(this.method) && !"HEAD".equalsIgnoreCase(this.method)) {
            return null;
        }
        if (lastModified.after(this.ifModifiedSince)) {
            return null;
        }
        return Response.notModified();
    }

    private Response.ResponseBuilder evaluateIfUnmodifiedSince(Date lastModified) {
        if (this.ifUnmodifiedSince == null) {
            return null;
        }
        if (!lastModified.after(this.ifUnmodifiedSince)) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
    }

    private static <T> T firstNonNull(T first, T second) {
        return first != null ? first : second;
    }

    public static class ConditionalRequestBuilder {
        private final String method;
        private final Variant selectVariant;

        private ConditionalRequestBuilder(String method) {
            this.method = method;
            this.selectVariant = null;
        }

        private ConditionalRequestBuilder(String method, Variant selectVariant) {
            this.method = method;
            this.selectVariant = selectVariant;
        }

        public MockRequest ifMatch(EntityTag ifMatch) {
            return new MockRequest(this.method, this.selectVariant, ifMatch, null, null, null);
        }

        public MockRequest ifNoneMatch(EntityTag ifNoneMatch) {
            return new MockRequest(this.method, this.selectVariant, null, ifNoneMatch, null, null);
        }

        public MockRequest ifModifiedSince(Date ifModifiedSince) {
            return new MockRequest(this.method, this.selectVariant, null, null, ifModifiedSince, null);
        }

        public MockRequest ifUnmodifiedSince(Date ifUnmodifiedSince) {
            return new MockRequest(this.method, this.selectVariant, null, null, null, ifUnmodifiedSince);
        }

        public MockRequest unconditionally() {
            return new MockRequest(this.method, this.selectVariant, null, null, null, null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.method);
            if (this.selectVariant != null) {
                sb.append("{").append(this.selectVariant).append('}');
            }
            return sb.toString();
        }
    }
}

