/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.session;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.session.FileSessionPropertyManagerConfig;
import com.facebook.presto.session.SessionMatchSpec;
import com.facebook.presto.spi.session.SessionConfigurationContext;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManager;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class FileSessionPropertyManager
implements SessionPropertyConfigurationManager {
    public static final JsonCodec<List<SessionMatchSpec>> CODEC = new JsonCodecFactory(() -> new JsonObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).listJsonCodec(SessionMatchSpec.class);
    private final List<SessionMatchSpec> sessionMatchSpecs;

    @Inject
    public FileSessionPropertyManager(FileSessionPropertyManagerConfig config) {
        Objects.requireNonNull(config, "config is null");
        Path configurationFile = config.getConfigFile().toPath();
        try {
            this.sessionMatchSpecs = (List)CODEC.fromJson(Files.readAllBytes(configurationFile));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnrecognizedPropertyException) {
                UnrecognizedPropertyException ex = (UnrecognizedPropertyException)cause;
                String message = String.format("Unknown property at line %s:%s: %s", ex.getLocation().getLineNr(), ex.getLocation().getColumnNr(), ex.getPropertyName());
                throw new IllegalArgumentException(message, e);
            }
            if (cause instanceof JsonMappingException) {
                if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                throw new IllegalArgumentException(cause.getMessage(), e);
            }
            throw e;
        }
    }

    public SessionPropertyConfigurationManager.SystemSessionPropertyConfiguration getSystemSessionProperties(SessionConfigurationContext context) {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        HashSet<String> overridePropertyNames = new HashSet<String>();
        for (SessionMatchSpec sessionMatchSpec : this.sessionMatchSpecs) {
            Map<String, String> newProperties = sessionMatchSpec.match(context);
            defaultProperties.putAll(newProperties);
            if (!sessionMatchSpec.getOverrideSessionProperties().orElse(false).booleanValue()) continue;
            overridePropertyNames.addAll(newProperties.keySet());
        }
        HashMap overrideProperties = new HashMap();
        for (String propertyName : overridePropertyNames) {
            overrideProperties.put(propertyName, defaultProperties.get(propertyName));
        }
        return new SessionPropertyConfigurationManager.SystemSessionPropertyConfiguration((Map)ImmutableMap.copyOf(defaultProperties), (Map)ImmutableMap.copyOf(overrideProperties));
    }

    public Map<String, Map<String, String>> getCatalogSessionProperties(SessionConfigurationContext context) {
        return ImmutableMap.of();
    }
}

