/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.session;

import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.session.SessionConfigurationContext;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class SessionMatchSpec {
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> sourceRegex;
    private final Set<String> clientTags;
    private final Optional<String> queryType;
    private final Optional<Pattern> clientInfoRegex;
    private final Optional<Pattern> resourceGroupRegex;
    private final Optional<Boolean> overrideSessionProperties;
    private final Map<String, String> sessionProperties;

    @JsonCreator
    public SessionMatchSpec(@JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="source") Optional<Pattern> sourceRegex, @JsonProperty(value="clientTags") Optional<List<String>> clientTags, @JsonProperty(value="queryType") Optional<String> queryType, @JsonProperty(value="group") Optional<Pattern> resourceGroupRegex, @JsonProperty(value="clientInfo") Optional<Pattern> clientInfoRegex, @JsonProperty(value="overrideSessionProperties") Optional<Boolean> overrideSessionProperties, @JsonProperty(value="sessionProperties") Map<String, String> sessionProperties) {
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.sourceRegex = Objects.requireNonNull(sourceRegex, "sourceRegex is null");
        Objects.requireNonNull(clientTags, "clientTags is null");
        this.clientTags = ImmutableSet.copyOf((Collection)clientTags.orElse((List<String>)ImmutableList.of()));
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.resourceGroupRegex = Objects.requireNonNull(resourceGroupRegex, "resourceGroupRegex is null");
        this.clientInfoRegex = Objects.requireNonNull(clientInfoRegex, "clientInfoRegex is null");
        this.overrideSessionProperties = Objects.requireNonNull(overrideSessionProperties, "overrideSessionProperties is null");
        Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
    }

    public Map<String, String> match(SessionConfigurationContext context) {
        if (this.userRegex.isPresent() && !this.userRegex.get().matcher(context.getUser()).matches()) {
            return ImmutableMap.of();
        }
        if (this.sourceRegex.isPresent()) {
            String source = context.getSource().orElse("");
            if (!this.sourceRegex.get().matcher(source).matches()) {
                return ImmutableMap.of();
            }
        }
        if (!this.clientTags.isEmpty() && !context.getClientTags().containsAll(this.clientTags)) {
            return ImmutableMap.of();
        }
        if (this.queryType.isPresent()) {
            String contextQueryType = context.getQueryType().orElse("");
            if (!this.queryType.get().equalsIgnoreCase(contextQueryType)) {
                return ImmutableMap.of();
            }
        }
        if (this.clientInfoRegex.isPresent()) {
            String clientInfo = context.getClientInfo().orElse("");
            if (!this.clientInfoRegex.get().matcher(clientInfo).matches()) {
                return ImmutableMap.of();
            }
        }
        if (this.resourceGroupRegex.isPresent()) {
            String resourceGroupId = context.getResourceGroupId().map(ResourceGroupId::toString).orElse("");
            if (!this.resourceGroupRegex.get().matcher(resourceGroupId).matches()) {
                return ImmutableMap.of();
            }
        }
        return this.sessionProperties;
    }

    @JsonProperty(value="user")
    public Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    @JsonProperty(value="source")
    public Optional<Pattern> getSourceRegex() {
        return this.sourceRegex;
    }

    @JsonProperty
    public Set<String> getClientTags() {
        return this.clientTags;
    }

    @JsonProperty
    public Optional<String> getQueryType() {
        return this.queryType;
    }

    @JsonProperty(value="group")
    public Optional<Pattern> getResourceGroupRegex() {
        return this.resourceGroupRegex;
    }

    @JsonProperty
    public Optional<Pattern> getClientInfoRegex() {
        return this.clientInfoRegex;
    }

    @JsonProperty
    public Optional<Boolean> getOverrideSessionProperties() {
        return this.overrideSessionProperties;
    }

    @JsonProperty
    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }
}

