/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreOperationResult;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface ExtendedHiveMetastore {
    public Optional<Database> getDatabase(MetastoreContext var1, String var2);

    public List<String> getAllDatabases(MetastoreContext var1);

    public Optional<Table> getTable(MetastoreContext var1, String var2, String var3);

    public Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext var1, Type var2);

    public PartitionStatistics getTableStatistics(MetastoreContext var1, String var2, String var3);

    public Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext var1, String var2, String var3, Set<String> var4);

    public void updateTableStatistics(MetastoreContext var1, String var2, String var3, Function<PartitionStatistics, PartitionStatistics> var4);

    public void updatePartitionStatistics(MetastoreContext var1, String var2, String var3, String var4, Function<PartitionStatistics, PartitionStatistics> var5);

    public Optional<List<String>> getAllTables(MetastoreContext var1, String var2);

    public Optional<List<String>> getAllViews(MetastoreContext var1, String var2);

    public void createDatabase(MetastoreContext var1, Database var2);

    public void dropDatabase(MetastoreContext var1, String var2);

    public void renameDatabase(MetastoreContext var1, String var2, String var3);

    public MetastoreOperationResult createTable(MetastoreContext var1, Table var2, PrincipalPrivileges var3);

    public void dropTable(MetastoreContext var1, String var2, String var3, boolean var4);

    public MetastoreOperationResult replaceTable(MetastoreContext var1, String var2, String var3, Table var4, PrincipalPrivileges var5);

    public MetastoreOperationResult renameTable(MetastoreContext var1, String var2, String var3, String var4, String var5);

    public MetastoreOperationResult addColumn(MetastoreContext var1, String var2, String var3, String var4, HiveType var5, String var6);

    public MetastoreOperationResult renameColumn(MetastoreContext var1, String var2, String var3, String var4, String var5);

    public MetastoreOperationResult dropColumn(MetastoreContext var1, String var2, String var3, String var4);

    public Optional<Partition> getPartition(MetastoreContext var1, String var2, String var3, List<String> var4);

    public Optional<List<String>> getPartitionNames(MetastoreContext var1, String var2, String var3);

    public List<String> getPartitionNamesByFilter(MetastoreContext var1, String var2, String var3, Map<Column, Domain> var4);

    public List<PartitionNameWithVersion> getPartitionNamesWithVersionByFilter(MetastoreContext var1, String var2, String var3, Map<Column, Domain> var4);

    public Map<String, Optional<Partition>> getPartitionsByNames(MetastoreContext var1, String var2, String var3, List<String> var4);

    public MetastoreOperationResult addPartitions(MetastoreContext var1, String var2, String var3, List<PartitionWithStatistics> var4);

    public void dropPartition(MetastoreContext var1, String var2, String var3, List<String> var4, boolean var5);

    public MetastoreOperationResult alterPartition(MetastoreContext var1, String var2, String var3, PartitionWithStatistics var4);

    public void createRole(MetastoreContext var1, String var2, String var3);

    public void dropRole(MetastoreContext var1, String var2);

    public Set<String> listRoles(MetastoreContext var1);

    public void grantRoles(MetastoreContext var1, Set<String> var2, Set<PrestoPrincipal> var3, boolean var4, PrestoPrincipal var5);

    public void revokeRoles(MetastoreContext var1, Set<String> var2, Set<PrestoPrincipal> var3, boolean var4, PrestoPrincipal var5);

    public Set<RoleGrant> listRoleGrants(MetastoreContext var1, PrestoPrincipal var2);

    public void grantTablePrivileges(MetastoreContext var1, String var2, String var3, PrestoPrincipal var4, Set<HivePrivilegeInfo> var5);

    public void revokeTablePrivileges(MetastoreContext var1, String var2, String var3, PrestoPrincipal var4, Set<HivePrivilegeInfo> var5);

    public Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext var1, String var2, String var3, PrestoPrincipal var4);

    public void setPartitionLeases(MetastoreContext var1, String var2, String var3, Map<String, String> var4, Duration var5);

    default public long lock(MetastoreContext metastoreContext, String databaseName, String tableName) {
        throw new NotSupportedException("Lock is not supported by default");
    }

    default public void unlock(MetastoreContext metastoreContext, long lockId) {
        throw new NotSupportedException("Unlock is not supported by default");
    }
}

