/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.shaded.org.json;

import com.facebook.presto.hive.shaded.org.json.JSONException;
import com.facebook.presto.hive.shaded.org.json.JSONTokener;
import com.facebook.presto.hive.shaded.org.json.XML;
import java.util.HashMap;

public class XMLTokener
extends JSONTokener {
    public static final HashMap entity = new HashMap(8);

    public XMLTokener(String string) {
        super(string);
    }

    public String nextCDATA() throws JSONException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            char c;
            if ((c = this.next()) == '\u0000') {
                throw this.syntaxError("Unclosed CDATA");
            }
            stringBuffer.append(c);
        } while ((n = stringBuffer.length() - 3) < 0 || stringBuffer.charAt(n) != ']' || stringBuffer.charAt(n + 1) != ']' || stringBuffer.charAt(n + 2) != '>');
        stringBuffer.setLength(n);
        return stringBuffer.toString();
    }

    public Object nextContent() throws JSONException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            return XML.LT;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (c == '<' || c == '\u0000') {
                this.back();
                return stringBuffer.toString().trim();
            }
            if (c == '&') {
                stringBuffer.append(this.nextEntity(c));
            } else {
                stringBuffer.append(c);
            }
            c = this.next();
        }
    }

    public Object nextEntity(char c) throws JSONException {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isLetterOrDigit(c2 = this.next()) || c2 == '#') {
            stringBuffer.append(Character.toLowerCase(c2));
        }
        if (c2 != ';') {
            throw this.syntaxError("Missing ';' in XML entity: &" + stringBuffer);
        }
        String string = stringBuffer.toString();
        Object v = entity.get(string);
        return v != null ? v : c + string + ";";
    }

    public Object nextMeta() throws JSONException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag");
            }
            case '<': {
                return XML.LT;
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                do {
                    if ((c = this.next()) != '\u0000') continue;
                    throw this.syntaxError("Unterminated string");
                } while (c != c2);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c = this.next())) {
            switch (c) {
                case '\u0000': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() throws JSONException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'");
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    if ((c = this.next()) == '\u0000') {
                        throw this.syntaxError("Unterminated string");
                    }
                    if (c == c2) {
                        return stringBuffer.toString();
                    }
                    if (c == '&') {
                        stringBuffer.append(this.nextEntity(c));
                        continue;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            stringBuffer.append(c);
            c = this.next();
            if (Character.isWhitespace(c)) {
                return stringBuffer.toString();
            }
            switch (c) {
                case '\u0000': {
                    return stringBuffer.toString();
                }
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': {
                    this.back();
                    return stringBuffer.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.syntaxError("Bad character in a name");
                }
            }
        }
    }

    public boolean skipPast(String string) throws JSONException {
        char c;
        int n;
        int n2 = 0;
        int n3 = string.length();
        char[] cArray = new char[n3];
        for (n = 0; n < n3; ++n) {
            c = this.next();
            if (c == '\u0000') {
                return false;
            }
            cArray[n] = c;
        }
        while (true) {
            int n4 = n2;
            boolean bl = true;
            for (n = 0; n < n3; ++n) {
                if (cArray[n4] != string.charAt(n)) {
                    bl = false;
                    break;
                }
                if (++n4 < n3) continue;
                n4 -= n3;
            }
            if (bl) {
                return true;
            }
            c = this.next();
            if (c == '\u0000') {
                return false;
            }
            cArray[n2] = c;
            if (++n2 < n3) continue;
            n2 -= n3;
        }
    }

    static {
        entity.put("amp", XML.AMP);
        entity.put("apos", XML.APOS);
        entity.put("gt", XML.GT);
        entity.put("lt", XML.LT);
        entity.put("quot", XML.QUOT);
    }
}

