/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.MapJoinMetaData;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractMapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectValue;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.ReflectionUtils;

public class MapJoinOperator
extends AbstractMapJoinOperator<MapJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(MapJoinOperator.class.getName());
    protected transient HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue>[] mapJoinTables;
    protected static MapJoinMetaData metadata = new MapJoinMetaData();
    private static final transient String[] FATAL_ERR_MSG = new String[]{null, "Mapside join exceeds available memory. Please try removing the mapjoin hint."};
    protected transient MapJoinRowContainer<ArrayList<Object>>[] rowContainerMap;
    transient int metadataKeyTag;
    transient int[] metadataValueTag;
    transient boolean hashTblInitedOnce;

    public static MapJoinMetaData getMetadata() {
        return metadata;
    }

    public MapJoinOperator() {
    }

    public MapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.metadataValueTag = new int[this.numAliases];
        for (int pos = 0; pos < this.numAliases; ++pos) {
            this.metadataValueTag[pos] = -1;
        }
        this.metadataKeyTag = -1;
        int tagLen = ((MapJoinDesc)this.conf).getTagLength();
        this.mapJoinTables = new HashMapWrapper[tagLen];
        this.rowContainerMap = new MapJoinRowContainer[tagLen];
        for (int pos = 0; pos < this.numAliases; ++pos) {
            if (pos == this.posBigTable) continue;
            HashMapWrapper hashTable = new HashMapWrapper();
            this.mapJoinTables[pos] = hashTable;
            MapJoinRowContainer rowContainer = new MapJoinRowContainer();
            this.rowContainerMap[pos] = rowContainer;
        }
        this.hashTblInitedOnce = false;
    }

    @Override
    protected void fatalErrorMessage(StringBuilder errMsg, long counterCode) {
        errMsg.append("Operator " + this.getOperatorId() + " (id=" + this.id + "): " + FATAL_ERR_MSG[(int)counterCode]);
    }

    public void generateMapMetaData() throws HiveException, SerDeException {
        TableDesc keyTableDesc = ((MapJoinDesc)this.conf).getKeyTblDesc();
        SerDe keySerializer = (SerDe)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
        keySerializer.initialize(null, keyTableDesc.getProperties());
        metadata.put(this.metadataKeyTag, new HashTableSinkOperator.HashTableSinkObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(keySerializer.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), keySerializer, keyTableDesc, false, this.hconf));
        for (int pos = 0; pos < this.order.length; ++pos) {
            if (pos == this.posBigTable) continue;
            TableDesc valueTableDesc = ((MapJoinDesc)this.conf).getNoOuterJoin() ? ((MapJoinDesc)this.conf).getValueTblDescs().get(pos) : ((MapJoinDesc)this.conf).getValueFilteredTblDescs().get(pos);
            SerDe valueSerDe = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
            valueSerDe.initialize(null, valueTableDesc.getProperties());
            ObjectInspector inspector = valueSerDe.getObjectInspector();
            metadata.put(pos, new HashTableSinkOperator.HashTableSinkObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(inspector, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), valueSerDe, valueTableDesc, this.hasFilter(pos), this.hconf));
        }
    }

    private void loadHashTable() throws HiveException {
        if (!this.getExecContext().getLocalWork().getInputFileChangeSensitive()) {
            if (this.hashTblInitedOnce) {
                return;
            }
            this.hashTblInitedOnce = true;
        }
        String baseDir = null;
        String currentInputFile = this.getExecContext().getCurrentInputFile();
        LOG.info("******* Load from HashTable File: input : " + currentInputFile);
        String fileName = this.getExecContext().getLocalWork().getBucketFileName(currentInputFile);
        try {
            if (ShimLoader.getHadoopShims().isLocalMode(this.hconf)) {
                baseDir = this.getExecContext().getLocalWork().getTmpFileURI();
            } else {
                String stageID = this.getExecContext().getLocalWork().getStageID();
                String suffix = Utilities.generateTarFileName(stageID);
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.hconf);
                Path[] localArchives = DistributedCache.getLocalCacheArchives((Configuration)this.hconf);
                for (int j = 0; j < localArchives.length; ++j) {
                    Path archive = localArchives[j];
                    if (!archive.getName().endsWith(suffix)) continue;
                    Path archiveLocalLink = archive.makeQualified((FileSystem)localFs);
                    baseDir = archiveLocalLink.toUri().getPath();
                }
            }
            for (byte pos = 0; pos < this.mapJoinTables.length; pos = (byte)((byte)(pos + 1))) {
                HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue> hashtable = this.mapJoinTables[pos];
                if (hashtable == null) continue;
                String filePath = Utilities.generatePath(baseDir, ((MapJoinDesc)this.conf).getDumpFilePrefix(), pos, fileName);
                Path path = new Path(filePath);
                LOG.info("\tLoad back 1 hashtable file from tmp file uri:" + path.toString());
                hashtable.initilizePersistentHash(path.toUri().getPath());
            }
        }
        catch (Exception e) {
            LOG.error("Load Distributed Cache Error", e);
            throw new HiveException(e);
        }
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        try {
            if (this.firstRow) {
                this.generateMapMetaData();
                this.firstRow = false;
            }
            this.loadHashTable();
        }
        catch (SerDeException e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            int pos;
            if (this.firstRow) {
                this.generateMapMetaData();
                this.firstRow = false;
            }
            this.alias = (byte)tag;
            if (this.lastAlias == null || !this.lastAlias.equals(this.alias)) {
                this.nextSz = this.joinEmitInterval;
            }
            AbstractMapJoinKey key = JoinUtil.computeMapJoinKeys(row, this.joinKeys[this.alias], this.joinKeysObjectInspectors[this.alias]);
            boolean joinNeeded = false;
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                if (pos == this.alias) continue;
                MapJoinObjectValue o = this.mapJoinTables[pos].get(key);
                MapJoinRowContainer<ArrayList<Object>> rowContainer = this.rowContainerMap[pos];
                if (o == null || key.hasAnyNulls(this.nullsafes)) {
                    if (!this.noOuterJoin) {
                        joinNeeded = true;
                        this.storage[pos] = this.dummyObjVectors[pos];
                        continue;
                    }
                    this.storage[pos] = this.emptyList;
                    continue;
                }
                joinNeeded = true;
                rowContainer.reset(o.getObj());
                this.storage[pos] = rowContainer;
                this.aliasFilterTags[pos] = o.getAliasFilter();
            }
            if (joinNeeded) {
                ArrayList<Object> value = this.getFilteredValue(this.alias, row);
                this.storage[this.alias].add(value);
                this.checkAndGenObject();
            }
            this.storage[tag].clear();
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                if (pos == tag) continue;
                this.storage[pos] = null;
            }
        }
        catch (SerDeException e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.mapJoinTables != null) {
            for (HashMapWrapper<AbstractMapJoinKey, MapJoinObjectValue> hashTable : this.mapJoinTables) {
                if (hashTable == null) continue;
                hashTable.close();
            }
        }
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return MapJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }
}

