/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

final class SerializationUtils {
    private SerializationUtils() {
    }

    static void writeVulong(OutputStream output, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.write((byte)value);
                return;
            }
            output.write((byte)(0x80L | value & 0x7FL));
            value >>>= 7;
        }
    }

    static void writeVslong(OutputStream output, long value) throws IOException {
        SerializationUtils.writeVulong(output, value << 1 ^ value >> 63);
    }

    static long readVulong(InputStream in) throws IOException {
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)in.read()) == -1L) {
                throw new EOFException("Reading Vulong past EOF");
            }
            result |= (0x7FL & b) << offset;
            offset += 7;
        } while (b >= 128L);
        return result;
    }

    static long readVslong(InputStream in) throws IOException {
        long result = SerializationUtils.readVulong(in);
        return result >>> 1 ^ -(result & 1L);
    }

    static float readFloat(InputStream in) throws IOException {
        int ser = in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
        return Float.intBitsToFloat(ser);
    }

    static void writeFloat(OutputStream output, float value) throws IOException {
        int ser = Float.floatToIntBits(value);
        output.write(ser & 0xFF);
        output.write(ser >> 8 & 0xFF);
        output.write(ser >> 16 & 0xFF);
        output.write(ser >> 24 & 0xFF);
    }

    static double readDouble(InputStream in) throws IOException {
        long ser = (long)in.read() | (long)in.read() << 8 | (long)in.read() << 16 | (long)in.read() << 24 | (long)in.read() << 32 | (long)in.read() << 40 | (long)in.read() << 48 | (long)in.read() << 56;
        return Double.longBitsToDouble(ser);
    }

    static void writeDouble(OutputStream output, double value) throws IOException {
        long ser = Double.doubleToLongBits(value);
        output.write((int)ser & 0xFF);
        output.write((int)(ser >> 8) & 0xFF);
        output.write((int)(ser >> 16) & 0xFF);
        output.write((int)(ser >> 24) & 0xFF);
        output.write((int)(ser >> 32) & 0xFF);
        output.write((int)(ser >> 40) & 0xFF);
        output.write((int)(ser >> 48) & 0xFF);
        output.write((int)(ser >> 56) & 0xFF);
    }

    static void writeBigInteger(OutputStream output, BigInteger value) throws IOException {
        int sign = (value = value.shiftLeft(1)).signum();
        if (sign < 0) {
            value = value.negate();
            value = value.subtract(BigInteger.ONE);
        }
        int length = value.bitLength();
        while (true) {
            long lowBits = value.longValue() & Long.MAX_VALUE;
            length -= 63;
            for (int i = 0; i < 9; ++i) {
                if (length <= 0 && (lowBits & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    output.write((byte)lowBits);
                    return;
                }
                output.write((byte)(0x80L | lowBits & 0x7FL));
                lowBits >>>= 7;
            }
            value = value.shiftRight(63);
        }
    }

    static BigInteger readBigInteger(InputStream input) throws IOException {
        boolean isNegative;
        long b;
        BigInteger result = BigInteger.ZERO;
        long work = 0L;
        int offset = 0;
        do {
            if ((b = (long)input.read()) == -1L) {
                throw new EOFException("Reading BigInteger past EOF from " + input);
            }
            work |= (0x7FL & b) << offset % 63;
            if ((offset += 7) == 63) {
                result = BigInteger.valueOf(work);
                work = 0L;
                continue;
            }
            if (offset % 63 != 0) continue;
            result = result.or(BigInteger.valueOf(work).shiftLeft(offset - 63));
            work = 0L;
        } while (b >= 128L);
        if (work != 0L) {
            result = result.or(BigInteger.valueOf(work).shiftLeft(offset / 63 * 63));
        }
        if (isNegative = result.testBit(0)) {
            result = result.add(BigInteger.ONE);
            result = result.negate();
        }
        result = result.shiftRight(1);
        return result;
    }
}

