/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteParseContextGenerator;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteQueryUsingAggregateIndexCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.StringUtils;

public final class RewriteQueryUsingAggregateIndex {
    private static final Log LOG = LogFactory.getLog(RewriteQueryUsingAggregateIndex.class.getName());
    private static RewriteQueryUsingAggregateIndexCtx rewriteQueryCtx = null;

    private RewriteQueryUsingAggregateIndex() {
    }

    public static NewQuerySelectSchemaProc getNewQuerySelectSchemaProc() {
        return new NewQuerySelectSchemaProc();
    }

    public static ReplaceTableScanOpProc getReplaceTableScanProc() {
        return new ReplaceTableScanOpProc();
    }

    public static NewQueryGroupbySchemaProc getNewQueryGroupbySchemaProc() {
        return new NewQueryGroupbySchemaProc();
    }

    private static class NewQueryGroupbySchemaProc
    implements NodeProcessor {
        private NewQueryGroupbySchemaProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator operator = (GroupByOperator)nd;
            rewriteQueryCtx = (RewriteQueryUsingAggregateIndexCtx)ctx;
            if (rewriteQueryCtx.getParseContext().getGroupOpToInputTables().containsKey(operator)) {
                ArrayList<ExprNodeDesc> gbyKeyList = ((GroupByDesc)operator.getConf()).getKeys();
                String gbyKeys = null;
                Iterator gbyKeyListItr = gbyKeyList.iterator();
                while (gbyKeyListItr.hasNext()) {
                    ExprNodeDesc expr = ((ExprNodeDesc)gbyKeyListItr.next()).clone();
                    if (!(expr instanceof ExprNodeColumnDesc)) continue;
                    ExprNodeColumnDesc colExpr = (ExprNodeColumnDesc)expr;
                    gbyKeys = colExpr.getColumn();
                    if (!gbyKeyListItr.hasNext()) continue;
                    gbyKeys = gbyKeys + ",";
                }
                String selReplacementCommand = "select sum(`" + rewriteQueryCtx.getAggregateFunction() + "`)" + " from " + rewriteQueryCtx.getIndexName() + " group by " + gbyKeys + " ";
                ParseContext newDAGContext = RewriteParseContextGenerator.generateOperatorTree(rewriteQueryCtx.getParseContext().getConf(), selReplacementCommand);
                Map<GroupByOperator, Set<String>> newGbyOpMap = newDAGContext.getGroupOpToInputTables();
                GroupByOperator newGbyOperator = newGbyOpMap.keySet().iterator().next();
                GroupByDesc oldConf = (GroupByDesc)operator.getConf();
                ExprNodeColumnDesc aggrExprNode = null;
                GroupByDesc newConf = (GroupByDesc)newGbyOperator.getConf();
                ArrayList<AggregationDesc> newAggrList = newConf.getAggregators();
                if (newAggrList != null && newAggrList.size() > 0) {
                    for (AggregationDesc aggregationDesc : newAggrList) {
                        rewriteQueryCtx.setEval(aggregationDesc.getGenericUDAFEvaluator());
                        aggrExprNode = (ExprNodeColumnDesc)aggregationDesc.getParameters().get(0);
                        rewriteQueryCtx.setAggrExprNode(aggrExprNode);
                    }
                }
                OpParseContext gbyOPC = rewriteQueryCtx.getOpc().get(operator);
                RowResolver gbyRR = newDAGContext.getOpParseCtx().get(newGbyOperator).getRowResolver();
                gbyOPC.setRowResolver(gbyRR);
                rewriteQueryCtx.getOpc().put(operator, gbyOPC);
                oldConf.setAggregators(newAggrList);
                operator.setConf(oldConf);
            } else {
                GroupByDesc childConf = (GroupByDesc)operator.getConf();
                ArrayList<AggregationDesc> childAggrList = childConf.getAggregators();
                if (childAggrList != null && childAggrList.size() > 0) {
                    for (AggregationDesc aggregationDesc : childAggrList) {
                        ArrayList<ExprNodeDesc> paraList = aggregationDesc.getParameters();
                        ArrayList<ObjectInspector> parametersOIList = new ArrayList<ObjectInspector>();
                        for (ExprNodeDesc expr : paraList) {
                            parametersOIList.add(expr.getWritableObjectInspector());
                        }
                        GenericUDAFEvaluator evaluator = FunctionRegistry.getGenericUDAFEvaluator("sum", parametersOIList, false, false);
                        aggregationDesc.setGenericUDAFEvaluator(evaluator);
                        aggregationDesc.setGenericUDAFName("sum");
                    }
                }
            }
            return null;
        }
    }

    private static class ReplaceTableScanOpProc
    implements NodeProcessor {
        private ReplaceTableScanOpProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator scanOperator = (TableScanOperator)nd;
            rewriteQueryCtx = (RewriteQueryUsingAggregateIndexCtx)ctx;
            String baseTableName = rewriteQueryCtx.getBaseTableName();
            String alias = null;
            if (baseTableName.contains(":")) {
                alias = baseTableName.split(":")[0];
            }
            HashMap<TableScanOperator, Table> topToTable = rewriteQueryCtx.getParseContext().getTopToTable();
            HashMap<String, Operator<? extends OperatorDesc>> topOps = rewriteQueryCtx.getParseContext().getTopOps();
            LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseContext = rewriteQueryCtx.getParseContext().getOpParseCtx();
            OpParseContext operatorContext = (OpParseContext)opParseContext.get(scanOperator);
            topToTable.remove(scanOperator);
            topOps.remove(baseTableName);
            opParseContext.remove(scanOperator);
            TableScanDesc indexTableScanDesc = new TableScanDesc();
            indexTableScanDesc.setGatherStats(false);
            String indexTableName = rewriteQueryCtx.getIndexName();
            Table indexTableHandle = null;
            try {
                indexTableHandle = rewriteQueryCtx.getHiveDb().getTable(indexTableName);
            }
            catch (HiveException e) {
                LOG.error("Error while getting the table handle for index table.");
                LOG.error(StringUtils.stringifyException((Throwable)e));
                throw new SemanticException(e.getMessage(), e);
            }
            String k = indexTableName + "/";
            indexTableScanDesc.setStatsAggPrefix(k);
            scanOperator.setConf(indexTableScanDesc);
            RowResolver rr = new RowResolver();
            try {
                StructObjectInspector rowObjectInspector = (StructObjectInspector)indexTableHandle.getDeserializer().getObjectInspector();
                List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    rr.put(indexTableName, fields.get(i).getFieldName(), new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), indexTableName, false));
                }
            }
            catch (SerDeException e) {
                LOG.error("Error while creating the RowResolver for new TableScanOperator.");
                LOG.error(StringUtils.stringifyException((Throwable)e));
                throw new SemanticException(e.getMessage(), e);
            }
            operatorContext.setRowResolver(rr);
            String tabNameWithAlias = null;
            tabNameWithAlias = alias != null ? alias + ":" + indexTableName : indexTableName;
            topToTable.put(scanOperator, indexTableHandle);
            ((TableScanDesc)scanOperator.getConf()).setAlias(tabNameWithAlias);
            scanOperator.setAlias(indexTableName);
            topOps.put(tabNameWithAlias, scanOperator);
            opParseContext.put(scanOperator, operatorContext);
            rewriteQueryCtx.getParseContext().setTopToTable(topToTable);
            rewriteQueryCtx.getParseContext().setTopOps(topOps);
            rewriteQueryCtx.getParseContext().setOpParseCtx(opParseContext);
            return null;
        }
    }

    private static class NewQuerySelectSchemaProc
    implements NodeProcessor {
        private NewQuerySelectSchemaProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator operator = (SelectOperator)nd;
            rewriteQueryCtx = (RewriteQueryUsingAggregateIndexCtx)ctx;
            List<Operator<OperatorDesc>> childOps = operator.getChildOperators();
            Operator<OperatorDesc> childOp = childOps.iterator().next();
            if (childOp instanceof GroupByOperator) {
                List<ExprNodeDesc> selColList = ((SelectDesc)operator.getConf()).getColList();
                selColList.add(rewriteQueryCtx.getAggrExprNode());
                List<String> selOutputColNames = ((SelectDesc)operator.getConf()).getOutputColumnNames();
                selOutputColNames.add(rewriteQueryCtx.getAggrExprNode().getColumn());
                RowSchema selRS = operator.getSchema();
                ArrayList<ColumnInfo> selRSSignature = selRS.getSignature();
                PrimitiveTypeInfo pti = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo("bigint");
                pti.setTypeName("bigint");
                ColumnInfo newCI = new ColumnInfo(rewriteQueryCtx.getAggregateFunction(), pti, "", false);
                selRSSignature.add(newCI);
                selRS.setSignature(selRSSignature);
                operator.setSchema(selRS);
            }
            return null;
        }
    }
}

