/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.shaded.org.apache.thrift.TException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.PrunerUtils;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpProcFactory;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpWalkerCtx;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartExprEvalUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class PartitionPruner
implements Transform {
    private static final Log LOG = LogFactory.getLog("hive.ql.optimizer.ppr.PartitionPruner");

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        OpWalkerCtx opWalkerCtx = new OpWalkerCtx(pctx.getOpToPartPruner());
        PrunerUtils.walkOperatorTree(pctx, opWalkerCtx, OpProcFactory.getFilterProc(), OpProcFactory.getDefaultProc());
        pctx.setHasNonPartCols(opWalkerCtx.getHasNonPartCols());
        return pctx;
    }

    public static boolean onlyContainsPartnCols(Table tab, ExprNodeDesc expr) {
        if (!tab.isPartitioned() || expr == null) {
            return true;
        }
        if (expr instanceof ExprNodeColumnDesc) {
            String colName = ((ExprNodeColumnDesc)expr).getColumn();
            return tab.isPartitionKey(colName);
        }
        if (expr instanceof ExprNodeGenericFuncDesc && !FunctionRegistry.isDeterministic(((ExprNodeGenericFuncDesc)expr).getGenericUDF())) {
            return false;
        }
        List<ExprNodeDesc> children = expr.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (PartitionPruner.onlyContainsPartnCols(tab, children.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static PrunedPartitionList prune(Table tab, ExprNodeDesc prunerExpr, HiveConf conf, String alias, Map<String, PrunedPartitionList> prunedPartitionsMap) throws HiveException {
        PrunedPartitionList ret;
        LOG.trace("Started pruning partiton");
        LOG.trace("dbname = " + tab.getDbName());
        LOG.trace("tabname = " + tab.getTableName());
        LOG.trace("prune Expression = " + prunerExpr);
        String key = tab.getDbName() + "." + tab.getTableName() + ";";
        if (prunerExpr != null) {
            key = key + prunerExpr.getExprString();
        }
        if ((ret = prunedPartitionsMap.get(key)) != null) {
            return ret;
        }
        LinkedHashSet<Partition> true_parts = new LinkedHashSet<Partition>();
        LinkedHashSet<Partition> unkn_parts = new LinkedHashSet<Partition>();
        LinkedHashSet<Partition> denied_parts = new LinkedHashSet<Partition>();
        try {
            StructObjectInspector rowObjectInspector = (StructObjectInspector)tab.getDeserializer().getObjectInspector();
            Object[] rowWithPart = new Object[2];
            if (tab.isPartitioned()) {
                if ("strict".equalsIgnoreCase(HiveConf.getVar(conf, HiveConf.ConfVars.HIVEMAPREDMODE)) && !PartitionPruner.hasColumnExpr(prunerExpr)) {
                    throw new SemanticException(ErrorMsg.NO_PARTITION_PREDICATE.getMsg("for Alias \"" + alias + "\" Table \"" + tab.getTableName() + "\""));
                }
                if (prunerExpr == null) {
                    true_parts.addAll(Hive.get().getPartitions(tab));
                } else {
                    ExprNodeDesc compactExpr = prunerExpr.clone();
                    compactExpr = PartitionPruner.compactExpr(compactExpr);
                    LOG.debug("Filter w/ compacting: " + (compactExpr != null ? compactExpr.getExprString() : "null") + "; filter w/o compacting: " + (prunerExpr != null ? prunerExpr.getExprString() : "null"));
                    if (compactExpr == null) {
                        unkn_parts.addAll(Hive.get().getPartitions(tab));
                    } else {
                        String message = Utilities.checkJDOPushDown(tab, compactExpr);
                        if (message == null) {
                            String oldFilter;
                            String filter = compactExpr.getExprString();
                            if (filter.equals(oldFilter = prunerExpr.getExprString())) {
                                PartitionPruner.pruneByPushDown(tab, true_parts, filter);
                            } else {
                                PartitionPruner.pruneByPushDown(tab, unkn_parts, filter);
                            }
                        } else {
                            LOG.info(ErrorMsg.INVALID_JDO_FILTER_EXPRESSION.getMsg("by condition '" + message + "'"));
                            PartitionPruner.pruneBySequentialScan(tab, true_parts, unkn_parts, denied_parts, prunerExpr, rowObjectInspector);
                        }
                    }
                }
                LOG.debug("tabname = " + tab.getTableName() + " is partitioned");
            } else {
                true_parts.addAll(Hive.get().getPartitions(tab));
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        ret = new PrunedPartitionList(tab, true_parts, unkn_parts, denied_parts);
        prunedPartitionsMap.put(key, ret);
        return ret;
    }

    private static ExprNodeDesc compactExpr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeConstantDesc) {
            if (((ExprNodeConstantDesc)expr).getValue() == null) {
                return null;
            }
            return expr;
        }
        if (expr instanceof ExprNodeGenericFuncDesc) {
            GenericUDF udf = ((ExprNodeGenericFuncDesc)expr).getGenericUDF();
            if (udf instanceof GenericUDFOPAnd || udf instanceof GenericUDFOPOr) {
                List<ExprNodeDesc> children = ((ExprNodeGenericFuncDesc)expr).getChildren();
                ExprNodeDesc left = children.get(0);
                children.set(0, PartitionPruner.compactExpr(left));
                ExprNodeDesc right = children.get(1);
                children.set(1, PartitionPruner.compactExpr(right));
                if (children.get(0) == null && children.get(1) == null) {
                    return null;
                }
                if (children.get(0) == null) {
                    return children.get(1);
                }
                if (children.get(1) == null) {
                    return children.get(0);
                }
            }
            return expr;
        }
        return expr;
    }

    private static void pruneByPushDown(Table tab, Set<Partition> true_parts, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        Hive db = Hive.get();
        List<Partition> parts = db.getPartitionsByFilter(tab, filter);
        true_parts.addAll(parts);
    }

    private static void pruneBySequentialScan(Table tab, Set<Partition> true_parts, Set<Partition> unkn_parts, Set<Partition> denied_parts, ExprNodeDesc prunerExpr, StructObjectInspector rowObjectInspector) throws Exception {
        List<Partition> parts;
        LinkedList<String> trueNames = null;
        LinkedList<String> unknNames = null;
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(LOG, "prune-listing");
        List<String> partNames = Hive.get().getPartitionNames(tab.getDbName(), tab.getTableName(), (short)-1);
        List<FieldSchema> pCols = tab.getPartCols();
        ArrayList<String> partCols = new ArrayList<String>(pCols.size());
        ArrayList<String> values = new ArrayList<String>(pCols.size());
        Object[] objectWithPart = new Object[2];
        for (FieldSchema pCol : pCols) {
            partCols.add(pCol.getName());
        }
        Map<PrimitiveObjectInspector, ExprNodeEvaluator> handle = PartExprEvalUtils.prepareExpr(prunerExpr, partCols, rowObjectInspector);
        for (String partName : partNames) {
            LinkedHashMap<String, String> partSpec = Warehouse.makeSpecFromName(partName);
            values.clear();
            for (Map.Entry<String, String> kv : partSpec.entrySet()) {
                values.add(kv.getValue());
            }
            objectWithPart[1] = values;
            Boolean r = (Boolean)PartExprEvalUtils.evaluateExprOnPart(handle, objectWithPart);
            if (r == null) {
                if (unknNames == null) {
                    unknNames = new LinkedList<String>();
                }
                unknNames.add(partName);
                LOG.debug("retained unknown partition: " + partName);
                continue;
            }
            if (!Boolean.TRUE.equals(r)) continue;
            if (trueNames == null) {
                trueNames = new LinkedList<String>();
            }
            trueNames.add(partName);
            LOG.debug("retained partition: " + partName);
        }
        perfLogger.PerfLogEnd(LOG, "prune-listing");
        perfLogger.PerfLogBegin(LOG, "partition-retrieving");
        if (trueNames != null) {
            parts = Hive.get().getPartitionsByNames(tab, trueNames);
            true_parts.addAll(parts);
        }
        if (unknNames != null) {
            parts = Hive.get().getPartitionsByNames(tab, unknNames);
            unkn_parts.addAll(parts);
        }
        perfLogger.PerfLogEnd(LOG, "partition-retrieving");
    }

    public static boolean hasColumnExpr(ExprNodeDesc desc) {
        if (desc == null) {
            return false;
        }
        if (desc instanceof ExprNodeColumnDesc) {
            return true;
        }
        List<ExprNodeDesc> children = desc.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (!PartitionPruner.hasColumnExpr(children.get(i))) continue;
                return true;
            }
        }
        return false;
    }
}

