/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@Explain(displayName="Map Reduce Local Work")
public class MapredLocalWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork;
    private LinkedHashMap<String, FetchWork> aliasToFetchWork;
    private boolean inputFileChangeSensitive;
    private BucketMapJoinContext bucketMapjoinContext;
    private String tmpFileURI;
    private String stageID;
    private List<Operator<? extends OperatorDesc>> dummyParentOp;

    public MapredLocalWork() {
    }

    public MapredLocalWork(LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork, LinkedHashMap<String, FetchWork> aliasToFetchWork) {
        this.aliasToWork = aliasToWork;
        this.aliasToFetchWork = aliasToFetchWork;
    }

    public MapredLocalWork(MapredLocalWork clone) {
        this.tmpFileURI = clone.tmpFileURI;
        this.inputFileChangeSensitive = clone.inputFileChangeSensitive;
    }

    public void setDummyParentOp(List<Operator<? extends OperatorDesc>> op) {
        this.dummyParentOp = op;
    }

    public List<Operator<? extends OperatorDesc>> getDummyParentOp() {
        return this.dummyParentOp;
    }

    @Explain(displayName="Alias -> Map Local Operator Tree")
    public LinkedHashMap<String, Operator<? extends OperatorDesc>> getAliasToWork() {
        return this.aliasToWork;
    }

    public String getStageID() {
        return this.stageID;
    }

    public void setStageID(String stageID) {
        this.stageID = stageID;
    }

    public void setAliasToWork(LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork) {
        this.aliasToWork = aliasToWork;
    }

    @Explain(displayName="Alias -> Map Local Tables")
    public LinkedHashMap<String, FetchWork> getAliasToFetchWork() {
        return this.aliasToFetchWork;
    }

    public void setAliasToFetchWork(LinkedHashMap<String, FetchWork> aliasToFetchWork) {
        this.aliasToFetchWork = aliasToFetchWork;
    }

    public boolean getInputFileChangeSensitive() {
        return this.inputFileChangeSensitive;
    }

    public void setInputFileChangeSensitive(boolean inputFileChangeSensitive) {
        this.inputFileChangeSensitive = inputFileChangeSensitive;
    }

    public void deriveExplainAttributes() {
        if (this.bucketMapjoinContext != null) {
            this.bucketMapjoinContext.deriveBucketMapJoinMapping();
        }
        for (FetchWork fetchWork : this.aliasToFetchWork.values()) {
            PlanUtils.configureInputJobPropertiesForStorageHandler(fetchWork.getTblDesc());
        }
    }

    @Explain(displayName="Bucket Mapjoin Context", normalExplain=false)
    public BucketMapJoinContext getBucketMapjoinContextExplain() {
        return this.bucketMapjoinContext != null && this.bucketMapjoinContext.getBucketFileNameMapping() != null ? this.bucketMapjoinContext : null;
    }

    public BucketMapJoinContext getBucketMapjoinContext() {
        return this.bucketMapjoinContext;
    }

    public void setBucketMapjoinContext(BucketMapJoinContext bucketMapjoinContext) {
        this.bucketMapjoinContext = bucketMapjoinContext;
    }

    public BucketMapJoinContext copyPartSpecMappingOnly() {
        if (this.bucketMapjoinContext != null && this.bucketMapjoinContext.getBigTablePartSpecToFileMapping() != null) {
            BucketMapJoinContext context = new BucketMapJoinContext();
            context.setBigTablePartSpecToFileMapping(this.bucketMapjoinContext.getBigTablePartSpecToFileMapping());
            return context;
        }
        return null;
    }

    public void setTmpFileURI(String tmpFileURI) {
        this.tmpFileURI = tmpFileURI;
    }

    public String getTmpFileURI() {
        return this.tmpFileURI;
    }

    public String getBucketFileName(String bigFileName) {
        if (!this.inputFileChangeSensitive || bigFileName == null || bigFileName.isEmpty()) {
            return "-";
        }
        String fileName = this.getFileName(bigFileName);
        if (this.bucketMapjoinContext != null) {
            fileName = this.bucketMapjoinContext.createFileName(bigFileName, fileName);
        }
        return fileName;
    }

    private String getFileName(String path) {
        int last_separator = path.lastIndexOf("/");
        if (last_separator < 0) {
            return path;
        }
        return path.substring(last_separator + 1);
    }
}

