/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.xml;

import com.facebook.presto.hive.shaded.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathUtil;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.w3c.dom.NodeList;

@Description(name="xpath", value="_FUNC_(xml, xpath) - Returns a string array of values within xml nodes that match the xpath expression", extended="Example:\n  > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>', 'a/text()') FROM src LIMIT 1\n  []\n  > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>', 'a/b/text()') FROM src LIMIT 1\n  [\"b1\",\"b2\",\"b3\"]\n  > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>', 'a/c/text()') FROM src LIMIT 1\n  [\"c1\",\"c2\"]")
public class GenericUDFXPath
extends GenericUDF {
    private static final List<Text> emptyResult = Collections.emptyList();
    private final UDFXPathUtil xpath = new UDFXPathUtil();
    private final List<Text> result = new ArrayList<Text>(10);
    private ObjectInspectorConverters.Converter converterArg0;
    private ObjectInspectorConverters.Converter converterArg1;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentException("Invalid number of arguments.");
        }
        this.converterArg0 = ObjectInspectorConverters.getConverter(arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        this.converterArg1 = ObjectInspectorConverters.getConverter(arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
    }

    private List<Text> eval(String xml, String path) {
        NodeList nodeList = this.xpath.evalNodeList(xml, path);
        if (nodeList == null) {
            return emptyResult;
        }
        this.result.clear();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String value = nodeList.item(i).getNodeValue();
            if (value == null) continue;
            this.result.add(new Text(value));
        }
        return this.result;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 2);
        String xml = this.converterArg0.convert(arguments[0].get()).toString();
        String path = this.converterArg1.convert(arguments[1].get()).toString();
        return this.eval(xml, path);
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder builder = new StringBuilder();
        builder.append("array (");
        if (children.length > 0) {
            builder.append("'");
            builder.append(StringUtils.join((Object[])children, "','"));
            builder.append("'");
        }
        builder.append(")");
        return builder.toString();
    }
}

