/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.InstanceCache;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Writable;

class AvroSerializer {
    private static final Log LOG = LogFactory.getLog(AvroSerializer.class);
    private static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    AvroGenericRecordWritable cache = new AvroGenericRecordWritable();
    final InstanceCache<Schema, InstanceCache<Object, GenericEnumSymbol>> enums = new InstanceCache<Schema, InstanceCache<Object, GenericEnumSymbol>>(){

        @Override
        protected InstanceCache<Object, GenericEnumSymbol> makeInstance(final Schema schema) {
            return new InstanceCache<Object, GenericEnumSymbol>(){

                @Override
                protected GenericEnumSymbol makeInstance(Object seed) {
                    return new GenericData.EnumSymbol(schema, seed.toString());
                }
            };
        }
    };

    AvroSerializer() {
    }

    public Writable serialize(Object o, ObjectInspector objectInspector, List<String> columnNames, List<TypeInfo> columnTypes, Schema schema) throws AvroSerdeException {
        StructObjectInspector soi = (StructObjectInspector)objectInspector;
        GenericData.Record record = new GenericData.Record(schema);
        List<? extends StructField> outputFieldRefs = soi.getAllStructFieldRefs();
        if (outputFieldRefs.size() != columnNames.size()) {
            throw new AvroSerdeException("Number of input columns was different than output columns (in = " + columnNames.size() + " vs out = " + outputFieldRefs.size());
        }
        int size = schema.getFields().size();
        if (outputFieldRefs.size() != size) {
            throw new AvroSerdeException("Hive passed in a different number of fields than the schema expected: (Hive wanted " + outputFieldRefs.size() + ", Avro expected " + schema.getFields().size());
        }
        List<? extends StructField> allStructFieldRefs = soi.getAllStructFieldRefs();
        List<Object> structFieldsDataAsList = soi.getStructFieldsDataAsList(o);
        for (int i = 0; i < size; ++i) {
            Schema.Field field = (Schema.Field)schema.getFields().get(i);
            TypeInfo typeInfo = columnTypes.get(i);
            StructField structFieldRef = allStructFieldRefs.get(i);
            Object structFieldData = structFieldsDataAsList.get(i);
            ObjectInspector fieldOI = structFieldRef.getFieldObjectInspector();
            Object val = this.serialize(typeInfo, fieldOI, structFieldData, field.schema());
            record.put(field.name(), val);
        }
        if (!GenericData.get().validate(schema, (Object)record)) {
            throw new SerializeToAvroException(schema, record);
        }
        this.cache.setRecord((GenericRecord)record);
        return this.cache;
    }

    private Object serialize(TypeInfo typeInfo, ObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        if (null == structFieldData) {
            return null;
        }
        if (AvroSerdeUtils.isNullableType(schema)) {
            schema = AvroSerdeUtils.getOtherTypeFromNullableType(schema);
        }
        if (Schema.Type.ENUM.equals((Object)schema.getType())) {
            assert (fieldOI instanceof PrimitiveObjectInspector);
            return this.serializeEnum(typeInfo, (PrimitiveObjectInspector)fieldOI, structFieldData, schema);
        }
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                assert (fieldOI instanceof PrimitiveObjectInspector);
                return this.serializePrimitive(typeInfo, (PrimitiveObjectInspector)fieldOI, structFieldData);
            }
            case MAP: {
                assert (fieldOI instanceof MapObjectInspector);
                assert (typeInfo instanceof MapTypeInfo);
                return this.serializeMap((MapTypeInfo)typeInfo, (MapObjectInspector)fieldOI, structFieldData, schema);
            }
            case LIST: {
                assert (fieldOI instanceof ListObjectInspector);
                assert (typeInfo instanceof ListTypeInfo);
                return this.serializeList((ListTypeInfo)typeInfo, (ListObjectInspector)fieldOI, structFieldData, schema);
            }
            case UNION: {
                assert (fieldOI instanceof UnionObjectInspector);
                assert (typeInfo instanceof UnionTypeInfo);
                return this.serializeUnion((UnionTypeInfo)typeInfo, (UnionObjectInspector)fieldOI, structFieldData, schema);
            }
            case STRUCT: {
                assert (fieldOI instanceof StructObjectInspector);
                assert (typeInfo instanceof StructTypeInfo);
                return this.serializeStruct((StructTypeInfo)typeInfo, (StructObjectInspector)fieldOI, structFieldData, schema);
            }
        }
        throw new AvroSerdeException("Ran out of TypeInfo Categories: " + (Object)((Object)typeInfo.getCategory()));
    }

    private Object serializeEnum(TypeInfo typeInfo, PrimitiveObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        return this.enums.retrieve(schema).retrieve(this.serializePrimitive(typeInfo, fieldOI, structFieldData));
    }

    private Object serializeStruct(StructTypeInfo typeInfo, StructObjectInspector ssoi, Object o, Schema schema) throws AvroSerdeException {
        int size = schema.getFields().size();
        List<? extends StructField> allStructFieldRefs = ssoi.getAllStructFieldRefs();
        List<Object> structFieldsDataAsList = ssoi.getStructFieldsDataAsList(o);
        GenericData.Record record = new GenericData.Record(schema);
        ArrayList<TypeInfo> allStructFieldTypeInfos = typeInfo.getAllStructFieldTypeInfos();
        for (int i = 0; i < size; ++i) {
            Schema.Field field = (Schema.Field)schema.getFields().get(i);
            TypeInfo colTypeInfo = allStructFieldTypeInfos.get(i);
            StructField structFieldRef = allStructFieldRefs.get(i);
            Object structFieldData = structFieldsDataAsList.get(i);
            ObjectInspector fieldOI = structFieldRef.getFieldObjectInspector();
            Object val = this.serialize(colTypeInfo, fieldOI, structFieldData, field.schema());
            record.put(field.name(), val);
        }
        return record;
    }

    private Object serializePrimitive(TypeInfo typeInfo, PrimitiveObjectInspector fieldOI, Object structFieldData) throws AvroSerdeException {
        switch (fieldOI.getPrimitiveCategory()) {
            case UNKNOWN: {
                throw new AvroSerdeException("Received UNKNOWN primitive category.");
            }
            case VOID: {
                return null;
            }
        }
        return fieldOI.getPrimitiveJavaObject(structFieldData);
    }

    private Object serializeUnion(UnionTypeInfo typeInfo, UnionObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        byte tag = fieldOI.getTag(structFieldData);
        return this.serialize(typeInfo.getAllUnionObjectTypeInfos().get(tag), fieldOI.getObjectInspectors().get(tag), fieldOI.getField(structFieldData), (Schema)schema.getTypes().get(tag));
    }

    private boolean isTransformedType(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.FIXED) || schema.getType().equals((Object)Schema.Type.BYTES);
    }

    private Object serializeTransformedType(ListTypeInfo typeInfo, ListObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Beginning to transform " + typeInfo + " with Avro schema " + schema.toString(false));
        }
        if (schema.getType().equals((Object)Schema.Type.FIXED)) {
            return this.serializedAvroFixed(typeInfo, fieldOI, structFieldData, schema);
        }
        return this.serializeAvroBytes(typeInfo, fieldOI, structFieldData, schema);
    }

    private Object serializeAvroBytes(ListTypeInfo typeInfo, ListObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        ByteBuffer bb = ByteBuffer.wrap(this.extraByteArray(fieldOI, structFieldData));
        return bb.rewind();
    }

    private Object serializedAvroFixed(ListTypeInfo typeInfo, ListObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        return new GenericData.Fixed(schema, this.extraByteArray(fieldOI, structFieldData));
    }

    private byte[] extraByteArray(ListObjectInspector fieldOI, Object structFieldData) throws AvroSerdeException {
        int listLength = fieldOI.getListLength(structFieldData);
        byte[] bytes = new byte[listLength];
        assert (fieldOI.getListElementObjectInspector() instanceof PrimitiveObjectInspector);
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)fieldOI.getListElementObjectInspector();
        List<?> list = fieldOI.getList(structFieldData);
        for (int i = 0; i < listLength; ++i) {
            Object b = poi.getPrimitiveJavaObject(list.get(i));
            if (!(b instanceof Byte)) {
                throw new AvroSerdeException("Attempting to transform to bytes, element was not byte but " + b.getClass().getCanonicalName());
            }
            bytes[i] = (Byte)b;
        }
        return bytes;
    }

    private Object serializeList(ListTypeInfo typeInfo, ListObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        if (this.isTransformedType(schema)) {
            return this.serializeTransformedType(typeInfo, fieldOI, structFieldData, schema);
        }
        List<?> list = fieldOI.getList(structFieldData);
        ArrayList<Object> deserialized = new ArrayList<Object>(list.size());
        TypeInfo listElementTypeInfo = typeInfo.getListElementTypeInfo();
        ObjectInspector listElementObjectInspector = fieldOI.getListElementObjectInspector();
        Schema elementType = schema.getElementType();
        for (int i = 0; i < list.size(); ++i) {
            deserialized.add(i, this.serialize(listElementTypeInfo, listElementObjectInspector, list.get(i), elementType));
        }
        return deserialized;
    }

    private Object serializeMap(MapTypeInfo typeInfo, MapObjectInspector fieldOI, Object structFieldData, Schema schema) throws AvroSerdeException {
        if (!this.mapHasStringKey(fieldOI.getMapKeyObjectInspector())) {
            throw new AvroSerdeException("Avro only supports maps with keys as Strings.  Current Map is: " + typeInfo.toString());
        }
        ObjectInspector mapKeyObjectInspector = fieldOI.getMapKeyObjectInspector();
        ObjectInspector mapValueObjectInspector = fieldOI.getMapValueObjectInspector();
        TypeInfo mapKeyTypeInfo = typeInfo.getMapKeyTypeInfo();
        TypeInfo mapValueTypeInfo = typeInfo.getMapValueTypeInfo();
        Map<?, ?> map = fieldOI.getMap(structFieldData);
        Schema valueType = schema.getValueType();
        HashMap<Object, Object> deserialized = new HashMap<Object, Object>(fieldOI.getMapSize(structFieldData));
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            deserialized.put(this.serialize(mapKeyTypeInfo, mapKeyObjectInspector, entry.getKey(), STRING_SCHEMA), this.serialize(mapValueTypeInfo, mapValueObjectInspector, entry.getValue(), valueType));
        }
        return deserialized;
    }

    private boolean mapHasStringKey(ObjectInspector mapKeyObjectInspector) {
        return mapKeyObjectInspector instanceof PrimitiveObjectInspector && ((PrimitiveObjectInspector)mapKeyObjectInspector).getPrimitiveCategory().equals((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    }

    public static class SerializeToAvroException
    extends AvroSerdeException {
        private final Schema schema;
        private final GenericData.Record record;

        public SerializeToAvroException(Schema schema, GenericData.Record record) {
            this.schema = schema;
            this.record = record;
        }

        @Override
        public String toString() {
            return "Avro could not validate record against schema (record = " + this.record + ") (schema = " + this.schema.toString(false) + ")";
        }
    }
}

