/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListHealthChecksRequest;
import com.amazonaws.transform.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHealthChecksRequestMarshaller
implements Marshaller<Request<ListHealthChecksRequest>, ListHealthChecksRequest> {
    @Override
    public Request<ListHealthChecksRequest> marshall(ListHealthChecksRequest listHealthChecksRequest) {
        if (listHealthChecksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListHealthChecksRequest> request = new DefaultRequest<ListHealthChecksRequest>(listHealthChecksRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2012-12-12/healthcheck?marker={Marker}&maxitems={MaxItems}";
        uriResourcePath = uriResourcePath.replace("{Marker}", this.getString(listHealthChecksRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{MaxItems}", this.getString(listHealthChecksRequest.getMaxItems()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

