/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.execution.Failure;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import javax.annotation.Nullable;

public final class ErrorCodes {
    private ErrorCodes() {
    }

    @Nullable
    public static ErrorCode toErrorCode(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof PrestoException) {
            return ((PrestoException)throwable).getErrorCode();
        }
        if (throwable instanceof Failure && ((Failure)throwable).getErrorCode() != null) {
            return ((Failure)throwable).getErrorCode();
        }
        if (throwable instanceof ParsingException || throwable instanceof SemanticException) {
            return StandardErrorCode.SYNTAX_ERROR.toErrorCode();
        }
        if (throwable.getCause() != null) {
            return ErrorCodes.toErrorCode(throwable.getCause());
        }
        return StandardErrorCode.INTERNAL.toErrorCode();
    }
}

