/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.tuple.TupleInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;

public final class HashPagePartitionFunction
implements PagePartitionFunction {
    private final int partition;
    private final int partitionCount;
    private final List<Integer> partitioningChannels;

    @JsonCreator
    public HashPagePartitionFunction(@JsonProperty(value="partition") int partition, @JsonProperty(value="partitionCount") int partitionCount, @JsonProperty(value="partitioningChannels") List<Integer> partitioningChannels) {
        this.partition = partition;
        this.partitionCount = partitionCount;
        this.partitioningChannels = ImmutableList.copyOf(partitioningChannels);
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @JsonProperty
    public List<Integer> getPartitioningChannels() {
        return this.partitioningChannels;
    }

    @Override
    public List<Page> partition(List<Page> pages) {
        if (pages.isEmpty()) {
            return pages;
        }
        List<TupleInfo> tupleInfos = HashPagePartitionFunction.getTupleInfos(pages);
        PageBuilder pageBuilder = new PageBuilder(tupleInfos);
        ImmutableList.Builder partitionedPages = ImmutableList.builder();
        for (Page page : pages) {
            BlockCursor[] cursors = new BlockCursor[tupleInfos.size()];
            for (int i = 0; i < cursors.length; ++i) {
                cursors[i] = page.getBlock(i).cursor();
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                for (BlockCursor cursor : cursors) {
                    cursor.advanceNextPosition();
                }
                int partitionHashBucket = this.getPartitionHashBucket(tupleInfos, cursors);
                if (partitionHashBucket != this.partition) continue;
                for (int channel = 0; channel < cursors.length; ++channel) {
                    pageBuilder.getBlockBuilder(channel).append(cursors[channel]);
                }
                if (!pageBuilder.isFull()) continue;
                partitionedPages.add((Object)pageBuilder.build());
                pageBuilder.reset();
            }
        }
        if (!pageBuilder.isEmpty()) {
            partitionedPages.add((Object)pageBuilder.build());
        }
        return partitionedPages.build();
    }

    private int getPartitionHashBucket(List<TupleInfo> tupleInfos, BlockCursor[] cursors) {
        long hashCode = 1L;
        for (int channel : this.partitioningChannels) {
            hashCode *= 31L;
            hashCode += (long)HashPagePartitionFunction.calculateHashCode(tupleInfos.get(channel), cursors[channel]);
        }
        int bucket = (int)((hashCode &= Long.MAX_VALUE) % (long)this.partitionCount);
        Preconditions.checkState((bucket >= 0 && bucket < this.partitionCount ? 1 : 0) != 0);
        return bucket;
    }

    private static int calculateHashCode(TupleInfo tupleInfo, BlockCursor cursor) {
        Slice slice = cursor.getRawSlice();
        int offset = cursor.getRawOffset();
        int length = tupleInfo.size(slice, offset);
        return slice.hashCode(offset, length);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partition, this.partitionCount, this.partitioningChannels});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashPagePartitionFunction other = (HashPagePartitionFunction)obj;
        return Objects.equal((Object)this.partition, (Object)other.partition) && Objects.equal((Object)this.partitionCount, (Object)other.partitionCount) && Objects.equal(this.partitioningChannels, other.partitioningChannels);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("partition", this.partition).add("partitionCount", this.partitionCount).add("partitioningChannels", this.partitioningChannels).toString();
    }

    private static List<TupleInfo> getTupleInfos(List<Page> pages) {
        Page firstPage = pages.get(0);
        ArrayList<TupleInfo> tupleInfos = new ArrayList<TupleInfo>();
        for (Block block : firstPage.getBlocks()) {
            tupleInfos.add(block.getTupleInfo());
        }
        return tupleInfos;
    }
}

