/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.dictionary;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Dictionary {
    private final TupleInfo tupleInfo;
    private final List<Slice> dictionary;

    public Dictionary(TupleInfo tupleInfo, Slice ... dictionary) {
        this(tupleInfo, (Iterable<Slice>)ImmutableList.copyOf((Object[])dictionary));
    }

    public Dictionary(TupleInfo tupleInfo, Iterable<Slice> dictionary) {
        Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
        Preconditions.checkNotNull(dictionary, (Object)"dictionary is null");
        this.tupleInfo = tupleInfo;
        this.dictionary = ImmutableList.copyOf(dictionary);
    }

    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    public int size() {
        return this.dictionary.size();
    }

    public Tuple getTuple(int dictionaryKey) {
        return new Tuple(this.getTupleSlice(dictionaryKey), this.tupleInfo);
    }

    public boolean getBoolean(int dictionaryKey) {
        return this.tupleInfo.getBoolean(this.getTupleSlice(dictionaryKey));
    }

    public long getLong(int dictionaryKey) {
        return this.tupleInfo.getLong(this.getTupleSlice(dictionaryKey));
    }

    public double getDouble(int dictionaryKey) {
        return this.tupleInfo.getDouble(this.getTupleSlice(dictionaryKey));
    }

    public Slice getSlice(int dictionaryKey) {
        return this.tupleInfo.getSlice(this.getTupleSlice(dictionaryKey));
    }

    public boolean isNull(int dictionaryKey) {
        return this.tupleInfo.isNull(this.getTupleSlice(dictionaryKey));
    }

    public boolean tupleEquals(int dictionaryKey, Tuple value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return this.tupleInfo.equals(value.getTupleInfo()) && this.getTupleSlice(dictionaryKey).equals((Object)value.getTupleSlice());
    }

    public Slice getTupleSlice(int dictionaryKey) {
        return this.dictionary.get(dictionaryKey);
    }

    public void appendTupleTo(int dictionaryKey, BlockBuilder blockBuilder) {
        Slice slice = this.dictionary.get(dictionaryKey);
        blockBuilder.appendTuple(slice, 0, slice.length());
    }

    public static class DictionaryBuilder {
        private final TupleInfo tupleInfo;
        private final Map<Slice, Integer> dictionary = new HashMap<Slice, Integer>();
        private int nextId = 0;

        public DictionaryBuilder(TupleInfo tupleInfo) {
            this.tupleInfo = tupleInfo;
        }

        public long getId(Tuple tuple) {
            Preconditions.checkNotNull((Object)tuple, (Object)"tuple is null");
            Integer id = this.dictionary.get(tuple.getTupleSlice());
            if (id == null) {
                id = this.nextId;
                ++this.nextId;
                this.dictionary.put(tuple.getTupleSlice(), id);
            }
            return id.intValue();
        }

        public Dictionary build() {
            Slice[] dictionary = new Slice[this.dictionary.size()];
            for (Map.Entry<Slice, Integer> entry : this.dictionary.entrySet()) {
                dictionary[entry.getValue().intValue()] = entry.getKey();
            }
            return new Dictionary(this.tupleInfo, dictionary);
        }
    }
}

