/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.dictionary;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.dictionary.Dictionary;
import com.facebook.presto.block.dictionary.DictionaryEncodedBlock;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;

public class DictionaryEncodedBlockCursor
implements BlockCursor {
    private final Dictionary dictionary;
    private final BlockCursor sourceCursor;

    public DictionaryEncodedBlockCursor(Dictionary dictionary, BlockCursor sourceCursor) {
        Preconditions.checkNotNull((Object)dictionary, (Object)"dictionary is null");
        Preconditions.checkNotNull((Object)sourceCursor, (Object)"sourceCursor is null");
        this.dictionary = dictionary;
        this.sourceCursor = sourceCursor;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.dictionary.getTupleInfo();
    }

    @Override
    public int getRemainingPositions() {
        return this.sourceCursor.getRemainingPositions();
    }

    @Override
    public boolean isValid() {
        return this.sourceCursor.isValid();
    }

    @Override
    public boolean isFinished() {
        return this.sourceCursor.isFinished();
    }

    @Override
    public boolean advanceNextPosition() {
        return this.sourceCursor.advanceNextPosition();
    }

    @Override
    public boolean advanceToPosition(int position) {
        return this.sourceCursor.advanceToPosition(position);
    }

    @Override
    public Block getRegionAndAdvance(int length) {
        return new DictionaryEncodedBlock(this.dictionary, this.sourceCursor.getRegionAndAdvance(length));
    }

    @Override
    public Tuple getTuple() {
        return this.dictionary.getTuple(this.getDictionaryKey());
    }

    @Override
    public boolean getBoolean() {
        return this.dictionary.getBoolean(this.getDictionaryKey());
    }

    @Override
    public long getLong() {
        return this.dictionary.getLong(this.getDictionaryKey());
    }

    @Override
    public double getDouble() {
        return this.dictionary.getDouble(this.getDictionaryKey());
    }

    @Override
    public Slice getSlice() {
        return this.dictionary.getSlice(this.getDictionaryKey());
    }

    @Override
    public boolean isNull() {
        return this.dictionary.isNull(this.getDictionaryKey());
    }

    @Override
    public int getPosition() {
        return this.sourceCursor.getPosition();
    }

    @Override
    public boolean currentTupleEquals(Tuple value) {
        return this.dictionary.tupleEquals(this.getDictionaryKey(), value);
    }

    @Override
    public int getRawOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getRawSlice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendTupleTo(BlockBuilder blockBuilder) {
        this.dictionary.appendTupleTo(this.getDictionaryKey(), blockBuilder);
    }

    public int getDictionaryKey() {
        int dictionaryKey = Ints.checkedCast((long)this.sourceCursor.getLong());
        Preconditions.checkPositionIndex((int)dictionaryKey, (int)this.dictionary.size(), (String)"dictionaryKey does not exist");
        return dictionaryKey;
    }
}

