/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.rle;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.RandomAccessBlock;
import com.facebook.presto.block.rle.RunLengthEncodedBlockCursor;
import com.facebook.presto.serde.RunLengthBlockEncoding;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;

public class RunLengthEncodedBlock
implements RandomAccessBlock {
    private final Tuple value;
    private final int positionCount;

    public RunLengthEncodedBlock(Tuple value, int positionCount) {
        this.value = value;
        this.positionCount = positionCount;
    }

    public Tuple getValue() {
        return this.value;
    }

    public Tuple getSingleValue() {
        return this.value;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public DataSize getDataSize() {
        return new DataSize((double)this.value.getTupleSlice().length(), DataSize.Unit.BYTE);
    }

    @Override
    public RunLengthBlockEncoding getEncoding() {
        return new RunLengthBlockEncoding(this.value.getTupleInfo());
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        Preconditions.checkPositionIndexes((int)positionOffset, (int)(positionOffset + length), (int)this.positionCount);
        return new RunLengthEncodedBlock(this.value, length);
    }

    @Override
    public RandomAccessBlock toRandomAccessBlock() {
        return this;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.value.getTupleInfo();
    }

    @Override
    public boolean getBoolean(int position) {
        this.checkReadablePosition(position);
        return this.value.getBoolean();
    }

    @Override
    public long getLong(int position) {
        return this.value.getLong();
    }

    @Override
    public double getDouble(int position) {
        return this.value.getDouble();
    }

    @Override
    public Slice getSlice(int position) {
        return this.value.getSlice();
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.value.isNull();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("value", (Object)this.value).add("positionCount", this.positionCount).toString();
    }

    @Override
    public RunLengthEncodedBlockCursor cursor() {
        return new RunLengthEncodedBlockCursor(this.value, this.positionCount);
    }

    private void checkReadablePosition(int position) {
        Preconditions.checkState((position > 0 && position < this.positionCount ? 1 : 0) != 0, (Object)"position is not valid");
    }
}

