/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.uncompressed;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.RandomAccessBlock;
import com.facebook.presto.block.uncompressed.UncompressedBooleanBlock;
import com.facebook.presto.block.uncompressed.UncompressedBooleanBlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedDoubleBlock;
import com.facebook.presto.block.uncompressed.UncompressedDoubleBlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedLongBlock;
import com.facebook.presto.block.uncompressed.UncompressedLongBlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedSliceBlock;
import com.facebook.presto.block.uncompressed.UncompressedSliceBlockCursor;
import com.facebook.presto.serde.UncompressedBlockEncoding;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;

public class UncompressedBlock
implements Block {
    private final int positionCount;
    private final TupleInfo tupleInfo;
    private final Slice slice;

    public UncompressedBlock(int positionCount, TupleInfo tupleInfo, Slice slice) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        Preconditions.checkNotNull((Object)tupleInfo, (Object)"tupleInfo is null");
        Preconditions.checkNotNull((Object)slice, (Object)"data is null");
        this.tupleInfo = tupleInfo;
        this.slice = slice;
        this.positionCount = positionCount;
    }

    public UncompressedBlock(UncompressedBlock block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        this.positionCount = block.positionCount;
        this.tupleInfo = block.tupleInfo;
        this.slice = block.slice;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public int getSliceOffset() {
        return 0;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public DataSize getDataSize() {
        return new DataSize((double)this.slice.length(), DataSize.Unit.BYTE);
    }

    @Override
    public BlockCursor cursor() {
        TupleInfo.Type type = this.tupleInfo.getType();
        if (type == TupleInfo.Type.BOOLEAN) {
            return new UncompressedBooleanBlockCursor(this.positionCount, this.slice);
        }
        if (type == TupleInfo.Type.FIXED_INT_64) {
            return new UncompressedLongBlockCursor(this.positionCount, this.slice);
        }
        if (type == TupleInfo.Type.DOUBLE) {
            return new UncompressedDoubleBlockCursor(this.positionCount, this.slice);
        }
        if (type == TupleInfo.Type.VARIABLE_BINARY) {
            return new UncompressedSliceBlockCursor(this.positionCount, this.slice);
        }
        throw new IllegalStateException("Unsupported type " + type);
    }

    @Override
    public UncompressedBlockEncoding getEncoding() {
        return new UncompressedBlockEncoding(this.tupleInfo);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        Preconditions.checkPositionIndexes((int)positionOffset, (int)(positionOffset + length), (int)this.positionCount);
        return this.cursor().getRegionAndAdvance(length);
    }

    @Override
    public RandomAccessBlock toRandomAccessBlock() {
        TupleInfo.Type type = this.tupleInfo.getType();
        if (type == TupleInfo.Type.BOOLEAN) {
            return new UncompressedBooleanBlock(this.positionCount, this.slice);
        }
        if (type == TupleInfo.Type.FIXED_INT_64) {
            return new UncompressedLongBlock(this.slice);
        }
        if (type == TupleInfo.Type.DOUBLE) {
            return new UncompressedDoubleBlock(this.positionCount, this.slice);
        }
        if (type == TupleInfo.Type.VARIABLE_BINARY) {
            return new UncompressedSliceBlock(this);
        }
        throw new IllegalStateException("Unsupported type " + this.tupleInfo.getType());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("tupleInfo", (Object)this.tupleInfo).add("slice", (Object)this.slice).toString();
    }
}

