/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.uncompressed;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.RandomAccessBlock;
import com.facebook.presto.block.uncompressed.UncompressedBooleanBlockCursor;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.UncompressedBlockEncoding;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;

public class UncompressedBooleanBlock
implements RandomAccessBlock {
    private static final int ENTRY_SIZE = 2;
    private final Slice slice;
    private final int positionCount;

    public UncompressedBooleanBlock(int positionCount, Slice slice) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        Preconditions.checkNotNull((Object)positionCount, (Object)"positionCount is null");
        this.positionCount = positionCount;
        this.slice = slice;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return TupleInfo.SINGLE_BOOLEAN;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public DataSize getDataSize() {
        return new DataSize((double)this.slice.length(), DataSize.Unit.BYTE);
    }

    @Override
    public BlockCursor cursor() {
        return new UncompressedBooleanBlockCursor(this.positionCount, this.slice);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new UncompressedBlockEncoding(TupleInfo.SINGLE_BOOLEAN);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        Preconditions.checkPositionIndexes((int)positionOffset, (int)(positionOffset + length), (int)this.positionCount);
        return this.cursor().getRegionAndAdvance(length);
    }

    @Override
    public RandomAccessBlock toRandomAccessBlock() {
        return this;
    }

    @Override
    public boolean getBoolean(int position) {
        this.checkReadablePosition(position);
        return this.slice.getByte(position * 2 + 1) != 0;
    }

    @Override
    public long getLong(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.slice.getByte(position * 2) != 0;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("slice", (Object)this.slice).toString();
    }

    private void checkReadablePosition(int position) {
        Preconditions.checkState((position > 0 && position < this.positionCount ? 1 : 0) != 0, (Object)"position is not valid");
    }
}

