/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.uncompressed;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.RandomAccessBlock;
import com.facebook.presto.block.uncompressed.UncompressedLongBlockCursor;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.UncompressedBlockEncoding;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;

public class UncompressedLongBlock
implements RandomAccessBlock {
    private static final int ENTRY_SIZE = 9;
    private final Slice slice;

    public UncompressedLongBlock(Slice slice) {
        this.slice = (Slice)Preconditions.checkNotNull((Object)slice, (Object)"slice is null");
        Preconditions.checkArgument((slice.length() % 9 == 0 ? 1 : 0) != 0);
    }

    @Override
    public TupleInfo getTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public int getPositionCount() {
        return this.slice.length() / 9;
    }

    @Override
    public DataSize getDataSize() {
        return new DataSize((double)this.slice.length(), DataSize.Unit.BYTE);
    }

    @Override
    public BlockCursor cursor() {
        return new UncompressedLongBlockCursor(this.getPositionCount(), this.slice);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new UncompressedBlockEncoding(TupleInfo.SINGLE_LONG);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        Preconditions.checkPositionIndexes((int)positionOffset, (int)(positionOffset + length), (int)this.getPositionCount());
        return this.cursor().getRegionAndAdvance(length);
    }

    @Override
    public RandomAccessBlock toRandomAccessBlock() {
        return this;
    }

    @Override
    public boolean getBoolean(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int position) {
        int entryOffset = position * 9;
        Preconditions.checkState((position >= 0 && entryOffset + 9 <= this.slice.length() ? 1 : 0) != 0, (Object)"position is not valid");
        return this.slice.getLong(entryOffset + 1);
    }

    @Override
    public double getDouble(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNull(int position) {
        int entryOffset = position * 9;
        Preconditions.checkState((position >= 0 && entryOffset + 9 <= this.slice.length() ? 1 : 0) != 0, (Object)"position is not valid");
        return this.slice.getByte(entryOffset) != 0;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positionCount", this.getPositionCount()).add("slice", (Object)this.slice).toString();
    }
}

