/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.uncompressed;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class UncompressedLongBlockCursor
implements BlockCursor {
    private static final int ENTRY_SIZE = 9;
    private final Slice slice;
    private final int positionCount;
    private int position;
    private int offset;

    public UncompressedLongBlockCursor(int positionCount, Slice slice) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        Preconditions.checkNotNull((Object)positionCount, (Object)"positionCount is null");
        this.positionCount = positionCount;
        this.slice = slice;
        this.position = -1;
        this.offset = -9;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public int getRemainingPositions() {
        return this.positionCount - (this.position + 1);
    }

    @Override
    public boolean isValid() {
        return 0 <= this.position && this.position < this.positionCount;
    }

    @Override
    public boolean isFinished() {
        return this.position >= this.positionCount;
    }

    private void checkReadablePosition() {
        Preconditions.checkState((boolean)this.isValid(), (Object)"cursor is not valid");
    }

    @Override
    public boolean advanceNextPosition() {
        if (this.position >= this.positionCount - 1) {
            this.position = this.positionCount;
            return false;
        }
        ++this.position;
        this.offset += 9;
        return true;
    }

    @Override
    public boolean advanceToPosition(int newPosition) {
        if (newPosition >= this.positionCount) {
            this.position = this.positionCount;
            return false;
        }
        Preconditions.checkArgument((newPosition >= this.position ? 1 : 0) != 0, (Object)"Can't advance backwards");
        this.offset += (newPosition - this.position) * 9;
        this.position = newPosition;
        return true;
    }

    @Override
    public Block getRegionAndAdvance(int length) {
        int startOffset = this.offset + 9;
        length = Math.min(length, this.getRemainingPositions());
        this.offset += length * 9;
        this.position += length;
        Slice newSlice = this.slice.slice(startOffset, length * 9);
        return new UncompressedBlock(length, TupleInfo.SINGLE_LONG, newSlice);
    }

    @Override
    public int getPosition() {
        this.checkReadablePosition();
        return this.position;
    }

    @Override
    public Tuple getTuple() {
        this.checkReadablePosition();
        Slice copy = Slices.allocate((int)9);
        copy.setBytes(0, this.slice, this.offset, 9);
        return new Tuple(copy, TupleInfo.SINGLE_LONG);
    }

    @Override
    public boolean getBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong() {
        this.checkReadablePosition();
        return this.slice.getLong(this.offset + 1);
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNull() {
        this.checkReadablePosition();
        return this.slice.getByte(this.offset) != 0;
    }

    @Override
    public boolean currentTupleEquals(Tuple value) {
        this.checkReadablePosition();
        Slice tupleSlice = value.getTupleSlice();
        return tupleSlice.length() == 9 && this.slice.getLong(this.offset + 1) == tupleSlice.getLong(1);
    }

    @Override
    public int getRawOffset() {
        return this.offset;
    }

    @Override
    public Slice getRawSlice() {
        return this.slice;
    }

    @Override
    public void appendTupleTo(BlockBuilder blockBuilder) {
        blockBuilder.appendTuple(this.slice, this.offset, 9);
    }
}

