/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.uncompressed;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.block.RandomAccessBlock;
import com.facebook.presto.block.uncompressed.UncompressedBlock;
import com.facebook.presto.block.uncompressed.UncompressedSliceBlockCursor;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.UncompressedBlockEncoding;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;

public class UncompressedSliceBlock
implements RandomAccessBlock {
    private final Slice slice;
    private final int[] offsets;

    public UncompressedSliceBlock(UncompressedBlock block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkArgument((boolean)block.getTupleInfo().equals(TupleInfo.SINGLE_VARBINARY));
        this.offsets = new int[block.getPositionCount()];
        this.slice = block.getSlice();
        BlockCursor cursor = block.cursor();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            int offset;
            Preconditions.checkState((boolean)cursor.advanceNextPosition());
            this.offsets[position] = offset = cursor.getRawOffset();
        }
    }

    public UncompressedSliceBlock(Slice slice, int[] offsets) {
        Preconditions.checkNotNull((Object)slice, (Object)"slice is null");
        Preconditions.checkNotNull((Object)offsets, (Object)"offsets is null");
        this.slice = slice;
        this.offsets = offsets;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    @Override
    public int getPositionCount() {
        return this.offsets.length;
    }

    @Override
    public DataSize getDataSize() {
        return new DataSize((double)this.slice.length(), DataSize.Unit.BYTE);
    }

    @Override
    public BlockCursor cursor() {
        return new UncompressedSliceBlockCursor(this.offsets.length, this.slice);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new UncompressedBlockEncoding(TupleInfo.SINGLE_VARBINARY);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        Preconditions.checkPositionIndexes((int)positionOffset, (int)(positionOffset + length), (int)this.offsets.length);
        return this.cursor().getRegionAndAdvance(length);
    }

    @Override
    public RandomAccessBlock toRandomAccessBlock() {
        return this;
    }

    @Override
    public boolean getBoolean(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(int position) {
        this.checkReadablePosition(position);
        int offset = this.offsets[position];
        int size = this.slice.getInt(offset + 1);
        return this.slice.slice(offset + 4 + 1, size - 4 - 1);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        int offset = this.offsets[position];
        return this.slice.getByte(offset) != 0;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positionCount", this.offsets.length).add("slice", (Object)this.slice).toString();
    }

    private void checkReadablePosition(int position) {
        Preconditions.checkState((position > 0 && position < this.offsets.length ? 1 : 0) != 0, (Object)"position is not valid");
    }
}

