/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.AnnotationDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.ClassVisitor;

@NotThreadSafe
public class ClassDefinition {
    private final EnumSet<Access> access;
    private final ParameterizedType type;
    private final ParameterizedType superClass;
    private final List<ParameterizedType> interfaces = new ArrayList<ParameterizedType>();
    private final List<AnnotationDefinition> annotations = new ArrayList<AnnotationDefinition>();
    private final List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    private final List<MethodDefinition> methods = new ArrayList<MethodDefinition>();
    private final MethodDefinition classInitializer;
    private String source;
    private String debug;

    public ClassDefinition(CompilerContext compilerContext, EnumSet<Access> access, String name, ParameterizedType superClass, ParameterizedType ... interfaces) {
        this(compilerContext, access, new ParameterizedType(name), superClass, interfaces);
    }

    public ClassDefinition(CompilerContext compilerContext, EnumSet<Access> access, ParameterizedType type, ParameterizedType superClass, ParameterizedType ... interfaces) {
        Preconditions.checkNotNull(access, (Object)"access is null");
        Preconditions.checkNotNull(access, (Object)"access is null");
        Preconditions.checkNotNull((Object)superClass, (Object)"superClass is null");
        Preconditions.checkNotNull((Object)interfaces, (Object)"interfaces is null");
        this.access = access;
        this.type = type;
        this.superClass = superClass;
        this.interfaces.addAll((Collection<ParameterizedType>)ImmutableList.copyOf((Object[])interfaces));
        this.classInitializer = new MethodDefinition(compilerContext, this, Access.a(Access.STATIC), "<clinit>", ParameterizedType.type(Void.TYPE), (Iterable<NamedParameterDefinition>)ImmutableList.of());
    }

    public Set<Access> getAccess() {
        return ImmutableSet.copyOf(this.access);
    }

    public String getName() {
        return this.type.getClassName();
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public ParameterizedType getSuperClass() {
        return this.superClass;
    }

    public String getSource() {
        return this.source;
    }

    public List<ParameterizedType> getInterfaces() {
        return ImmutableList.copyOf(this.interfaces);
    }

    public List<AnnotationDefinition> getAnnotations() {
        return ImmutableList.copyOf(this.annotations);
    }

    public List<FieldDefinition> getFields() {
        return ImmutableList.copyOf(this.fields);
    }

    public List<MethodDefinition> getMethods() {
        return ImmutableList.copyOf(this.methods);
    }

    public void visit(ClassVisitor visitor) {
        String signature = null;
        if (this.superClass.isGeneric() || Iterables.any(this.interfaces, ParameterizedType.isGenericType())) {
            signature = ClassDefinition.genericClassSignature(this.superClass, this.interfaces);
        }
        String[] interfaces = new String[this.interfaces.size()];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = this.interfaces.get(i).getClassName();
        }
        visitor.visit(51, Access.toAccessModifier(this.access) | 0x20, this.type.getClassName(), signature, this.superClass.getClassName(), interfaces);
        if (this.source != null) {
            visitor.visitSource(this.source, this.debug);
        }
        for (AnnotationDefinition annotation : this.annotations) {
            annotation.visitClassAnnotation(visitor);
        }
        for (FieldDefinition field : this.fields) {
            field.visit(visitor);
        }
        this.classInitializer.visit(visitor, true);
        for (MethodDefinition method : this.methods) {
            method.visit(visitor);
        }
        visitor.visitEnd();
    }

    public AnnotationDefinition declareAnnotation(Class<?> type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareAnnotation(ParameterizedType type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public FieldDefinition declareField(EnumSet<Access> access, String name, Class<?> type) {
        FieldDefinition fieldDefinition = new FieldDefinition(this, access, name, type);
        this.fields.add(fieldDefinition);
        return fieldDefinition;
    }

    public ClassDefinition addField(EnumSet<Access> access, String name, Class<?> type) {
        this.declareField(access, name, type);
        return this;
    }

    public FieldDefinition declareField(EnumSet<Access> access, String name, ParameterizedType type) {
        FieldDefinition fieldDefinition = new FieldDefinition(this, access, name, type);
        this.fields.add(fieldDefinition);
        return fieldDefinition;
    }

    public ClassDefinition addField(EnumSet<Access> access, String name, ParameterizedType type) {
        this.declareField(access, name, type);
        return this;
    }

    public ClassDefinition addField(FieldDefinition field) {
        this.fields.add(field);
        return this;
    }

    public MethodDefinition getClassInitializer() {
        return this.classInitializer;
    }

    public MethodDefinition declareConstructor(CompilerContext compilerContext, EnumSet<Access> access, NamedParameterDefinition ... parameters) {
        return this.declareMethod(compilerContext, access, "<init>", ParameterizedType.type(Void.TYPE), (Iterable<NamedParameterDefinition>)ImmutableList.copyOf((Object[])parameters));
    }

    public MethodDefinition declareConstructor(CompilerContext compilerContext, EnumSet<Access> access, Iterable<NamedParameterDefinition> parameters) {
        return this.declareMethod(compilerContext, access, "<init>", ParameterizedType.type(Void.TYPE), (Iterable<NamedParameterDefinition>)ImmutableList.copyOf(parameters));
    }

    public ClassDefinition addMethod(MethodDefinition method) {
        this.methods.add(method);
        return this;
    }

    public ClassDefinition visitSource(String source, String debug) {
        this.source = source;
        this.debug = debug;
        return this;
    }

    public MethodDefinition declareMethod(CompilerContext compilerContext, EnumSet<Access> access, String name, ParameterizedType returnType, NamedParameterDefinition ... parameters) {
        MethodDefinition methodDefinition = new MethodDefinition(compilerContext, this, access, name, returnType, (Iterable<NamedParameterDefinition>)ImmutableList.copyOf((Object[])parameters));
        this.methods.add(methodDefinition);
        return methodDefinition;
    }

    public MethodDefinition declareMethod(CompilerContext compilerContext, EnumSet<Access> access, String name, ParameterizedType returnType, Iterable<NamedParameterDefinition> parameters) {
        MethodDefinition methodDefinition = new MethodDefinition(compilerContext, this, access, name, returnType, parameters);
        this.methods.add(methodDefinition);
        return methodDefinition;
    }

    public static String genericClassSignature(ParameterizedType classType, ParameterizedType ... interfaceTypes) {
        return Joiner.on((String)"").join(Iterables.concat((Iterable)ImmutableList.of((Object)classType), (Iterable)ImmutableList.copyOf((Object[])interfaceTypes)));
    }

    public static String genericClassSignature(ParameterizedType classType, List<ParameterizedType> interfaceTypes) {
        return Joiner.on((String)"").join(Iterables.concat((Iterable)ImmutableList.of((Object)classType), interfaceTypes));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassDefinition");
        sb.append("{access=").append(this.access);
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

