/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.AnnotationDefinition;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.debug.LocalVariableNode;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.InsnNode;

@NotThreadSafe
public class MethodDefinition {
    private final CompilerContext compilerContext;
    private final ClassDefinition declaringClass;
    private final EnumSet<Access> access;
    private final String name;
    private final List<AnnotationDefinition> annotations = new ArrayList<AnnotationDefinition>();
    private final ParameterizedType returnType;
    private final List<NamedParameterDefinition> parameters;
    private final List<ParameterizedType> parameterTypes;
    private final List<List<AnnotationDefinition>> parameterAnnotations;
    private final List<ParameterizedType> exceptions = new ArrayList<ParameterizedType>();
    private final List<LocalVariableNode> localVariableNodes = new ArrayList<LocalVariableNode>();
    private final Block body;
    private String comment;

    public MethodDefinition(CompilerContext compilerContext, ClassDefinition declaringClass, EnumSet<Access> access, String name, ParameterizedType returnType, NamedParameterDefinition ... parameters) {
        this(compilerContext, declaringClass, access, name, returnType, (Iterable<NamedParameterDefinition>)ImmutableList.copyOf((Object[])parameters));
    }

    public MethodDefinition(CompilerContext compilerContext, ClassDefinition declaringClass, EnumSet<Access> access, String name, ParameterizedType returnType, Iterable<NamedParameterDefinition> parameters) {
        this.compilerContext = compilerContext;
        this.declaringClass = declaringClass;
        this.body = new Block(compilerContext);
        this.access = access;
        this.name = name;
        this.returnType = returnType != null ? returnType : ParameterizedType.type(Void.TYPE);
        this.parameters = ImmutableList.copyOf(parameters);
        this.parameterTypes = Lists.transform(this.parameters, NamedParameterDefinition.getNamedParameterType());
        this.parameterAnnotations = ImmutableList.copyOf((Iterable)Iterables.transform(parameters, (Function)new Function<NamedParameterDefinition, List<AnnotationDefinition>>(){

            public List<AnnotationDefinition> apply(@Nullable NamedParameterDefinition input) {
                return new ArrayList<AnnotationDefinition>();
            }
        }));
        if (!access.contains((Object)Access.STATIC)) {
            this.getCompilerContext().declareThisVariable(ParameterizedType.type(Object.class));
        }
        int argId = 0;
        for (NamedParameterDefinition parameter : parameters) {
            String parameterName = parameter.getName();
            if (parameterName == null) {
                parameterName = "arg" + argId;
            }
            this.getCompilerContext().declareParameter(parameter.getType(), parameterName);
            ++argId;
        }
    }

    public ClassDefinition getDeclaringClass() {
        return this.declaringClass;
    }

    public List<AnnotationDefinition> getAnnotations() {
        return ImmutableList.copyOf(this.annotations);
    }

    public List<AnnotationDefinition> getParameterAnnotations(int index) {
        return ImmutableList.copyOf((Collection)this.parameterAnnotations.get(index));
    }

    public EnumSet<Access> getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public ParameterizedType getReturnType() {
        return this.returnType;
    }

    public List<NamedParameterDefinition> getParameters() {
        return this.parameters;
    }

    public List<ParameterizedType> getParameterTypes() {
        return this.parameterTypes;
    }

    public List<ParameterizedType> getExceptions() {
        return this.exceptions;
    }

    public MethodDefinition addException(Class<? extends Throwable> exceptionClass) {
        this.exceptions.add(ParameterizedType.type(exceptionClass));
        return this;
    }

    public MethodDefinition comment(String format, Object ... args) {
        this.comment = String.format(format, args);
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    public String getMethodDescriptor() {
        return MethodDefinition.methodDescription(this.returnType, this.parameterTypes);
    }

    public Block getBody() {
        return this.body;
    }

    public AnnotationDefinition declareAnnotation(Class<?> type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareAnnotation(ParameterizedType type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareParameterAnnotation(Class<?> type, int parameterIndex) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.parameterAnnotations.get(parameterIndex).add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareParameterAnnotation(ParameterizedType type, int parameterIndex) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.parameterAnnotations.get(parameterIndex).add(annotationDefinition);
        return annotationDefinition;
    }

    public void visit(ClassVisitor visitor) {
        this.visit(visitor, false);
    }

    public void visit(ClassVisitor visitor, boolean addReturn) {
        String[] exceptions = new String[this.exceptions.size()];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = this.exceptions.get(i).getClassName();
        }
        MethodVisitor methodVisitor = visitor.visitMethod(Access.toAccessModifier(this.access), this.name, this.getMethodDescriptor(), MethodDefinition.genericMethodSignature(this.returnType, this.parameterTypes), exceptions);
        if (methodVisitor == null) {
            return;
        }
        for (AnnotationDefinition annotation : this.annotations) {
            annotation.visitMethodAnnotation(methodVisitor);
        }
        for (int parameterIndex = 0; parameterIndex < this.parameterAnnotations.size(); ++parameterIndex) {
            List<AnnotationDefinition> parameterAnnotations1 = this.parameterAnnotations.get(parameterIndex);
            for (AnnotationDefinition parameterAnnotation : parameterAnnotations1) {
                parameterAnnotation.visitParameterAnnotation(parameterIndex, methodVisitor);
            }
        }
        methodVisitor.visitCode();
        this.body.accept(methodVisitor);
        if (addReturn) {
            new InsnNode(177).accept(methodVisitor);
        }
        for (LocalVariableNode localVariableNode : this.localVariableNodes) {
            localVariableNode.accept(methodVisitor);
        }
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    public static String methodDescription(Class<?> returnType, Class<?> ... parameterTypes) {
        return MethodDefinition.methodDescription(returnType, ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String methodDescription(Class<?> returnType, List<Class<?>> parameterTypes) {
        return MethodDefinition.methodDescription(ParameterizedType.type(returnType), Lists.transform(parameterTypes, ParameterizedType.toParameterizedType()));
    }

    public static String methodDescription(ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return MethodDefinition.methodDescription(returnType, (List<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String methodDescription(ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Joiner.on((String)"").appendTo(sb, Iterables.transform(parameterTypes, ParameterizedType.getParameterType()));
        sb.append(")");
        sb.append(returnType.getType());
        return sb.toString();
    }

    public static String genericMethodSignature(ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        return MethodDefinition.genericMethodSignature(returnType, (List<ParameterizedType>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public static String genericMethodSignature(ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Joiner.on((String)"").appendTo(sb, parameterTypes);
        sb.append(")");
        sb.append(returnType);
        return sb.toString();
    }

    public void addLocalVariable(LocalVariableDefinition localVariable, LabelNode start, LabelNode end) {
        this.localVariableNodes.add(new LocalVariableNode(localVariable, start, end));
    }
}

