/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.objectweb.asm.Type;

@Immutable
public class ParameterizedType {
    private final String type;
    private final String className;
    private final List<String> parameters;

    public static ParameterizedType typeFromJavaClassName(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"type is null");
        if (className.endsWith("/")) {
            Preconditions.checkArgument((!className.endsWith(";") ? 1 : 0) != 0, (String)"Invalid class name %s", (Object[])new Object[]{className});
        }
        return new ParameterizedType(className.replace('.', '/'));
    }

    public static ParameterizedType typeFromPathName(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"type is null");
        if (className.indexOf(".") > 0) {
            Preconditions.checkArgument((!className.endsWith(";") ? 1 : 0) != 0, (String)"Invalid class name %s", (Object[])new Object[]{className});
        }
        return new ParameterizedType(className);
    }

    public static ParameterizedType type(Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        return new ParameterizedType(type.getInternalName());
    }

    public static ParameterizedType type(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new ParameterizedType(type);
    }

    public static ParameterizedType type(Class<?> type, Class<?> ... parameters) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new ParameterizedType(type, parameters);
    }

    public static ParameterizedType type(Class<?> type, ParameterizedType ... parameters) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new ParameterizedType(type, parameters);
    }

    public ParameterizedType(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"className is null");
        if (className.indexOf(".") > 0) {
            Preconditions.checkArgument((!className.endsWith(";") ? 1 : 0) != 0, (String)"Invalid class name %s", (Object[])new Object[]{className});
        }
        if (className.endsWith(";")) {
            Preconditions.checkArgument((!className.endsWith(";") ? 1 : 0) != 0, (String)"Invalid class name %s", (Object[])new Object[]{className});
        }
        this.className = className;
        this.type = "L" + className + ";";
        this.parameters = ImmutableList.of();
    }

    private ParameterizedType(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        this.parameters = ImmutableList.of();
    }

    private ParameterizedType(Class<?> type, Class<?> ... parameters) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> parameter : parameters) {
            builder.add((Object)ParameterizedType.toInternalIdentifier(parameter));
        }
        this.parameters = builder.build();
    }

    private ParameterizedType(Class<?> type, ParameterizedType ... parameters) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.type = ParameterizedType.toInternalIdentifier(type);
        this.className = ParameterizedType.getPathName(type);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ParameterizedType parameter : parameters) {
            builder.add((Object)parameter.toString());
        }
        this.parameters = builder.build();
    }

    public String getClassName() {
        return this.className;
    }

    public String getJavaClassName() {
        return this.className.replace('/', '.');
    }

    public String getType() {
        return this.type;
    }

    public Type getAsmType() {
        return Type.getObjectType((String)this.className);
    }

    public String getGenericSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append('L').append(this.className);
        if (!this.parameters.isEmpty()) {
            sb.append("<");
            for (String parameterType : this.parameters) {
                sb.append(parameterType);
            }
            sb.append(">");
        }
        sb.append(";");
        return sb.toString();
    }

    public boolean isGeneric() {
        return !this.parameters.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedType that = (ParameterizedType)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.getGenericSignature();
    }

    public static String getPathName(Class<?> n) {
        return n.getName().replace('.', '/');
    }

    private static String toInternalIdentifier(Class<?> n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Short.TYPE) {
                    return "[S";
                }
                if (n == Character.TYPE) {
                    return "[C";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Float.TYPE) {
                    return "[F";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + ParameterizedType.toInternalIdentifier(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Short.TYPE) {
                return "S";
            }
            if (n == Character.TYPE) {
                return "C";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Float.TYPE) {
                return "F";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + ParameterizedType.getPathName(n) + ";";
    }

    public static Predicate<ParameterizedType> isGenericType() {
        return new Predicate<ParameterizedType>(){

            public boolean apply(ParameterizedType input) {
                return input.isGeneric();
            }
        };
    }

    public static Function<ParameterizedType, String> getParameterType() {
        return new Function<ParameterizedType, String>(){

            public String apply(ParameterizedType input) {
                return input.getType();
            }
        };
    }

    public static Function<Class<?>, ParameterizedType> toParameterizedType() {
        return new Function<Class<?>, ParameterizedType>(){

            public ParameterizedType apply(@Nullable Class<?> input) {
                return new ParameterizedType((Class)input);
            }
        };
    }

    public static Function<String, ParameterizedType> pathToParameterizedType() {
        return new Function<String, ParameterizedType>(){

            public ParameterizedType apply(@Nullable String input) {
                return ParameterizedType.typeFromPathName(input);
            }
        };
    }
}

