/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.control.CaseStatement;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class LookupSwitch
implements FlowControl {
    private final String comment;
    private final LabelNode defaultCase;
    private final SortedSet<CaseStatement> cases;

    public static LookupSwitchBuilder lookupSwitchBuilder() {
        return new LookupSwitchBuilder();
    }

    private LookupSwitch(String comment, LabelNode defaultCase, Iterable<CaseStatement> cases) {
        this.comment = comment;
        this.defaultCase = defaultCase;
        this.cases = ImmutableSortedSet.copyOf(cases);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public SortedSet<CaseStatement> getCases() {
        return this.cases;
    }

    public LabelNode getDefaultCase() {
        return this.defaultCase;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        int[] keys = new int[this.cases.size()];
        Label[] labels = new Label[this.cases.size()];
        int index = 0;
        for (CaseStatement caseStatement : this.cases) {
            keys[index] = caseStatement.getKey();
            labels[index] = caseStatement.getLabel().getLabel();
            ++index;
        }
        visitor.visitLookupSwitchInsn(this.defaultCase.getLabel(), keys, labels);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitLookupSwitch(parent, this);
    }

    public static class LookupSwitchBuilder {
        private final List<CaseStatement> cases = new ArrayList<CaseStatement>();
        private String comment;
        private LabelNode defaultCase;

        public LookupSwitchBuilder defaultCase(LabelNode defaultCase) {
            this.defaultCase = defaultCase;
            return this;
        }

        public LookupSwitchBuilder comment(String format, Object ... args) {
            this.comment = String.format(format, args);
            return this;
        }

        public LookupSwitchBuilder addCase(int key, LabelNode label) {
            this.cases.add(CaseStatement.caseStatement(key, label));
            return this;
        }

        public LookupSwitchBuilder addCase(CaseStatement caseStatement) {
            this.cases.add(caseStatement);
            return this;
        }

        public LookupSwitch build() {
            return new LookupSwitch(this.comment, this.defaultCase, this.cases);
        }
    }
}

