/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.debug;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.debug.DebugNode;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class LocalVariableNode
implements DebugNode {
    private final LocalVariableDefinition variable;
    private final LabelNode start;
    private final LabelNode end;

    public LocalVariableNode(LocalVariableDefinition variable, LabelNode start, LabelNode end) {
        this.variable = variable;
        this.start = start;
        this.end = end;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        visitor.visitLocalVariable(this.variable.getName(), this.variable.getType().getType(), this.variable.getType().getGenericSignature(), this.start.getLabel(), this.end.getLabel(), this.variable.getSlot());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("variable", (Object)this.variable).add("start", (Object)this.start).add("end", (Object)this.end).toString();
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitLocalVariable(parent, this);
    }
}

