/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.instruction;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.instruction.FieldInstruction;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class Constant
implements InstructionNode {
    public static InstructionNode loadNull() {
        return OpCodes.ACONST_NULL;
    }

    public static InstructionNode loadBoolean(boolean value) {
        return new IntConstant(value ? 1 : 0);
    }

    public static InstructionNode loadBoxedBoolean(boolean value) {
        return new BoxedBooleanConstant(value);
    }

    public static InstructionNode loadInt(int value) {
        return new IntConstant(value);
    }

    public static InstructionNode loadBoxedInt(int value) {
        return new BoxedIntegerConstant(value);
    }

    public static InstructionNode loadFloat(float value) {
        return new FloatConstant(value);
    }

    public static InstructionNode loadBoxedFloat(float value) {
        return new BoxedFloatConstant(value);
    }

    public static InstructionNode loadLong(long value) {
        return new LongConstant(value);
    }

    public static InstructionNode loadBoxedLong(long value) {
        return new BoxedLongConstant(value);
    }

    public static InstructionNode loadDouble(double value) {
        return new DoubleConstant(value);
    }

    public static InstructionNode loadBoxedDouble(double value) {
        return new BoxedDoubleConstant(value);
    }

    public static InstructionNode loadNumber(Number value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        if (value instanceof Byte) {
            return Constant.loadInt(value.intValue());
        }
        if (value instanceof Short) {
            return Constant.loadInt(value.intValue());
        }
        if (value instanceof Integer) {
            return Constant.loadInt((Integer)value);
        }
        if (value instanceof Long) {
            return Constant.loadLong((Long)value);
        }
        if (value instanceof Float) {
            return Constant.loadFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Constant.loadDouble((Double)value);
        }
        throw new IllegalStateException("Unsupported number type " + value.getClass().getSimpleName());
    }

    public static InstructionNode loadString(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return new StringConstant(value);
    }

    public static InstructionNode loadClass(Class<?> value) {
        Preconditions.checkNotNull(value, (Object)"value is null");
        return new ClassConstant(ParameterizedType.type(value));
    }

    public static InstructionNode loadClass(ParameterizedType value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return new ClassConstant(value);
    }

    public abstract Object getValue();

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitConstant(parent, this);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("value", this.getValue()).toString();
    }

    public static class ClassConstant
    extends Constant {
        private final ParameterizedType value;

        private ClassConstant(ParameterizedType value) {
            this.value = value;
        }

        @Override
        public ParameterizedType getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            visitor.visitLdcInsn((Object)Type.getType((String)this.value.getType()));
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitClassConstant(parent, this);
        }
    }

    public static class StringConstant
    extends Constant {
        private final String value;

        private StringConstant(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            visitor.visitLdcInsn((Object)this.value);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitStringConstant(parent, this);
        }
    }

    public static class BoxedDoubleConstant
    extends Constant {
        private final double value;

        private BoxedDoubleConstant(double value) {
            this.value = value;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            BoxedDoubleConstant.loadDouble(this.value).accept(visitor);
            InvokeInstruction.invokeStatic(Double.class, "valueOf", Double.class, Double.TYPE).accept(visitor);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedDoubleConstant(parent, this);
        }
    }

    public static class DoubleConstant
    extends Constant {
        private final double value;

        private DoubleConstant(double value) {
            this.value = value;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            if (Double.doubleToLongBits(this.value) == Double.doubleToLongBits(0.0)) {
                visitor.visitInsn(OpCodes.DCONST_0.getOpCode());
            } else if (this.value == 1.0) {
                visitor.visitInsn(OpCodes.DCONST_1.getOpCode());
            } else {
                visitor.visitLdcInsn((Object)this.value);
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitDoubleConstant(parent, this);
        }
    }

    public static class BoxedLongConstant
    extends Constant {
        private final long value;

        private BoxedLongConstant(long value) {
            this.value = value;
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            BoxedLongConstant.loadLong(this.value).accept(visitor);
            InvokeInstruction.invokeStatic(Long.class, "valueOf", Long.class, Long.TYPE).accept(visitor);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedLongConstant(parent, this);
        }
    }

    public static class LongConstant
    extends Constant {
        private final long value;

        private LongConstant(long value) {
            this.value = value;
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            if (this.value == 0L) {
                visitor.visitInsn(OpCodes.LCONST_0.getOpCode());
            } else if (this.value == 1L) {
                visitor.visitInsn(OpCodes.LCONST_1.getOpCode());
            } else {
                visitor.visitLdcInsn((Object)this.value);
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitLongConstant(parent, this);
        }
    }

    public static class BoxedFloatConstant
    extends Constant {
        private final float value;

        private BoxedFloatConstant(float value) {
            this.value = value;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public void accept(MethodVisitor visitor) {
            BoxedFloatConstant.loadFloat(this.value).accept(visitor);
            InvokeInstruction.invokeStatic(Float.class, "valueOf", Float.class, Float.TYPE).accept(visitor);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedFloatConstant(parent, this);
        }
    }

    public static class FloatConstant
    extends Constant {
        private final float value;

        private FloatConstant(float value) {
            this.value = value;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public void accept(MethodVisitor visitor) {
            if (Float.floatToIntBits(this.value) == Float.floatToIntBits(0.0f)) {
                visitor.visitInsn(OpCodes.FCONST_0.getOpCode());
            } else if (this.value == 1.0f) {
                visitor.visitInsn(OpCodes.FCONST_1.getOpCode());
            } else if (this.value == 2.0f) {
                visitor.visitInsn(OpCodes.FCONST_2.getOpCode());
            } else {
                visitor.visitLdcInsn((Object)Float.valueOf(this.value));
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitFloatConstant(parent, this);
        }
    }

    public static class BoxedIntegerConstant
    extends Constant {
        private final int value;

        private BoxedIntegerConstant(int value) {
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            BoxedIntegerConstant.loadInt(this.value).accept(visitor);
            InvokeInstruction.invokeStatic(Integer.class, "valueOf", Integer.class, Integer.TYPE).accept(visitor);
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedIntegerConstant(parent, this);
        }
    }

    public static class IntConstant
    extends Constant {
        private final int value;

        private IntConstant(int value) {
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            if (this.value <= 127 && this.value >= -128) {
                switch (this.value) {
                    case -1: {
                        visitor.visitInsn(OpCodes.ICONST_M1.getOpCode());
                        break;
                    }
                    case 0: {
                        visitor.visitInsn(OpCodes.ICONST_0.getOpCode());
                        break;
                    }
                    case 1: {
                        visitor.visitInsn(OpCodes.ICONST_1.getOpCode());
                        break;
                    }
                    case 2: {
                        visitor.visitInsn(OpCodes.ICONST_2.getOpCode());
                        break;
                    }
                    case 3: {
                        visitor.visitInsn(OpCodes.ICONST_3.getOpCode());
                        break;
                    }
                    case 4: {
                        visitor.visitInsn(OpCodes.ICONST_4.getOpCode());
                        break;
                    }
                    case 5: {
                        visitor.visitInsn(OpCodes.ICONST_5.getOpCode());
                        break;
                    }
                    default: {
                        visitor.visitIntInsn(OpCodes.BIPUSH.getOpCode(), this.value);
                        break;
                    }
                }
            } else if (this.value <= Short.MAX_VALUE && this.value >= Short.MIN_VALUE) {
                visitor.visitIntInsn(OpCodes.SIPUSH.getOpCode(), this.value);
            } else {
                visitor.visitLdcInsn((Object)this.value);
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitIntConstant(parent, this);
        }
    }

    public static class BoxedBooleanConstant
    extends Constant {
        private final boolean value;

        private BoxedBooleanConstant(boolean value) {
            this.value = value;
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }

        @Override
        public void accept(MethodVisitor visitor) {
            if (this.value) {
                FieldInstruction.getStaticInstruction(Boolean.class, "TRUE", Boolean.class).accept(visitor);
            } else {
                FieldInstruction.getStaticInstruction(Boolean.class, "FALSE", Boolean.class).accept(visitor);
            }
        }

        @Override
        public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
            return visitor.visitBoxedBooleanConstant(parent, this);
        }
    }
}

