/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.instruction;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class TypeInstruction
implements InstructionNode {
    private final OpCodes opCode;
    private final ParameterizedType type;

    public static InstructionNode newObject(Class<?> type) {
        return new TypeInstruction(OpCodes.NEW, ParameterizedType.type(type));
    }

    public static InstructionNode newObject(ParameterizedType type) {
        return new TypeInstruction(OpCodes.NEW, type);
    }

    public static InstructionNode newObjectArray(Class<?> type) {
        return new TypeInstruction(OpCodes.ANEWARRAY, ParameterizedType.type(type));
    }

    public static InstructionNode newObjectArray(ParameterizedType type) {
        return new TypeInstruction(OpCodes.ANEWARRAY, type);
    }

    public static InstructionNode instanceOf(Class<?> type) {
        return new TypeInstruction(OpCodes.INSTANCEOF, ParameterizedType.type(type));
    }

    public static InstructionNode instanceOf(ParameterizedType type) {
        return new TypeInstruction(OpCodes.INSTANCEOF, type);
    }

    public static InstructionNode cast(Class<?> type) {
        return new TypeInstruction(OpCodes.CHECKCAST, ParameterizedType.type(type));
    }

    public static InstructionNode cast(ParameterizedType type) {
        return new TypeInstruction(OpCodes.CHECKCAST, type);
    }

    public TypeInstruction(OpCodes opCode, ParameterizedType type) {
        this.opCode = opCode;
        this.type = type;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        visitor.visitTypeInsn(this.opCode.getOpCode(), this.type.getClassName());
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitInstruction(parent, this);
    }
}

