/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.connector.InternalConnector;
import com.facebook.presto.metadata.NativeHandleResolver;
import com.facebook.presto.metadata.NativeMetadata;
import com.facebook.presto.metadata.NativeRecordSinkProvider;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputHandleResolver;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.NativeDataStreamProvider;
import com.facebook.presto.split.NativeSplitManager;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;

public class NativeConnectorFactory
implements ConnectorFactory {
    private final NativeMetadata metadata;
    private final NativeSplitManager splitManager;
    private final NativeDataStreamProvider dataStreamProvider;
    private final NativeRecordSinkProvider recordSinkProvider;

    @Inject
    public NativeConnectorFactory(NativeMetadata metadata, NativeSplitManager splitManager, NativeDataStreamProvider dataStreamProvider, NativeRecordSinkProvider recordSinkProvider) {
        this.metadata = (NativeMetadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.splitManager = (NativeSplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
        this.dataStreamProvider = (NativeDataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
        this.recordSinkProvider = (NativeRecordSinkProvider)Preconditions.checkNotNull((Object)recordSinkProvider, (Object)"recordSinkProvider is null");
    }

    public String getName() {
        return "native";
    }

    public Connector create(String connectorId, Map<String, String> properties) {
        return new InternalConnector(){

            @Override
            public ConnectorDataStreamProvider getDataStreamProvider() {
                return NativeConnectorFactory.this.dataStreamProvider;
            }

            public ConnectorHandleResolver getHandleResolver() {
                return new NativeHandleResolver();
            }

            public ConnectorMetadata getMetadata() {
                return NativeConnectorFactory.this.metadata;
            }

            public ConnectorSplitManager getSplitManager() {
                return NativeConnectorFactory.this.splitManager;
            }

            public ConnectorRecordSinkProvider getRecordSinkProvider() {
                return NativeConnectorFactory.this.recordSinkProvider;
            }

            public ConnectorOutputHandleResolver getOutputHandleResolver() {
                return new NativeHandleResolver();
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

